#include <vcl>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <limits.h>
#include <time.h>
#include "disquete.h"

#define MAX(x,y) ((x)<(y) ? (y) : (x))

#pragma hdrstop

Disquete *cria_vetor_Disquete(int tam);
Arquivo *cria_vetor_Arquivo(int tam);
void libera_vetor_Disquete(Disquete *vetor);
void libera_vetor_Arquivo(Arquivo *vetor);
int le_arq_vetor(char nomearq[], Arquivo *vetor);
void ordena_vetor_Arquivo(Arquivo *vetor, int n_arqs);
void quicksort(Arquivo *vetor, int i, int j);
int divide (Arquivo *vetor, int pivo, int i0, int j0);
int calcula_inviabilidade(Disquete *d);
void ffd(Disquete *d, Arquivo *a, int n_arqs);
void bfd(Disquete *d, Arquivo *a, int n_arqs);
void SA(int n_disqs,
        int n_arqs,
        int disqMin,
        Disquete *s,
        Arquivo *a,
        int penalidade,
        int *fo,
        int *inv,
        double alfa,
        double temperatura_inicial,
        double temperatura_final,
        int SAmax);
void copia_solucao(Disquete *s, Disquete *s_star, int n_disqs);
int calcula_fo(Disquete *s, int n_disqs, int disqMin, int penalidade);
void cria_pior_solucao(Disquete *disqsPior, Arquivo *arqs, int n_arqs);
double randomico(double min, double max);
int menu_principal(void);
int menu_arquivos(void);
void escolheArquivo(int *n_arqs, Arquivo *arqs, int *maior, int *tamanhoTotal, int *n_disqs, int *disqMin);
void imprime_solucao(Disquete *s, int n_disqs);
void SAInv(int n_disqs,
           int n_arqs,
           int disqMin,
           Disquete *s,
           Arquivo *a,
           int penalidade,
           int *fo,
           int *inv,
           double alfa,
           double temperatura_inicial,
           double temperatura_final,
           int SAmax);
int calcula_inviabilidade(Disquete *d);
int calcula_foInv(Disquete *s, int n_disqs, int disqMin, int penalidade);

//---------------------------------------------------------------------------

#pragma argsused

//---------------------------------------------------------------------------
// MAIN
//---------------------------------------------------------------------------
int main(int argc, char* argv[])
{
    Arquivo *arqs;
    Disquete *disqs;
    int n_arqs = 0, n_disqs = 0;
    int maior = 0, tamanhoTotal = 0, disqMin = 0;
    int fo = 0;
    int inv = 10;
    int choice, choiceArq;
    char arquivoEntrada[20] = "";

    n_arqs = 0;

    srand((unsigned) time(NULL));

    choiceArq = menu_arquivos();

    switch (choiceArq) {
    case 1:
       n_arqs = 50;
       strcpy(arquivoEntrada, "Arquivos50.txt");
       break;
    case 2:
       n_arqs = 70;
       strcpy(arquivoEntrada, "Arquivos70.txt");
       break;
    case 3:
       n_arqs = 120;
       strcpy(arquivoEntrada, "Arquivos120.txt");
       break;
    case 4:
       n_arqs = 1000;
       strcpy(arquivoEntrada, "Arquivos1000.txt");
       break;
    }
    arqs = cria_vetor_Arquivo(n_arqs);
    maior = le_arq_vetor(arquivoEntrada, arqs);
    tamanhoTotal = 0;
    for(int i = 0; i < n_arqs; i++) {
       tamanhoTotal += arqs[i].tamanho;
    }
    disqMin = tamanhoTotal / CAP_DISQ;
    if (tamanhoTotal % CAP_DISQ > 0) disqMin++;
    n_disqs = n_arqs / (CAP_DISQ / maior);

    for(int i = 0; i < n_arqs; i++) {
       printf("%d - %d\n",arqs[i].indice,arqs[i].tamanho);
    }
    printf("Tamanho do Maior Arquivo = %d\n",maior);
    printf("Tamanho Total dos Arquivos = %d\n",tamanhoTotal);
    printf("Numero maximo de disquetes: %d\n",n_disqs);
    printf("Numero minimo de disquetes: %d\n\n",disqMin);
    getchar();

    int horaAnt=0, horaDep=0;

    do {

       choice = menu_principal();
       switch (choice) {

       case 1:
          printf("\n\n******************* Heuristica FFD *******************\n\n");
          disqs = cria_vetor_Disquete(n_disqs);
          ordena_vetor_Arquivo(arqs,n_arqs);
          horaAnt = time(NULL);
          ffd(disqs, arqs, n_arqs);
          horaDep = time(NULL);
          fo = calcula_fo(disqs, n_disqs, disqMin, 10);
          printf("fo = %d\n", fo);
          imprime_solucao(disqs, n_disqs);
          printf("Tempo: %d s\n", horaDep - horaAnt);
          libera_vetor_Disquete(disqs);
          break;

       case 2:
          printf("\n\n******************* Heuristica BFD *******************\n\n");
          disqs = cria_vetor_Disquete(n_disqs);
          ordena_vetor_Arquivo(arqs,n_arqs);
          horaAnt = time(NULL);
          bfd(disqs, arqs, n_arqs);
          horaDep = time(NULL);
          fo = calcula_fo(disqs, n_disqs, disqMin, 10);
          printf("fo = %d\n", fo);
          imprime_solucao(disqs, n_disqs);
          printf("Tempo: %d s", horaDep - horaAnt);
          libera_vetor_Disquete(disqs);
          break;

       case 3:
          printf("\n\n************** Simulated Annealing sem Inviabilidade **************\n\n");
          disqs = cria_vetor_Disquete(n_disqs);
          cria_pior_solucao(disqs,arqs,n_arqs);
          fo = calcula_fo(disqs, n_disqs, disqMin, 10);
          horaAnt = time(NULL);
          SA(n_disqs, n_arqs, disqMin, disqs, arqs, 10, &fo, &inv, 0.99, 100, 0.01, n_disqs * n_disqs);
          horaDep = time(NULL);
          imprime_solucao(disqs, n_disqs);
          printf("Tempo: %d s", horaDep - horaAnt);
          libera_vetor_Disquete(disqs);
          break;

       case 4:
          printf("\n\n************** Simulated Annealing com Inviabilidade **************\n\n");
          disqs = cria_vetor_Disquete(n_disqs);
          cria_pior_solucao(disqs,arqs,n_arqs);
          fo = calcula_foInv(disqs, n_disqs, disqMin, 10);
          horaAnt = time(NULL);
          SAInv(n_disqs, n_arqs, disqMin, disqs, arqs, 10, &fo, &inv, 0.99, 100, 0.01, n_disqs * n_disqs);
          horaDep = time(NULL);
          imprime_solucao(disqs, n_disqs);
          printf("Tempo: %d s", horaDep - horaAnt);
          libera_vetor_Disquete(disqs);
          break;

       case 5: //Saida
          break;

       default:
          break;
       }
    } while (choice != 5);

    libera_vetor_Arquivo(arqs);

    return 0;
}
// MAIN ----------------------------------------------------------------------

Disquete * cria_vetor_Disquete(int tam)
{
  Disquete *vetor;

  vetor = (Disquete *) malloc(tam*sizeof(Disquete));
  if (!vetor){
    printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  for (int i = 0; i < tam; i++) {
     vetor[i].lArq = NULL;
     vetor[i].numeroArq = 0;
     vetor[i].tamanhoTotal = 0;
  }
  return vetor;
}

Arquivo *cria_vetor_Arquivo(int tam)
{
  Arquivo *vetor;

  vetor = (Arquivo *) malloc(tam*sizeof(Arquivo));
  if (!vetor){
    printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}

/* libera memoria de um vetor */
void libera_vetor_Disquete(Disquete *vetor)
{
  free(vetor);
}

void libera_vetor_Arquivo(Arquivo *vetor)
{
  free(vetor);
}

/* l um arquivo texto, armazena em um vetor e retorna o maior tamanho de um arquivo*/
int le_arq_vetor(char nomearq[], Arquivo *vetor)
{
  int j = 0, tam = 0;
  int maior = 0;
  FILE *arqTxt;
  Arquivo *a;
  arqTxt = fopen(nomearq,"r");

  if (!arqTxt) {
     printf("O Arquivo %s nao pode ser aberto.\n", nomearq);
     getchar();
     exit(1);
  }
  while (!feof(arqTxt)){
    fscanf(arqTxt, "%d", &tam);
    if (tam <= CAP_DISQ) {
       if (tam > maior) maior = tam;
       a = (Arquivo *) malloc(sizeof(Arquivo));
       a->indice = j;
       a->tamanho = tam;
       vetor[j] = *a;
       j++;
    }
    else {
       printf("Arquivo excedeu o tamanho do Disquete!\n");
       getchar();
    }
  }
  fclose(arqTxt);
  return maior;
}

// Ordenar o vetor de arquivos, usando quicksort
void ordena_vetor_Arquivo(Arquivo *vetor, int n_arqs)
{
  quicksort(vetor, 0, n_arqs - 1);
}

void quicksort(Arquivo *vetor, int i, int j)
{
  if (i < j) {
    int pivo = vetor[(i+j) / 2].tamanho;
    int m = divide (vetor,pivo,i, j);
    quicksort(vetor,i,m);
    quicksort(vetor,m+1,j);
  }
}

int divide (Arquivo *vetor, int pivo, int i0, int j0)
{
  int i = i0-1, j = j0+1;
  Arquivo aux;

  do {
    do { i++; } while (vetor[i].tamanho < pivo);
    do { j--; } while (vetor[j].tamanho > pivo);
    if (i < j) {
       aux = vetor[i];
       vetor[i] = vetor[j];
       vetor[j] = aux;
    }
  } while (i < j);
  return j;
}

//Calcula quantos bytes excederam a capacidade de um disquete
int calcula_inviabilidade(Disquete *d)
{
    return MAX(0, d->tamanhoTotal - CAP_DISQ);
}

void ffd(Disquete *d, Arquivo *a, int n_arqs)
{
   int disqCorrente = 0, disqUtil = 0;
   int i = n_arqs - 1;
   while(i >= 0 ) {
      if((CAP_DISQ - d[disqCorrente].tamanhoTotal) >= a[i].tamanho) {
         insereArquivo(&(d[disqCorrente]),&(a[i]));
         disqCorrente = 0;
         i--;
      }
      else {
         disqCorrente++;
         if (disqUtil < disqCorrente) disqUtil = disqCorrente;
      }
   }
}

void bfd(Disquete *d, Arquivo *a, int n_arqs)
{
   int disqUtil = 0, maisCheio;
   int i = n_arqs - 1;
   while(i >= 0 ) {
      for(maisCheio = 0; (CAP_DISQ - d[maisCheio].tamanhoTotal) < a[i].tamanho; maisCheio++);
      for(int j = maisCheio + 1; j < disqUtil; j++) {
         if((d[j].tamanhoTotal > d[maisCheio].tamanhoTotal) &&
            ((CAP_DISQ - d[j].tamanhoTotal) >= a[i].tamanho)) maisCheio = j;
      }
      insereArquivo(&(d[maisCheio]),&(a[i]));
      if (disqUtil < maisCheio) disqUtil++;
      i--;
   }
}

void SA(int n_disqs,
        int n_arqs,
        int disqMin,
        Disquete *s,
        Arquivo *a,
        int penalidade,
        int *fo,
        int *inv,
        double alfa,
        double temperatura_inicial,
        double temperatura_final,
        int SAmax)
{
    double x;              // numero aleatorio entre ZERO e UM
    double temperatura;    // temperatura corrente
    int iter;              // numero de iteracoes na temperatura corrente
    int num_mudancas_temp; // numero de mudancas de temperatura
    int posEsc;            // disquete escolhido
    int delta;             // variacao de energia
    int posDest;
    int arqEsc;
    Disquete *s_star;
    int fo_star;

    s_star = cria_vetor_Disquete(n_disqs);
    copia_solucao(s, s_star, n_disqs);
    fo_star = *fo;

    temperatura = temperatura_inicial;
    num_mudancas_temp = 0;
    printf("Solucao inicial: fo corrente = %d\n",*fo);
    getchar();

    // enquanto o sistema nao congelar faca
    while (temperatura > temperatura_final & fo_star > 0) {
       iter = 0;
       // enquanto o equilibrio termico nao for atingido faca
       while (iter < SAmax){

          iter++;
          // escolha um vizinho qualquer

          do {
	     posEsc = random(n_disqs);
          }while(s[posEsc].numeroArq == 0);

          arqEsc = random(s[posEsc].numeroArq);
          Arquivo *a = retiraArquivo(&(s[posEsc]),arqEsc);
          do {
             posDest = random(n_disqs);
          }while (posDest == posEsc || a->tamanho >= (CAP_DISQ - s[posDest].tamanhoTotal));

          insereArquivo(&(s[posDest]), a);

	  // calcule a variacao de energia
          delta = calcula_fo(s, n_disqs, disqMin, penalidade) - *fo;

          // se houver melhora, aceite o vizinho
	  if (delta < 0){
	     *fo += delta;

             if (*fo < fo_star){
	  	copia_solucao(s, s_star, n_disqs);
		fo_star = *fo;
                printf("********** fo_star = %d \n",fo_star);
             }

	  }
	  else {
	      // se houver piora, aceite o vizinho com uma determinada
              //   probabilidade
	      x = randomico(0,1);
              if (x < exp(-delta/temperatura)){
	       	 *fo += delta;
              }
	      else {
               	// Se o vizinho nao foi aceito, desfaca o movimento
                insereArquivo(&(s[posEsc]),retiraArquivo(&(s[posDest]),0));
              }
	  }
        }

        // decresca a temperatura
        temperatura *= alfa;
        //printf("Temperatura atual = %10.3f\n", temperatura);
        num_mudancas_temp += 1;
    }

    printf("********* Melhor Solucao obtida pelo SA ************** \n");
    printf("funcao objetivo = %3d \n",fo_star);
    printf("Num. max. de solucoes analisadas = %ld \n",num_mudancas_temp*SAmax);
    printf("****************************************************** \n");
    copia_solucao(s_star, s, n_disqs);
    (*fo) = fo_star;
    libera_vetor_Disquete(s_star);
    getchar();
}

void copia_solucao(Disquete *s, Disquete *s1, int n_disqs)
{
   for (int i = 0; i < n_disqs; i++) {
      free(s1[i].lArq);
      s1[i].lArq = (lista_arquivo *) malloc(sizeof(lista_arquivo));
      s1[i].numeroArq = 0;
      s1[i].tamanhoTotal = 0;
      lista_arquivo *l = s[i].lArq;
      for(int j = 0; j < s[i].numeroArq; j++) {
         insereArquivo(&(s1[i]), l->arquivo);
         l = l->proximo;
      }
   }
}

/* calcula a funcao objetivo */
int calcula_fo(Disquete *s, int n_disqs, int disqMin, int penalidade)
{
    int disqUtil = 0;

    for (int j = 0; j < n_disqs; j++){
        if(s[j].numeroArq != 0) disqUtil++;
    }
    return disqUtil - disqMin;
}

void cria_pior_solucao(Disquete *dPior, Arquivo *a, int n_arqs)
{

    for (int i = 0; i < n_arqs; i++)
       insereArquivo(&(dPior[i]),&(a[i]));
}

/* Gera numero aleatorio entre min e max */
double randomico(double min, double max)
{
  if (min == max) return min;
  return ((double) (rand()%10000/10000.0)*(max-min) + min);
}

/* Menu principal */
int menu_principal(void)
{
  int escolha;

  do {
    printf("\n************************************************* \n");
    printf("         1. Heuristica FFD \n");
    printf("         2. Heuristica BFD \n");
    printf("         3. Simulated Annealing sem Inviabilidade\n");
    printf("         4. Simulated Annealing com Inviabilidade\n");
    printf("         5. Sair \n");
    printf("         Escolha: ");
    scanf("%d",&escolha);
  } while (escolha < 1 || escolha > 5);
  return escolha;
}

int menu_arquivos(void)
{
  int escolha;

  do {
    printf("\n************************************************* \n");
    printf("         Abrir Arquivo de entrada com:\n");
    printf("           1. 50 arquivos\n");
    printf("           2. 70 arquivos\n");
    printf("           3. 120 arquivos\n");
    printf("           4. 1000 arquivos\n");
    printf("         Escolha: ");
    scanf("%d",&escolha);
  } while (escolha < 1 || escolha > 4);
  return escolha;
}

void imprime_solucao(Disquete *s, int n_disqs){
   int totalDisqs = 0;

   for (int k = 0; k < n_disqs; k++) {
       if (s[k].numeroArq != 0){
          totalDisqs += 1;
          printf("\nDisquete %d - Numero de arquivos no disquete: %d\n", k, s[k].numeroArq);
          printf("Tamanho Total: %d Espaco Livre: %d\n", s[k].tamanhoTotal,(CAP_DISQ - s[k].tamanhoTotal));
          imprimeDisquete(s[k]);
          getchar();
       }
    }
    printf("Numero total de disquetes: %d\n",totalDisqs);
    getchar();

}

void SAInv(int n_disqs,
        int n_arqs,
        int disqMin,
        Disquete *s,
        Arquivo *a,
        int penalidade,
        int *fo,
        int *inv,
        double alfa,
        double temperatura_inicial,
        double temperatura_final,
        int SAmax)
{
    double x;              // numero aleatorio entre ZERO e UM
    double temperatura;    // temperatura corrente
    int iter;              // numero de iteracoes na temperatura corrente
    int num_mudancas_temp; // numero de mudancas de temperatura
    int posEsc;            // disquete escolhido
    int delta;             // variacao de energia
    int posDest;
    int arqEsc;
    int fo_star;
    Disquete *s_star;

    s_star = cria_vetor_Disquete(n_disqs);
    copia_solucao(s, s_star, n_disqs);
    fo_star = *fo;

    temperatura = temperatura_inicial;
    num_mudancas_temp = 0;
    printf("Solucao inicial: fo corrente = %d\n",*fo);
    getchar();

    // enquanto o sistema nao congelar faca
    while (temperatura > temperatura_final & fo_star > 0) {
       iter = 0;
       // enquanto o equilibrio termico nao for atingido faca
       while (iter < SAmax){

          iter++;
          // escolha um vizinho qualquer

          do {
	     posEsc = random(n_disqs);
          }while(s[posEsc].numeroArq == 0);

          arqEsc = random(s[posEsc].numeroArq);
          Arquivo *a = retiraArquivo(&(s[posEsc]),arqEsc);

          do {
             posDest = random(n_disqs);
          }while (posDest == posEsc);

          insereArquivo(&(s[posDest]),a);

	  // calcule a variacao de energia
          delta = calcula_foInv(s, n_disqs, disqMin, penalidade) - *fo;

          // se houver melhora, aceite o vizinho
	  if (delta < 0){
	     (*fo) += delta;

             if (*fo < fo_star){
	  	copia_solucao(s, s_star,n_disqs);
		fo_star = *fo;
                printf("********** fo_star = %d \n",fo_star);
             }
          }
	  else {
	      // se houver piora, aceite o vizinho com uma determinada
              //   probabilidade
	      x = randomico(0,1);
              if (x < exp(-delta/temperatura)){
	       	 (*fo) += delta;
              }
	      else {
               	// Se o vizinho nao foi aceito, desfaca o movimento
                insereArquivo(&(s[posEsc]),retiraArquivo(&(s[posDest]),0));
              }
	  }
        }

        // decresca a temperatura
        temperatura *= alfa;
        //printf("Temperatura atual = %10.3f\n", temperatura);
        num_mudancas_temp += 1;
    }

    printf("********* Melhor Solucao obtida pelo SA ************** \n");
    printf("funcao objetivo = %3d \n",fo_star);
    printf("Num. max. de solucoes analisadas = %ld \n",num_mudancas_temp*SAmax);
    printf("****************************************************** \n");
    copia_solucao(s_star, s, n_disqs);
    (*fo) = fo_star;
    libera_vetor_Disquete(s_star);
    getchar();
}
 
/* calcula a funcao objetivo */
int calcula_foInv(Disquete *s, int n_disqs, int disqMin, int penalidade)
{
    int inviabilidade = 0;
    int disqUtil = 0;

    for (int j = 0; j < n_disqs; j++){
        if(s[j].numeroArq != 0) disqUtil++;
        inviabilidade += calcula_inviabilidade(&(s[j]));
    }
    return disqUtil - disqMin + (penalidade * inviabilidade);
}
