#define CAP_DISQ 1400000

struct Arquivo{
    int tamanho;
    int indice;
};

struct lista_arquivo {
    Arquivo *arquivo;
    lista_arquivo *proximo;  /* ponteiro para o registro posterior */
};

struct Disquete {
    lista_arquivo *lArq;
    int numeroArq;
    int tamanhoTotal;
};

void insereArquivo(Disquete *d, Arquivo *a)
{
   lista_arquivo *la = (lista_arquivo *) malloc(sizeof(lista_arquivo));
   la->arquivo = a;
   la->proximo = d->lArq;
   d->lArq = la;
   d->numeroArq++;
   d->tamanhoTotal += a->tamanho;
}

Arquivo * retiraArquivo(Disquete *d, int p)
{
   lista_arquivo *lanterior, *lcorrente;
   lcorrente = d->lArq;
   lanterior = d->lArq;
   Arquivo *a;
   if (p == 0) {
      a = lcorrente->arquivo;
      d->lArq = lcorrente->proximo;
   }
   else {
      for(;p>0;p--){
         lanterior = lcorrente;
         lcorrente = lcorrente->proximo;
      }
      a = lcorrente->arquivo;
      lanterior->proximo = lcorrente->proximo;
   }
   free(lcorrente);
   d->numeroArq--;
   d->tamanhoTotal -= a->tamanho;
   return a;
}

void imprimeDisquete(Disquete d)
{
   lista_arquivo *l = d.lArq;
   for(int j = 0; j < d.numeroArq; j++) {
      printf("Indice do Arquivo: %d - Tamanho = %d bytes\n", l->arquivo->indice, l->arquivo->tamanho);
      l = l->proximo;
   }
}
