#include <vcl>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <limits.h>
#include <time.h>

#define MAX(x,y) ((x)<(y) ? (y) : (x))

#pragma hdrstop

int *cria_vetor(int tam);
void libera_vetor(int *vetor);
void le_arq_vetor(char nomearq[], int *vetor);
void le_arq_vetor_denso(char nomearq[], int *vetor);
void constroi_solucao_aleatoria(int num_objetos,int *q );
void imprime_solucao( int num_objetos,int *q);
int calcula_fo( int num_objetos,int *q, int *p,
                int inviabilidade);
int calcula_peso_objetos( int num_objetos, int *w, int *q);
int calcula_inviabilidade(int peso_objetos, int capacidade);
double randomico(double min, double max);
void atualiza_melhor_solucao(int *q, int *s_star, int num_objetos);
void inicializa_vetor(int *vetor, int tam);
int melhor_vizinho (int *q,
	           int num_objetos,
                   int peso_objetos,
                   int *w,
                   int *p,

                   int capacidade,
                   int fo,
                   int fo_star,
                   int *melhor_posicao,
                   int *valor_bit);

void SA(int n,
        int *p,
        int *w,
        int *q,
        int b,
        int *peso_objetos,
        int *fo,
        int *inv,
        double alfa,
        double temperatura_inicial,
        double temperatura_final,
        int SAmax,
        int *u);

void repara_inviabilidade(
        int n,
        int *p,
        int *w,
        int *q,
        int b,
        int *peso_objetos,
        int *fo,
        int *inv);
int menu_solucao_inicial(void);
int menu_principal(void);
void embaralha_vetor(int *vetor, int n);

#pragma argsused
int main(int argc, char **argv)
{
  int n;           // tipo de objetos
  int *q;          // qtde de objetos
  int *u;
  int b;           // capacidade da mochila
  int *s_star;     // vetor melhor solucao
  int *w;          // vetor de peso de cada objeto
  int *p;          // vetor de beneficio de cada objeto
  int fo;          // funcao objetivo corrente
  int fo_star;     // melhor funcao objetivo
  int inv;         // quantidade de inviabilidade da solucao corrente
  int peso_objetos;// peso dos objetos na solucao corrente
  int choice;
  int delta;                 // variacao de energia
  double temperatura_inicial;// temperatura inicial de partida do sistema
  double temperatura_final;  // temperatura de congelamento do sistema
  double alfa;               // taxa de resfriamento
  int SAmax;                 // numero maximo de iteracoes em uma dada temperatura


  srand(1000); // pega o numero 1000 como semente de numeros aleatorios
//  srand((unsigned) time(NULL)); // pega a hora do relogio como semente
  n = 10;
  b = 90;
  s_star = cria_vetor(n);
  w = cria_vetor(n);
  p = cria_vetor(n);
  q = cria_vetor(n);     // criamos um vetor de qtde de objetos
  u = cria_vetor(n);     // criamos um vetor de qtde de objetos
  inicializa_vetor(w,n);
  inicializa_vetor(p,n);


  // le_arquivo_vetor_denso (" quantidade.txt", q); no poderiamos fazer isto ao invs de criar um vetor s para o q ?
  le_arq_vetor_denso("peso50.txt", w);
  le_arq_vetor_denso("beneficio50.txt", p);
  le_arq_vetor_denso("quantidade.txt", q);
  le_arq_vetor_denso("quantidade.txt", u);
  fo_star = -200;
  do {
    choice = menu_principal();
    switch (choice) {
    case 1: /* Geracao de uma solucao inicial */

           /* Geracao aleatoria de uma solucao inicial */
                 constroi_solucao_aleatoria(n,q);
                 printf("Solucao aleatoria:\n");
                 imprime_solucao(n,q);
                 peso_objetos = calcula_peso_objetos(n, w,q);
                 inv = calcula_inviabilidade(peso_objetos, b);
                 printf("peso dos objetos = %2d inviabilidade = %d \n",peso_objetos, inv);
                 fo = calcula_fo(n, q, p, inv);
                 printf("funcao objetivo = %3d \n",fo);
           break;
    case 2: /* Simulated Annealing */
          if (fo != 0) {
            alfa = 0.97;
            temperatura_inicial = 100;
            temperatura_final = 0.1;
            SAmax =2* n;
            SA(n,p,w,q,b,&peso_objetos,&fo,&inv,alfa,temperatura_inicial,temperatura_final,SAmax, u);
          }
          else {
            printf("\n ----- Gere uma solucao inicial -------\n");
            getchar();
          }
          break;

    case 3: /* Saida */
          break;
    default:
          break;
    }
  } while (choice != 3);
  libera_vetor(s_star);
  libera_vetor(w);
  libera_vetor(p);
  libera_vetor(q);
  libera_vetor(u);
  return 0;
} /* fim do programa principal */


//---------------------------------------------------------------------------


/* cria memoria para um vetor de tam posicoes */
int *cria_vetor(int tam)
{
  int *vetor;
  vetor = (int *) malloc(tam*sizeof(int));
  if (!vetor){
  	printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}
/* libera memoria de um vetor */
void libera_vetor(int *vetor)
{
  free(vetor);
}
/* le um arquivo no formato i, valor */
void le_arq_vetor(char nomearq[], int *vetor)
{
  int j,
    valor;
  FILE *arquivo;

  arquivo = fopen(nomearq,"r");
  if (!arquivo) {
     printf("O Arquivo %s nao pode ser aberto.\n", nomearq);
     getchar();
     exit(1);
  }
  while (!feof(arquivo)){
    fscanf(arquivo, "%d, %d", &j, &valor);
    vetor[j] = valor;
  }
  fclose(arquivo);
}

/* Nesta leitura, vetor[j] = valor para todo j=0...n */
void le_arq_vetor_denso(char nomearq[], int *vetor)
{
  int j,
    valor;
  FILE *arquivo;

  arquivo = fopen(nomearq,"r");
  if (!arquivo) {
     printf("O Arquivo %s nao pode ser aberto.\n", nomearq);
     getchar();
     exit(1);
  }
  j = 0;
  while (!feof(arquivo)){
    fscanf(arquivo, "%d", &valor);
    vetor[j] = valor;
    j++;
  }
  fclose(arquivo);
}
/* constroi uma solucao inicial aleatoria */
void constroi_solucao_aleatoria( int num_objetos, int *q)
{
    for (int j=0; j<num_objetos; j++){
      int aux = q[j] + 1;
      q[j] = random(aux);
    }
}
/* gera numero entre min e max*/
double randomico(double min, double max)
 {if (min==max) return min;
   return((double)(rand()%10000/10000.0)*(max-min)+min); }

/* imprime a solucao */
void imprime_solucao( int num_objetos, int *q)
{
    for (int j=0; j<num_objetos; j++) printf("s[%2d]=%d \n",j,q[j]);
}
/* calcula a funcao objetivo */
int calcula_fo( int num_objetos,int *q, int *p, int inviabilidade)
{
    int j;
    int beneficio = 0;
    for (j=0; j<num_objetos; j++){
    	    beneficio +=q[j]* p[j];
        }
    return beneficio - 50 * inviabilidade;
}
/* calcula o peso dos objetos na mochila */
int calcula_peso_objetos( int num_objetos, int *w,int *q)
{
    int j;
    int peso = 0;
    for (j=0; j<num_objetos; j++){
	   peso +=q[j]* w[j];
        }
      return peso;
}

/* calcula o excesso de peso na mochila */
int calcula_inviabilidade(int peso_objetos, int capacidade)
{
    return MAX(0, peso_objetos - capacidade);
}



/* atualiza a melhor solucao */
void atualiza_melhor_solucao(int *q, int *s_star, int num_objetos)
{
  for (int j=0; j<num_objetos; j++) s_star[j] = q[j];
}
void inicializa_vetor(int *vetor, int tam)
{
    for (int j=0; j<tam; j++) vetor[j] = 0;
}


void SA(int n,
        int *p,
        int *w,
        int *q,
        int b,
        int *peso_objetos,
        int *fo,
        int *inv,
        double alfa,
        double temperatura_inicial,
        double temperatura_final,
        int SAmax,
        int *u)
{
    double x;              // numero aleatorio entre ZERO e UM
    double temperatura;    // temperatura corrente
    int iter;              // numero de iteracoes na temperatura corrente
    int num_mudancas_temp; // numero de mudancas de temperatura
    int posicao_escolhida; // objeto escolhido
    int delta;             // variacao de energia
    int fo_star;
    int *s_star;
    int a;
    int peso_modificado;
    int tipo_movimento;
    s_star = cria_vetor(n);
    inicializa_vetor(s_star,n);
    atualiza_melhor_solucao(q, s_star, n);
    fo_star = *fo;
    temperatura = temperatura_inicial;
    num_mudancas_temp = 0;
    printf("Solucao inicial: fo corrente = %d   peso dos objetos = %2d \n",*fo,*peso_objetos);
    getchar();

	/* enquanto o sistema nao congelar faca */
    while (temperatura > temperatura_final) {
       iter = 0;
	  /* enquanto o equilibrio termico nao for atingido faca */
       while (iter < SAmax){
          iter++;
	  	/* escolha um vizinho qualquer */

          bool fezmovimento = false;
          while (!fezmovimento){
	    posicao_escolhida = random(n);
            a = random(2);
            if (a==0){
              if (q[posicao_escolhida] < u[posicao_escolhida]){
                 q[posicao_escolhida]++;
                 tipo_movimento = 0;
                 fezmovimento = true;
              }
            }
            else{
              if (q[posicao_escolhida] >= 1){
                 q[posicao_escolhida]--;
                 fezmovimento = true;
                 tipo_movimento = 1;
              }
            }
          }
	  	/* calcule a variacao de energia */
           if (a==0) {
             peso_modificado = (*peso_objetos) + w[posicao_escolhida];
             int v= MAX(0, peso_modificado - b);
              v=v*50;
                  delta = p[posicao_escolhida]+ 50*calcula_inviabilidade(*peso_objetos, b) - v;}
          else   {
              peso_modificado = (*peso_objetos) - w[posicao_escolhida];
              int v= MAX(0, peso_modificado - b);
               v=v*50;
               delta = -p[posicao_escolhida] + 50*calcula_inviabilidade(*peso_objetos, b) - v;}
    	  printf("variacao de energia = %3d \n",delta);

	  	/* se houver melhora, aceite o vizinho */
	  if (delta > 0){
	     (*fo) += delta;
             (*peso_objetos) =peso_modificado;
             printf("Solucao de melhora: fo corrente = %d   peso dos objetos = %2d \n",*fo,*peso_objetos);
//             getchar();
             if (*fo > fo_star){
	  	atualiza_melhor_solucao(q, s_star, n);
		fo_star = *fo;
	  	imprime_solucao(n,s_star);
                printf("********** fo_star = %3d \n",fo_star);
//                getchar();
             }
	  }
	  else {
	      /* se houver piora, aceite o vizinho com uma determinada
                 probabilidade */
	      x = randomico(0,1);
              if (x < exp(delta/temperatura)){
	       	 (*fo) += delta;
                 (*peso_objetos) = peso_modificado;
                 printf("Solucao de piora: fo corrente = %d   peso dos objetos = %2d \n",*fo,*peso_objetos);
//                 getchar();
              }
	      else {
               	/* Se o vizinho nao foi aceito, desfaca o movimento */
                 if (tipo_movimento == 0){
                   q[posicao_escolhida]--;
                 }
                 else{
                   q[posicao_escolhida]++;
                 }

              }
	  }
        }
		/* decresca a temperatura */
        temperatura *= alfa;
        printf("Temperatura atual = %10.3f\n", temperatura);
        num_mudancas_temp += 1;
    }

    printf("********* Melhor Solucao obtida pelo SA ************** \n");
    imprime_solucao(n,s_star);
    (*peso_objetos) = calcula_peso_objetos( n, w, s_star);
    (*inv) = calcula_inviabilidade(*peso_objetos, b);
    printf("peso dos objetos = %2d inviabilidade = %d \n",*peso_objetos, *inv);
    printf("funcao objetivo = %3d \n",fo_star);
    printf("Num. max. de solucoes analisadas = %ld \n",num_mudancas_temp*SAmax);
    printf("Numero de solucoes existentes = %.0f \n", exp(n*log(2)));
    printf("****************************************************** \n");
    atualiza_melhor_solucao(s_star,q, n);
    (*fo) = fo_star;
    libera_vetor(s_star);
    getchar();
}




void repara_inviabilidade(
        int n,
        int *q,
        int *s,
        int *p,
        int *w,
        int b,
        int penalidade,
        int *peso_objetos,
        int *fo,
        int *inv)
{
  int posicao_escolhida;

  do{
    do{
      posicao_escolhida = random(n);
    }while (s[posicao_escolhida] == 0);
    printf("posicao escolhida = %2d\n",posicao_escolhida);
    s[posicao_escolhida] = 0;
    (*peso_objetos) = (*peso_objetos) - w[posicao_escolhida];
    *inv = calcula_inviabilidade(*peso_objetos, b);
    printf("inviabilidade atual = %2d\n",*inv);
    *fo = calcula_fo( n, q, p, *inv);
  }while (*inv);
}

/* Menu de geracao de uma solucao inicial */
int menu_solucao_inicial(void)
{
  int escolha;

  do {
    printf("\nGERACAO DA SOLUCAO INICIAL: \n");
    printf("                  3. Aleatoria \n");
    printf("                  escolha: ");
    scanf("%d",&escolha);
  } while (escolha < 1 || escolha > 3);
  return escolha;
}


/* Menu principal */
int menu_principal(void)
{
  int escolha;

  do {
    printf("\n************************************************* \n");
    printf("         1. Gere solucao inicial \n");
    printf("         2. Simulated Annealing \n");
    printf("         3. Sair \n");
    printf("         Escolha: ");
    scanf("%d",&escolha);
  } while (escolha < 1 || escolha > 3);
  return escolha;
}

void embaralha_vetor(int *vetor, int n)
{
  int aux, j1, j2;

  for (int i=0; i < n; i++)
  {
    j1 = random(n);
    j2 = random(n);
    while (j1 == j2) j2 = random(n);
    aux = vetor[j1];
    vetor[j1] = vetor[j2];
    vetor[j2] = aux;
  }
}



