//---------------------------------------------------------------------------
#include <vcl>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <limits.h>
#include <time.h>

#define MAX(x,y) ((x)<(y) ? (y) : (x))

#pragma hdrstop

struct lista {
	int posicao;
  	struct lista *proximo;  /* ponteiro para a prxima entrada */
  	struct lista *anterior; /* ponteiro para o registro anterior */
};

struct lista_restrita {
	int objeto;
        double beneficio_relativo;
        int fo;
  	struct lista_restrita *proximo;  /* ponteiro para a prxima entrada */
  	struct lista_restrita *anterior; /* ponteiro para o registro anterior */
};

int *cria_vetor(int tam);
double *cria_vetor_double(int tam);
int **cria_matriz(int nlinhas, int ncolunas);
void libera_vetor(int *vetor);
void libera_matriz(int **matriz, int nlinhas);
void le_arq_vetor(char nomearq[], int *vetor);
void le_arq_vetor_denso(char nomearq[], int *vetor);
void constroi_solucao_aleatoria(int *s, int num_objetos);
void imprime_solucao(int *s, int num_objetos);
int calcula_fo(int *s, int num_objetos, int *p,
               int inviabilidade, int penalidade);
void troca_bit(int *s, int j);
int calcula_peso_objetos(int *s, int num_objetos, int *w);
int calcula_inviabilidade(int peso_objetos, int capacidade);
double randomico(double min, double max);
void atualiza_melhor_solucao(int *s, int *s_star, int num_objetos);
int calcula_penalidade(int *w, int num_objetos);
void imprime_solucao(int *s, int num_objetos);
void inicializa_vetor(int *vetor, int tam);
int melhor_vizinho(int *s,
	           int num_objetos,
                   int peso_objetos,
                   int *w,
                   int *p,
                   int penalidade,
                   int capacidade,
                   int fo,
                   int fo_star,
                   int *melhor_posicao,
                   int *valor_bit,
                   struct lista **iniciotabu,
                   struct lista **finaltabu);
void apaga_registro_tabu(struct lista *registro,
                         struct lista **iniciotabu,
                         struct lista **finaltabu);
void apaga_lista_tabu(struct lista **iniciotabu,
		      struct lista **finaltabu);
int lenght_lista_tabu(struct lista **iniciotabu, /* primeiro elemento da lista */
                      struct lista **finaltabu);  /* ltimo elemento da lista */
void display_lista_tabu(struct lista **iniciotabu,/* primeiro elemento da lista */
                        struct lista **finaltabu);  /* ltimo elemento da lista */
void insere_lista_tabu(struct lista *i,
		       struct lista **iniciotabu,
		       struct lista **finaltabu);
bool esta_lista_tabu(int posicao,
                     struct lista **iniciotabu);
void imprime_fo(char nomearq[], float tempo, int fo, int iteracao);
void limpa_arquivo(char nomearq[]);

void insere_LC(struct lista_restrita *i,    /* novo elemento */
               struct lista_restrita **inicio_LC, /* primeiro elemento da lista */
               struct lista_restrita **final_LC);  /* ltimo elemento da lista */
void display_LC(struct lista_restrita **inicio_LC, /* primeiro elemento da lista */
                struct lista_restrita **final_LC); /* ltimo elemento da lista */
int lenght_LC(struct lista_restrita **inicio_LC, /* primeiro elemento da lista */
              struct lista_restrita **final_LC);  /* ltimo elemento da lista */
struct lista_restrita *encontra_objeto_LC(int posicao,
                                          struct lista_restrita **inicio_LC);
void apaga_registro_LC(struct lista_restrita *registro,
                       struct lista_restrita **inicio_LC,
                       struct lista_restrita **final_LC);
void BT(int n,
        int *s,
        int *p,
        int *w,
        int b,
        int penalidade,
        int *peso_objetos,
        int *fo,
        int *inv,
        int tamanho_maximo_lista_tabu,
        int BTmax);
void SA(int n,
        int *s,
        int *p,
        int *w,
        int b,
        int penalidade,
        int *peso_objetos,
        int *fo,
        int *inv,
        double alfa,
        double temperatura_inicial,
        double temperatura_final,
        int SAmax);
void constroi_solucao_parcialmente_gulosa(
        int n,
        int *s,
        int *p,
        int *w,
        int b,
        int penalidade,
        int *peso_objetos,
        int *fo,
        int *inv,
        double alfa_GRASP);

void mutacao(int *s, int n);
void crossover(int *pai1,
               int *pai2,
               int *filho1,
               int *filho2,
               int n,
               int ponto_de_corte);
void repara_inviabilidade(
        int n,
        int *s,
        int *p,
        int *w,
        int b,
        int penalidade,
        int *peso_objetos,
        int *fo,
        int *inv);
int menu_solucao_inicial(void);
int menu_descida(void);
int menu_principal(void);
void embaralha_vetor(int *vetor, int n);
void descida1opt(int n,
                 int *s,
                 int *p,
                 int *w,
                 int b,
                 int penalidade,
                 int *peso_objetos,
                 int *fo,
                 double percentual);
void randomicodescida(int n,
                      int *s,
                      int *p,
                      int *w,
                      int b,
                      int penalidade,
                      int *peso_objetos,
                      int *fo,
                      int maxIter);
void descida2opt(int n,
                 int *s,
                 int *p,
                 int *w,
                 int b,
                 int penalidade,
                 int *peso_objetos,
                 int *fo);
void vnd(int n,
         int *s,
         int *p,
         int *w,
         int b,
         int penalidade,
         int *peso_objetos,
         int *fo);

void vizqq1opt(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo);
void vizqq2opt(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo);

void vns(int n,
         int *s,
         int *p,
         int *w,
         int b,
         int penalidade,
         int *peso_objetos,
         int *fo,
         double tempo);

void AG(int n,
        int *s,
        int *p,
        int *w,
        int b,
        int penalidade,
        int *peso_objetos,
        int *fo,
        int nind,
        int max_geracoes,
        double prob_crossover,
        double prob_mutacao);
int roleta(int nind, int *fopop);

//---------------------------------------------------------------------------

#pragma argsused
int main(int argc, char **argv)
{
  int n;           // numero de objetos
  int b;           // capacidade da mochila
  int *s;          // vetor solucao corrente
  int *s_star;     // vetor melhor solucao
  int *w;          // vetor de peso de cada objeto
  int *p;          // vetor de beneficio de cada objeto
  int fo;          // funcao objetivo corrente
  int fo_star;     // melhor funcao objetivo
  int inv;         // quantidade de inviabilidade da solucao corrente
  int penalidade;  // penalidade por superar a capacidade da mochila
  int peso_objetos;// peso dos objetos na solucao corrente

  int choice;

  int maxIter;//Nmero mximo de iteraes para procurar um  melhor vizinho

  int delta;                 // variacao de energia
  double temperatura_inicial;// temperatura inicial de partida do sistema
  double temperatura_final;  // temperatura de congelamento do sistema
  double alfa;               // taxa de resfriamento
  int SAmax;                 // numero maximo de iteracoes em uma dada temperatura

  int tamanho_maximo_lista_tabu; // tamanho maximo da Lista Tabu
  int BTmax;                     // numero max de iteracoes s/melhora da Busca Tabu

  struct lista_restrita *inicio_LC, *final_LC, *candidato;
  int tamanho_LC,     // tamanho da lista de candidatos
      tamanho_LRC,    // tamanho da lista restrita de candidatos
      GRASPmax;       // numero maximo de iteracoes GRASP
  double alfa_GRASP;  // percentual da LC a ser considerado

  srand(1000); // pega o numero 1000 como semente de numeros aleatorios
//  srand((unsigned) time(NULL)); // pega a hora do relogio como semente
  n = 50;
  b = 100;
  maxIter = 100;

  s = cria_vetor(n);
  s_star = cria_vetor(n);
  w = cria_vetor(n);
  p = cria_vetor(n);
  inicializa_vetor(w,n);
  inicializa_vetor(p,n);

  le_arq_vetor_denso("peso50.txt", w);
  le_arq_vetor_denso("beneficio50.txt", p);
  penalidade = calcula_penalidade(w, n);
  fo_star = - INT_MAX;

  do {
    choice = menu_principal();
    switch (choice) {
    case 1: /* Geracao de uma solucao inicial */
           switch(menu_solucao_inicial()) {
           case 1: /* Geracao gulosa de uma solucao inicial */
                 constroi_solucao_parcialmente_gulosa(n,s,p,w,b,penalidade,&peso_objetos,&fo,&inv,0);
                 printf("Solucao construida de forma gulosa:\n");
                 //imprime_solucao(s,n);
                 printf("funcao objetivo = %3d \n",fo);
                 printf("peso dos objetos = %2d inviabilidade = %d \n",peso_objetos, inv);
	         break;
           case 2: /* Geracao parcialmente gulosa de uma solucao inicial */
                 constroi_solucao_parcialmente_gulosa(n,s,p,w,b,penalidade,&peso_objetos,&fo,&inv,0.50);
                 printf("Solucao construida de forma parcialmente gulosa:\n");
                 //imprime_solucao(s,n);
                 printf("funcao objetivo = %3d \n",fo);
                 printf("peso dos objetos = %2d inviabilidade = %d \n",peso_objetos, inv);
	         break;
           case 3: /* Geracao aleatoria de uma solucao inicial */
                 constroi_solucao_aleatoria(s, n);
                 printf("Solucao aleatoria:\n");
                 //imprime_solucao(s,n);
                 peso_objetos = calcula_peso_objetos(s, n, w);
                 inv = calcula_inviabilidade(peso_objetos, b);
                 printf("peso dos objetos = %2d inviabilidade = %d \n",peso_objetos, inv);
                 fo = calcula_fo(s, n, p, inv, penalidade);
                 printf("funcao objetivo = %3d \n",fo);
	         break;
           }
           break;
    case 2: /* Metodo da Descida */
           switch(menu_descida()) {
           case 1: /* Metodo da descida 1 Optimal */
                 if (fo != 0) {
                    descida1opt(n, s, p, w, b, penalidade, &peso_objetos, &fo, 0.8);
                 }
                 else {
                    printf("\n ----- Gere uma solucao inicial ------\n");
                    getchar();
                 }
	         break;
           case 2: /* Metodo da descida 2 Optimal */
                 if (fo != 0) {
                    descida2opt(n, s, p, w, b, penalidade, &peso_objetos, &fo);
                 }
                 else {
                    printf("\n ----- Gere uma solucao inicial ------\n");
                    getchar();
                 }
	         break;
           }
           break;
    case 3: /* Metodo Randomico de Descida */
          if (fo != 0) {
             randomicodescida(n, s, p, w, b, penalidade, &peso_objetos, &fo, maxIter);
          }
          else {
            printf("\n ----- Gere uma solucao inicial ------\n");
            getchar();
          }
          break;
    case 4: /* Metodo Randomico Nao Ascendente */
          if (fo != 0) {
          }
          else {
            printf("\n ----- Gere uma solucao inicial ------\n");
           getchar();
          }
          break;
    case 5: /* Busca Tabu */
          if (fo != 0) {
            tamanho_maximo_lista_tabu = 7;
            BTmax = 20;
            BT(n,s,p,w,b,penalidade,&peso_objetos,&fo,&inv,tamanho_maximo_lista_tabu,BTmax);
          }
          else {
            printf("\n ----- Gere uma solucao inicial -------\n");
            getchar();
          }
          break;
    case 6: /* Simulated Annealing */
          if (fo != 0) {
            alfa = 0.97;
            temperatura_inicial = 100;
            temperatura_final = 0.1;
            SAmax = n/2;
            SA(n,s,p,w,b,penalidade,&peso_objetos,&fo,&inv,alfa,temperatura_inicial,temperatura_final,SAmax);
          }
          else {
            printf("\n ----- Gere uma solucao inicial -------\n");
            getchar();
          }
          break;
    case 7: /* GRASP */
          alfa_GRASP = 0.50;
          GRASPmax = 2;
          for (int iterGRASP = 0; iterGRASP < GRASPmax; iterGRASP++){
             constroi_solucao_parcialmente_gulosa(n,s,p,w,b,penalidade,&peso_objetos,&fo,&inv,alfa_GRASP);
             if (fo > fo_star){
                fo_star = fo;
                atualiza_melhor_solucao(s, s_star, n);
             }
          }
          peso_objetos = calcula_peso_objetos(s_star, n, w);
          inv = calcula_inviabilidade(peso_objetos, b);
          printf("funcao objetivo saindo do GRASP = %3d \n", fo_star);
          printf("peso dos objetos = %2d inviabilidade = %d \n", peso_objetos, inv);
          break;
    case 8: /* Algoritmos Geneticos */
          AG(n, s, p, w, b, penalidade, &peso_objetos, &fo, 6, 2, 0.80, 0.05);
          break;
    case 9: /* VND */
          if (fo != 0) vnd(n, s, p, w, b, penalidade, &peso_objetos, &fo);
          else {
             printf("\n ----- Gere uma solucao inicial ------\n");
             getchar();
          }
          break;
    case 10: /* VNS */
          if (fo != 0) vns(n, s, p, w, b, penalidade, &peso_objetos, &fo, 20.0);
          else {
             printf("\n ----- Gere uma solucao inicial ------\n");
             getchar();
          }
          break;
    default:
          break;
    }
  } while (choice != 0);


  libera_vetor(s);
  libera_vetor(s_star);
  libera_vetor(w);
  libera_vetor(p);
  return 0;
} /* fim do programa principal */


//---------------------------------------------------------------------------


/* cria memoria para um vetor de tam posicoes */
int *cria_vetor(int tam)
{
  int *vetor;

  vetor = (int *) malloc(tam*sizeof(int));
  if (!vetor){
    printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}


/* cria memoria para um vetor de tam posicoes */
double *cria_vetor_double(int tam)
{
  double *vetor;

  vetor = (double *) malloc(tam*sizeof(double));
  if (!vetor){
    printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}


/* libera memoria de um vetor */
void libera_vetor(int *vetor)
{
  free(vetor);
}


/* le um arquivo no formato i, valor */
void le_arq_vetor(char nomearq[], int *vetor)
{
  int j,
    valor;
  FILE *arquivo;

  arquivo = fopen(nomearq,"r");
  if (!arquivo) {
     printf("O Arquivo %s nao pode ser aberto.\n", nomearq);
     getchar();
     exit(1);
  }
  while (!feof(arquivo)){
    fscanf(arquivo, "%d, %d", &j, &valor);
    vetor[j] = valor;
  }
  fclose(arquivo);
}

/* Nesta leitura, vetor[j] = valor para todo j=0...n */
void le_arq_vetor_denso(char nomearq[], int *vetor)
{
  int j,
    valor;
  FILE *arquivo;

  arquivo = fopen(nomearq,"r");
  if (!arquivo) {
     printf("O Arquivo %s nao pode ser aberto.\n", nomearq);
     getchar();
     exit(1);
  }
  j = 0;
  while (!feof(arquivo)){
    fscanf(arquivo, "%d", &valor);
    vetor[j] = valor;
    j++;
  }
  fclose(arquivo);
}



/* constroi uma solucao inicial aleatoria */
void constroi_solucao_aleatoria(int *s, int num_objetos)
{
    for (int j=0; j<num_objetos; j++) s[j] = random(2);
}


/* imprime a solucao */
void imprime_solucao(int *s, int num_objetos)
{
    for (int j=0; j<num_objetos; j++) printf("s[%2d]=%d \n",j,s[j]);
}


/* calcula a funcao objetivo */
int calcula_fo(int *s, int num_objetos, int *p, int inviabilidade, int penalidade)
{
    int j;
    int beneficio = 0;

    for (j=0; j<num_objetos; j++){
    	if (s[j]) {
          beneficio += p[j];
        }
    }
    return beneficio - penalidade * inviabilidade;
}


/* insere ou retira o objeto j da mochila */
void troca_bit(int *s, int j)
{
    if (s[j])
      s[j] = 0;
    else
      s[j] = 1;
}


/* calcula o peso dos objetos na mochila */
int calcula_peso_objetos(int *s, int num_objetos, int *w)
{
    int j;
    int peso = 0;

    for (j=0; j<num_objetos; j++){
    	if (s[j]) {
	   peso += w[j];
        }
    }
    return peso;
}


/* calcula o excesso de peso na mochila */
int calcula_inviabilidade(int peso_objetos, int capacidade)
{
    return MAX(0, peso_objetos - capacidade);
}


/* Gera numero aleatorio entre min e max */
double randomico(double min, double max)
{
  if (min == max) return min;
  return ((double) (rand()%10000/10000.0)*(max-min) + min);
}


/* atualiza a melhor solucao */
void atualiza_melhor_solucao(int *s, int *s_star, int num_objetos)
{
   for (int j=0; j<num_objetos; j++) s_star[j] = s[j];
}


/* calcula a penalidade por exceder a capacidade da mochila */
int calcula_penalidade(int *w, int num_objetos)
{
    int penalidade = 0;
    for (int j=0; j<num_objetos; j++) penalidade += w[j];
    return penalidade;
}


void inicializa_vetor(int *vetor, int tam)
{
    for (int j=0; j<tam; j++) vetor[j] = 0;
}


int melhor_vizinho(int *s,
    	           int num_objetos,
                   int peso_objetos,
                   int *w,
                   int *p,
                   int penalidade,
                   int capacidade,
                   int fo,
                   int fo_star,
                   int *melhor_posicao,
                   int *valor_bit,  // valor do bit relativo  melhor posicao
                   struct lista **iniciotabu,
                   struct lista **finaltabu)
{
    int delta,
        delta_max = -INT_MAX;

    for (int j=0; j<num_objetos; j++){
       troca_bit(s, j);
      	/* calcule a variacao de energia */
       int peso_modificado = peso_objetos - w[j]*(!s[j]) + w[j]*s[j];

       delta = - p[j]*(!s[j]) + penalidade * calcula_inviabilidade(peso_objetos, capacidade)
               + p[j]*s[j] -  penalidade * calcula_inviabilidade(peso_modificado,capacidade);

       printf("delta = %5d\n",delta);
       bool estanalistatabu = esta_lista_tabu(j, iniciotabu);
       if (!estanalistatabu || (estanalistatabu && fo + delta > fo_star)){
          if (delta > delta_max) {
             delta_max = delta;
             *melhor_posicao = j;
             *valor_bit = w[j]*s[j] > 0;
          }
       }
       troca_bit(s, j);
    }
    return delta_max;
}



/* Remove o elemento registro da lista */
void apaga_registro_tabu(struct lista *registro,
                         struct lista **iniciotabu,
                         struct lista **finaltabu)
{
  if(registro) {
    if(*iniciotabu==registro) {
      *iniciotabu=registro->proximo;
      if(*iniciotabu) (*iniciotabu)->anterior = NULL;
      else *finaltabu = NULL;
    }
    else {
      registro->anterior->proximo = registro->proximo;
      if(registro!=*finaltabu)
          registro->proximo->anterior = registro->anterior;
      else
        *finaltabu = registro->anterior;
    }
    free(registro); /* devolve memria para o sistema */
  }
}


/* Apaga TODA a lista tabu */
void apaga_lista_tabu(struct lista **iniciotabu,
                      struct lista **finaltabu)
{
    struct lista *registro = *iniciotabu;
    while(registro) {
	apaga_registro_tabu(registro, iniciotabu, finaltabu);
    	if (registro) registro = registro->proximo;   /* obtem prximo endereo */
    }
}


/* Mostra o comprimento da lista completa */
int lenght_lista_tabu(struct lista **iniciotabu, /* primeiro elemento da lista */
    	              struct lista **finaltabu)  /* ltimo elemento da lista */
{
  struct lista *registro = *iniciotabu;
  int cont = 0;

  while(registro) {
    registro = registro->proximo;   /* obtem prximo endereo */
    cont++;
  }
  return cont;
}


/* Mostra o conteudo da lista completa */
void display_lista_tabu(struct lista **iniciotabu, /* primeiro elemento da lista */
			struct lista **finaltabu)  /* ltimo elemento da lista */
{
  struct lista *registro = *iniciotabu;
  int cont = 0;

  while(registro) {
    printf("tabu[%2d]   posicao = %2d \n",
            cont, registro->posicao);
    registro = registro->proximo;   /* obtem prximo endereo */
    cont++;
  }
}


/* Insere o registro i no final de uma lista duplamente encadeada */
void insere_lista_tabu(struct lista *i,
                       struct lista **iniciotabu,
		       struct lista **finaltabu)
{
  struct lista *antigo, *ponteiro;

  if (*finaltabu == NULL) {
    i->proximo  = NULL;
    i->anterior = NULL;
    *finaltabu = i;
    *iniciotabu = i;
    return;
  }
  ponteiro = *iniciotabu;
  antigo = NULL;
  while (ponteiro) {
    antigo = ponteiro;
    ponteiro = ponteiro->proximo;
  }
  antigo->proximo = i;
  i->proximo = NULL;
  i->anterior = antigo;
  *finaltabu = i;
}


/* Verifica se posicao esta na lista tabu */
bool esta_lista_tabu(int posicao, struct lista **iniciotabu)
{
  struct lista *registro = *iniciotabu;

  while(registro) {
    if (registro->posicao == posicao)
        return true;
    registro = registro->proximo;  /* obtem novo registro */
  }
  return false; /* nao encontrou */
}


void imprime_fo(char nomearq[], float tempo, int fo, int iteracao)
{
    FILE *arquivo;
    arquivo = fopen(nomearq,"a+");

    if (!arquivo){
        printf("O arquivo %s nao pode ser aberto",nomearq);
        getchar();
        exit(1);
    }
    fprintf(arquivo,"%4.2f\t  %4d\t  %5d\n",tempo, iteracao, fo);
    fclose(arquivo);
}


void limpa_arquivo(char nomearq[])
{
  FILE *arquivo;
  arquivo = fopen(nomearq,"w");
  if (!arquivo){
     printf("O arquivo %s nao pode ser aberto",nomearq);
     getchar();
     exit(1);
  }
  fclose(arquivo);
}


/* Insere um registro de forma ordenada em uma lista duplamente encadeada ordenada */
void insere_LC(struct lista_restrita *i,    /* novo elemento */
               struct lista_restrita **inicio_LC, /* primeiro elemento da lista */
               struct lista_restrita **final_LC)  /* ltimo elemento da lista */
{
  struct lista_restrita *antigo, *ponteiro;

  if (*final_LC==NULL) {  /* primeiro elemento da lista */
     i->proximo = NULL;
     i->anterior = NULL;
     *final_LC = i;
     *inicio_LC = i;
     return;
  }
  ponteiro = *inicio_LC; /* comea no topo da lista */
  antigo = NULL;
  while(ponteiro) {
    if(ponteiro->beneficio_relativo > i->beneficio_relativo) {
      antigo = ponteiro;
      ponteiro = ponteiro->proximo;
    }
    else {
      if(ponteiro->anterior) {
        ponteiro->anterior->proximo = i;
        i->proximo = ponteiro;
        i->anterior = ponteiro->anterior;
        ponteiro->anterior = i;
        return;
      }
      i->proximo = ponteiro; /* novo primeiro elemento */
      i->anterior = NULL;
      ponteiro->anterior = i;
      *inicio_LC = i;
      return;
    }
  }
  antigo->proximo = i; /* coloca no final */
  i->proximo = NULL;
  i->anterior = antigo;
  *final_LC = i;
}


/* Mostra o conteudo da lista completa */
void display_LC(struct lista_restrita **inicio_LC, /* primeiro elemento da lista */
	        struct lista_restrita **final_LC)  /* ltimo elemento da lista */
{
  struct lista_restrita *registro = *inicio_LC;
  int cont = 0;

  while (registro) {
    printf("LC[%2d]   objeto = %2d  beneficio_relativo = %2f \n",
            cont, registro->objeto, registro->beneficio_relativo);
    registro = registro->proximo;   /* obtem prximo endereo */
    cont++;
  }
  printf("\n");
}


/* Mostra o comprimento da lista completa */
int lenght_LC(struct lista_restrita **inicio_LC, /* primeiro elemento da lista */
              struct lista_restrita **final_LC)  /* ltimo elemento da lista */
{
  struct lista_restrita *registro = *inicio_LC;
  int cont = 0;

  while(registro) {
    registro = registro->proximo;   /* obtem prximo endereo */
    cont++;
  }
  return cont;
}


/* Encontra o registro de numero posicao */
struct lista_restrita *encontra_objeto_LC(int posicao,
                                          struct lista_restrita **inicio_LC)
{
  struct lista_restrita *registro = *inicio_LC;
  int contador = 0;

  while (registro) {
    if (contador == posicao) return registro;
    contador++;
    registro = registro->proximo;  /* obtem novo registro */
  }
  printf("Registro nao encontrado.\n");
  return NULL; /* nao encontrou */
}


/* Remove o elemento registro da lista */
void apaga_registro_LC(struct lista_restrita *registro,
                       struct lista_restrita **inicio_LC,
                       struct lista_restrita **final_LC)
{
  if (registro) {
    if (*inicio_LC==registro) {
       *inicio_LC=registro->proximo;
       if (*inicio_LC)
          (*inicio_LC)->anterior = NULL;
       else *final_LC = NULL;
    }
    else {
      registro->anterior->proximo = registro->proximo;
      if (registro!=*final_LC)
         registro->proximo->anterior = registro->anterior;
      else
         *final_LC = registro->anterior;
    }
    free(registro); /* devolve memria para o sistema */
  }
}


void BT(int n,
        int *s,
        int *p,
        int *w,
        int b,
        int penalidade,
        int *peso_objetos,
        int *fo,
        int *inv,
        int tamanho_maximo_lista_tabu,
        int BTmax)
{
    int melhor_posicao, valor_bit;
    struct lista *iniciotabu, *finaltabu, *tabu;
    int iterBT = 0;  // numero corrente de iteracoes da Busca Tabu
    int MelhorIter = 0; // Iteracao em que ocorreu a melhor solucao
    int *s_star;
    int fo_star;
    int delta;
    clock_t CPUiniciotabu, CPUfimtabu;

    s_star = cria_vetor(n);
    inicializa_vetor(s_star,n);
    atualiza_melhor_solucao(s, s_star, n);
    fo_star = *fo;

    printf("\nIniciando a Busca Tabu com fo = %d\n", *fo);
    printf("peso dos objetos = %2d inviabilidade = %d \n",*peso_objetos, *inv);
//    getchar();
    iniciotabu = finaltabu = NULL;
    CPUiniciotabu = CPUfimtabu = clock();
    limpa_arquivo("valordefoBT.out");
    imprime_fo("valordefoBT.out", (float)(CPUfimtabu - CPUiniciotabu)/CLOCKS_PER_SEC, *fo, iterBT);

    while (iterBT - MelhorIter < BTmax) {
	iterBT++;
    	delta = melhor_vizinho(s, n, *peso_objetos, w, p,
        	               penalidade, b, *fo, fo_star,
                	       &melhor_posicao, &valor_bit,
                    	       &iniciotabu, &finaltabu);
	printf("\ndelta do melhor vizinho = %d melhor posicao = %d valor bit = %d\n", delta, melhor_posicao, valor_bit);
//	getchar();
	tabu = (struct lista *)malloc(sizeof(struct lista));
	if (!tabu) {
   	   printf("Faltando memoria ...\n");
	   exit(1);
    	}
          /* vou inserir um registro na lista tabu */
	tabu->posicao  = melhor_posicao;
    	insere_lista_tabu(tabu, &iniciotabu, &finaltabu);
         /* vou calcular o tamanho da lista tabu e imprimi-la */
	printf("Tamanho da lista tabu = %2d\n",
               lenght_lista_tabu(&iniciotabu, &finaltabu));
    	display_lista_tabu(&iniciotabu, &finaltabu);

	   /* vou manter uma lista tabu com tamanho_maximo_lista_tabu elementos,
              isto e', se a lista tiver mais que essa quantidade de elementos,
              vou apagar o primeiro registro da lista */
	if (lenght_lista_tabu(&iniciotabu, &finaltabu) > tamanho_maximo_lista_tabu){
          	/* vou apagar o primeiro registro da lista tabu */
    	   apaga_registro_tabu(iniciotabu, &iniciotabu, &finaltabu);
    	   printf("novo Tamanho da lista tabu = %2d\n",
                  lenght_lista_tabu(&iniciotabu, &finaltabu));
	   display_lista_tabu(&iniciotabu, &finaltabu);
    	}
	s[melhor_posicao] = valor_bit;
        (*fo) += delta;
//        printf("fo corrente = %d \n",*fo);
//        getchar();
        (*peso_objetos) = (*peso_objetos) - (w[melhor_posicao])*(!valor_bit) +
                          (w[melhor_posicao])*(valor_bit);
	CPUfimtabu = clock();
    	imprime_fo("valordefoBT.out", (float)(CPUfimtabu - CPUiniciotabu)/CLOCKS_PER_SEC, *fo, iterBT);
        if (*fo > fo_star){
           MelhorIter = iterBT;
	   atualiza_melhor_solucao(s, s_star, n);
           fo_star = *fo;
//	   imprime_solucao(s_star,n);
           printf("\n****** fo_star = %3d **********\n",fo_star);
        }
    }
    CPUfimtabu = clock();
    imprime_fo("valordefoBT.out", (float)(CPUfimtabu - CPUiniciotabu)/CLOCKS_PER_SEC, *fo, iterBT);
    printf("********** Melhor Solucao Obtida *************** \n");
    imprime_solucao(s_star,n);
    *peso_objetos = calcula_peso_objetos(s_star, n, w);
    *inv = calcula_inviabilidade(*peso_objetos, b);
    printf("Saindo da Busca Tabu com fo_star = %d\n",fo_star);
    printf("peso dos objetos = %2d inviabilidade = %d \n",*peso_objetos, *inv);
    printf("Numero de solucoes analisadas = %ld \n",iterBT);
    printf("Numero de solucoes existentes = %.0f \n", exp(n*log(2)));
    printf("******************************************** \n");
    getchar();
    atualiza_melhor_solucao(s_star, s, n);
    libera_vetor(s_star);
    *fo = fo_star;
}


void SA(int n,
        int *s,
        int *p,
        int *w,
        int b,
        int penalidade,
        int *peso_objetos,
        int *fo,
        int *inv,
        double alfa,
        double temperatura_inicial,
        double temperatura_final,
        int SAmax)
{
    double x;              // numero aleatorio entre ZERO e UM
    double temperatura;    // temperatura corrente
    int iter;              // numero de iteracoes na temperatura corrente
    int num_mudancas_temp; // numero de mudancas de temperatura
    int posicao_escolhida; // objeto escolhido
    int delta;             // variacao de energia
    int fo_star;
    int *s_star;

    s_star = cria_vetor(n);
    inicializa_vetor(s_star,n);
    atualiza_melhor_solucao(s, s_star, n);
    fo_star = *fo;
    temperatura = temperatura_inicial;
    num_mudancas_temp = 0;
    printf("Solucao inicial: fo corrente = %d   peso dos objetos = %2d \n",*fo,*peso_objetos);
//    getchar();

	/* enquanto o sistema nao congelar faca */
    while (temperatura > temperatura_final) {
       iter = 0;
	  /* enquanto o equilibrio termico nao for atingido faca */
       while (iter < SAmax){
          iter++;
	  	/* escolha um vizinho qualquer */
	  posicao_escolhida = random(n);
//          imprime_solucao(s,n);
	  troca_bit(s, posicao_escolhida);
          if (s[posicao_escolhida])
             printf("Vou tentar incluir na mochila o objeto %d de peso %d \n", posicao_escolhida, w[posicao_escolhida]);
          else
             printf("Vou tentar excluir da mochila o objeto %d de peso %d \n", posicao_escolhida, w[posicao_escolhida]);
	  	/* calcule a variacao de energia */
          int peso_modificado = (*peso_objetos) - w[posicao_escolhida]*(!s[posicao_escolhida]) + w[posicao_escolhida]*s[posicao_escolhida];
          delta = - p[posicao_escolhida]*(!s[posicao_escolhida]) + penalidade * calcula_inviabilidade((*peso_objetos), b)
                  + p[posicao_escolhida]*s[posicao_escolhida] -  penalidade * calcula_inviabilidade(peso_modificado,b);
    	  printf("variacao de energia = %3d \n",delta);

	  	/* se houver melhora, aceite o vizinho */
	  if (delta > 0){
	     (*fo) += delta;
             (*peso_objetos) = (*peso_objetos) - (w[posicao_escolhida])*(!s[posicao_escolhida]) +
                               (w[posicao_escolhida])*(s[posicao_escolhida]);
             printf("Solucao de melhora: fo corrente = %d   peso dos objetos = %2d \n",*fo,*peso_objetos);
//             getchar();

             if (*fo > fo_star){
	  	atualiza_melhor_solucao(s, s_star, n);
		fo_star = *fo;
	  	imprime_solucao(s_star,n);
                printf("********** fo_star = %3d \n",fo_star);
//                getchar();
             }
	  }
	  else {
	      /* se houver piora, aceite o vizinho com uma determinada
                 probabilidade */
	      x = randomico(0,1);
              if (x < exp(delta/temperatura)){
	       	 (*fo) += delta;
                 (*peso_objetos) = (*peso_objetos) - (w[posicao_escolhida])*(!s[posicao_escolhida]) +
                                   (w[posicao_escolhida])*(s[posicao_escolhida]);
                 printf("Solucao de piora: fo corrente = %d   peso dos objetos = %2d \n",*fo,*peso_objetos);
//                 getchar();
              }
	      else {
               	/* Se o vizinho nao foi aceito, desfaca o movimento */
                 troca_bit(s, posicao_escolhida);
              }
	  }
        }
		/* decresca a temperatura */
        temperatura *= alfa;
        printf("Temperatura atual = %10.3f\n", temperatura);
        num_mudancas_temp += 1;
    }

    printf("********* Melhor Solucao obtida pelo SA ************** \n");
    imprime_solucao(s_star,n);
    (*peso_objetos) = calcula_peso_objetos(s_star, n, w);
    (*inv) = calcula_inviabilidade(*peso_objetos, b);
    printf("peso dos objetos = %2d inviabilidade = %d \n",*peso_objetos, *inv);
    printf("funcao objetivo = %3d \n",fo_star);
    printf("Num. max. de solucoes analisadas = %ld \n",num_mudancas_temp*SAmax);
    printf("Numero de solucoes existentes = %.0f \n", exp(n*log(2)));
    printf("****************************************************** \n");
    atualiza_melhor_solucao(s_star, s, n);
    (*fo) = fo_star;
    libera_vetor(s_star);
    getchar();
}


void constroi_solucao_parcialmente_gulosa(
        int n,
        int *s,
        int *p,
        int *w,
        int b,
        int penalidade,
        int *peso_objetos,
        int *fo,
        int *inv,
        double alfa_GRASP)
{
    struct lista_restrita *inicio_LC, *final_LC, *candidato;
    int posicao_escolhida; // objeto escolhido
    int delta;   // variacao de energia
    int fo_star;
    int tamanho_LC,
        tamanho_LRC;

    /* Inicio da Fase de Construcao de uma solucao */
    printf("\n Construindo nova solucao ...\n");
    inicio_LC = final_LC = NULL;
    inicializa_vetor(s,n);
    *peso_objetos = 0;
    *inv = 0;
    *fo = 0;
    for (int j=0; j<n; j++){
      candidato = (struct lista_restrita *)malloc(sizeof(struct lista_restrita));
      if (!candidato) {
         printf("Faltando memoria ...\n");
         exit(1);
      }
      /* vou inserir um registro em uma lista de candidatos,
         ordenada pelo beneficio relativo  */
      candidato->objeto = j;
      candidato->beneficio_relativo = (double) p[j]/w[j];
      insere_LC(candidato, &inicio_LC, &final_LC);
      tamanho_LC = lenght_LC(&inicio_LC, &final_LC);
      printf("Tamanho da LC = %2d\n", tamanho_LC);
      display_LC(&inicio_LC, &final_LC);
//      getchar();
    }
    while (tamanho_LC > 0){
       tamanho_LRC = MAX(1,(int) (alfa_GRASP * tamanho_LC));
       printf("Tamanho da LRC = %2d \n",tamanho_LRC);
       posicao_escolhida = random(tamanho_LRC);
       printf("Posicao escolhida da LRC = %2d \n",posicao_escolhida);
       candidato = encontra_objeto_LC(posicao_escolhida, &inicio_LC);
       printf("Objeto escolhido = %2d \n",candidato->objeto);
       if ((*peso_objetos) + w[candidato->objeto] <= b){
         s[candidato->objeto] = 1;
         (*peso_objetos) += w[candidato->objeto];
         printf("Objeto %2d de peso %2d incluido na solucao \n",
                 candidato->objeto, w[candidato->objeto]);
         printf("Peso atual dos objetos na mochila = %2d \n",*peso_objetos);
       }
       else
         printf("A inclusao do objeto %2d de peso %2d supera capacidade da mochila \n",
                 candidato->objeto, w[candidato->objeto]);
       printf("Vou eliminar o objeto %2d da LC\n",candidato->objeto);
//       getchar();
       apaga_registro_LC(candidato, &inicio_LC, &final_LC);
       tamanho_LC--;
       display_LC(&inicio_LC, &final_LC);
    }
    /* Fim da Fase de Construcao de uma solucao */

    *peso_objetos = calcula_peso_objetos(s, n, w);
    *inv = calcula_inviabilidade(*peso_objetos, b);
    *fo = calcula_fo(s, n, p, *inv, penalidade);
}


/* Cria matriz de ponteiros para inteiros com nlinhas e ncolunas */
int **cria_matriz(int nlinhas, int ncolunas)
{
  register int i;
  int **matriz;

  matriz = (int **) malloc(nlinhas*sizeof(int *));
  if (!matriz) {
        printf("Falta memoria para alocar a matriz de ponteiros\n");
        exit(1);
  }
  for (i=0; i < nlinhas; i++) {
    matriz[i] = (int *) malloc(ncolunas*sizeof(int));
    if (!matriz[i]){
      printf("Falta memoria para alocar a matriz de ponteiros.\n");
      exit(1);
    }
  }
  return matriz;
}


void libera_matriz(int **matriz, int nlinhas)
{
  register int i;

  for (i=nlinhas-1; i >= 0; i--)
    free((int *) matriz[i]);
  free((int *) matriz);
}


void mutacao(int *s, int n)
{
   int j;
   j = random(n);
   if (s[j])
        s[j] = 0;
   else
        s[j] = 1;
}

void crossover(int *pai1,
               int *pai2,
               int *filho1,
               int *filho2,
               int n,
               int ponto_de_corte)
{
  for (int j=0; j<ponto_de_corte; j++){
     filho1[j] = pai1[j];
     filho2[j] = pai2[j];
  }
  for (int j=ponto_de_corte; j<n; j++){
     filho1[j] = pai2[j];
     filho2[j] = pai1[j];
  }
}


void repara_inviabilidade(
        int n,
        int *s,
        int *p,
        int *w,
        int b,
        int penalidade,
        int *peso_objetos,
        int *fo,
        int *inv)
{
  int posicao_escolhida;

  do{
    do{
      posicao_escolhida = random(n);
    }while (s[posicao_escolhida] == 0);
    printf("posicao escolhida = %2d\n",posicao_escolhida);
    s[posicao_escolhida] = 0;
    (*peso_objetos) = (*peso_objetos) - w[posicao_escolhida];
    *inv = calcula_inviabilidade(*peso_objetos, b);
    printf("inviabilidade atual = %2d\n",*inv);
    *fo = calcula_fo(s, n, p, *inv, penalidade);
  }while (*inv);
}

/* Menu de geracao de uma solucao inicial */
int menu_solucao_inicial(void)
{
  int escolha;

  do {
    printf("\nGERACAO DA SOLUCAO INICIAL: \n");
    printf("                  1. Gulosa \n");
    printf("                  2. Parcialmente gulosa (GRASP) \n");
    printf("                  3. Aleatoria \n");
    printf("                  escolha: ");
    scanf("%d",&escolha);
  } while (escolha < 1 || escolha > 3);
  return escolha;
}

int menu_descida(void)
{
  int escolha;

  do {
    printf("\nMETODO DA DESCIDA: \n");
    printf("                  1. Metodo da Descida 1 Optimal \n");
    printf("                  2. Metodo da Descida 2 Optimal \n");
    printf("                  escolha: ");
    scanf("%d",&escolha);
  } while (escolha < 1 || escolha > 2);
  return escolha;
}

/* Menu principal */
int menu_principal(void)
{
  int escolha;

  do {
    printf("\n************************************************* \n");
    printf("         1. Gere solucao inicial \n");
    printf("         2. Metodo da Descida \n");
    printf("         3. Metodo Randomico de Descida \n");
    printf("         4. Metodo Randomico Nao Ascendente \n");
    printf("         5. Busca Tabu \n");
    printf("         6. Simulated Annealing \n");
    printf("         7. GRASP \n");
    printf("         8. Algoritmos Geneticos \n");
    printf("         9. VND \n");
    printf("        10. VNS \n");
    printf("         0. Sair \n");
    printf("         Escolha: ");
    scanf("%d",&escolha);
  } while (escolha < 0 || escolha > 10);
  return escolha;
}


void embaralha_vetor(int *vetor, int n)
{
  int aux, j1, j2;

  for (int i=0; i < n; i++)
  {
    j1 = random(n);
    j2 = random(n);
    while (j1 == j2) j2 = random(n);
    aux = vetor[j1];
    vetor[j1] = vetor[j2];
    vetor[j2] = aux;
  }
}


void descida1opt(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo, double percentual)
{
    int delta, melhor_delta, melhor_posicao;
    int n_vizinhos = MAX(0, (int) (percentual*n));
    int *vet, aux, j1, j2;

    melhor_delta = INT_MAX;
    vet = cria_vetor(n);

    for (int j=0; j < n; j++) vet[j] = j;

    while(melhor_delta > 0) //while 1
    {
        melhor_delta = -INT_MAX;
        embaralha_vetor(vet, n);

        for (int j=0; j < n_vizinhos; j++) //for 1
        {
            troca_bit(s, vet[j]);
            delta = (-p[vet[j]]*!s[vet[j]] + p[vet[j]]*s[vet[j]] + penalidade*MAX(0, *peso_objetos - b) - penalidade*MAX(0, *peso_objetos - w[vet[j]]*!s[vet[j]] + w[vet[j]]*s[vet[j]] - b));
            if (delta > melhor_delta) //if 1
            {
                melhor_delta = delta;
                melhor_posicao = vet[j];
            }//if 1
            troca_bit(s, vet[j]);
        }//for 1
        if (melhor_delta > 0) //if 2
        {
            *fo = *fo + melhor_delta;
            troca_bit(s, melhor_posicao); // s <-- s
            *peso_objetos += -w[melhor_posicao] * !s[melhor_posicao] + w[melhor_posicao] * s[melhor_posicao];
        }//if 2

    }//while 1

    printf("-------------------------------------------------\n");
    printf("Melhor solucao encontrada pelo Metodo da descida 1 Optimal:\n");
    printf("Funcao objetivo: %d\n", *fo);
    printf("Peso da mochila: %d    Inviabilidade = %d \n", *peso_objetos, MAX(0,*peso_objetos - b));
    printf("-------------------------------------------------\n");
    libera_vetor(vet);
}//descida1opt

void randomicodescida(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo, int maxIter)
{
    int delta, melhor_delta, melhor_posicao, iter;
    int v = 0;

    delta = INT_MAX;
    iter = 0;

    while(delta > 0  || iter <= maxIter) //while1
    {
        v = random(n);
        troca_bit(s, v);
        delta = (-p[v]*!s[v] + p[v]*s[v] + penalidade*MAX(0, *peso_objetos - b) - penalidade*MAX(0, *peso_objetos - w[v]*!s[v] + w[v]*s[v] - b));
        troca_bit(s, v  );
        printf("\niter = %d | delta = %d",iter,delta);
        if (delta > 0) //if 1
        {
           *fo = *fo + delta;
           troca_bit(s, v); // s <-- s
           *peso_objetos += -w[v] * !s[v] + w[v] * s[v];
           iter = 0;
        }//if 1
        else iter++;
    } //while2

    printf("-------------------------------------------------\n");
    printf("Melhor solucao encontrada pelo Metodo da Randomico de descida:\n");
    printf("Funcao objetivo: %d\n", *fo);
    printf("Peso da mochila: %d    Inviabilidade = %d \n", *peso_objetos, MAX(0,*peso_objetos - b));
    printf("-------------------------------------------------\n");
}//randomicodescida

void descida2opt(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo)
{
    int delta, melhor_delta, melhor_posicao1,melhor_posicao2;

    melhor_delta = INT_MAX;

    while(melhor_delta > 0) //while 1
    {
        melhor_delta = -INT_MAX;

        for (int i = 0; i < n-1; i++)//for1
        {
           troca_bit(s,i);
           for (int j = i+1; j < n; j++) //for2
           {
               troca_bit(s,j);
               delta = (-p[j]*!s[j] + p[j]*s[j] -p[i]*!s[i] + p[i]*s[i] + penalidade*MAX(0, *peso_objetos - b) - penalidade*MAX(0, *peso_objetos - w[j]*!s[j] + w[j]*s[j] - w[i]*!s[i] + w[i]*s[i] - b));
               if (delta > melhor_delta) //if 1
               {
                   melhor_delta = delta;
                   melhor_posicao1 = i;
                   melhor_posicao2 = j;
               }//if 1
               troca_bit(s,j);
           }//for2
           troca_bit(s,i);
        }//for1
        if (melhor_delta > 0) //if 2
        {
            *fo = *fo + melhor_delta;
            troca_bit(s, melhor_posicao1); // s <-- s
            troca_bit(s, melhor_posicao2);
            *peso_objetos += -w[melhor_posicao1] * !s[melhor_posicao1] + w[melhor_posicao1] * s[melhor_posicao1] -w[melhor_posicao2] * !s[melhor_posicao2] + w[melhor_posicao2] * s[melhor_posicao2];
        }//if 2

    }//while 1

    printf("-------------------------------------------------\n");
    printf("Melhor solucao encontrada pelo Metodo da descida 2 Optimal:\n");
    printf("Funcao objetivo: %d\n", *fo);
    printf("Peso da mochila: %d    Inviabilidade = %d \n", *peso_objetos, MAX(0,*peso_objetos - b));
    printf("-------------------------------------------------\n");
}//descida2opt

void vnd(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo)
{
    int *sl;
    int peso_objsl,fosl;
    sl = cria_vetor(n);
    for (int i = 0; i < n; i++) sl[i] = s[i];
    peso_objsl = *peso_objetos;
    fosl = *fo;

    int k = 1;

    while(k <= 2) //while 1
    {
       switch(k){
       case 1: descida1opt(n, sl, p, w, b, penalidade, &peso_objsl, &fosl, 0.8);
               break;
       case 2: descida2opt(n, sl, p, w, b, penalidade, &peso_objsl, &fosl);
               break;
       }
       if (fosl > *fo)
       {
          for (int i = 0; i < n; i++) s[i] = sl[i];
          *fo = fosl;
          *peso_objetos = peso_objsl;
          k = 1;
       }
       else k++;
    }//while 1

    printf("-------------------------------------------------\n");
    printf("Melhor solucao encontrada pelo VND:\n");
    printf("Funcao objetivo: %d\n", *fo);
    printf("Peso da mochila: %d    Inviabilidade = %d \n", *peso_objetos, MAX(0,*peso_objetos - b));
    printf("-------------------------------------------------\n");
    libera_vetor(sl);
}//vnd


void vizqq1opt(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo)
{
    int pos,delta;
    pos = random(n);
    troca_bit(s, pos);
    delta = (-p[pos]*!s[pos] + p[pos]*s[pos] + penalidade*MAX(0, *peso_objetos - b) - penalidade*MAX(0, *peso_objetos - w[pos]*!s[pos] + w[pos]*s[pos] - b));
    *fo = *fo + delta;
    *peso_objetos += -w[pos] * !s[pos] + w[pos] * s[pos];
}//vizqq1opt

void vizqq2opt(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo)
{
    int p1, p2, delta;
    p1 = random(n);
    p2 = random(n);
    while (p1 == p2) p2 = random(n);
    troca_bit(s, p1);
    troca_bit(s, p2);
    delta = (-p[p1]*!s[p1] + p[p1]*s[p1] -p[p2]*!s[p2] + p[p2]*s[p2] + penalidade*MAX(0, *peso_objetos - b) - penalidade*MAX(0, *peso_objetos - w[p1]*!s[p1] + w[p1]*s[p1] - w[p2]*!s[p2] + w[p2]*s[p2] - b));
    *fo = *fo + delta;
    *peso_objetos += -w[p1] * !s[p1] + w[p1] * s[p1] -w[p2] * !s[p2] + w[p2] * s[p2];
}//vizqq2opt


void vns(int n, int *s, int *p, int *w, int b, int penalidade, int *peso_objetos, int *fo, double tempo)
{
    int *sl;
    int peso_objsl,fosl;
    sl = cria_vetor(n);
    clock_t inicioCPU, fimCPU;
    inicioCPU = fimCPU = clock();

    while((fimCPU - inicioCPU) / CLK_TCK < tempo) //while1
    {
       int k = 1;
       while(k <= 2) //while2
       {
          for (int i = 0; i < n; i++) sl[i] = s[i];
          peso_objsl = *peso_objetos;
          fosl = *fo;
          switch(k){ //Gere um vizinho qualquer na vizinhanca corrente
          case 1: vizqq1opt(n, sl, p, w, b, penalidade, &peso_objsl, &fosl);
                  break;
          case 2: vizqq2opt(n, sl, p, w, b, penalidade, &peso_objsl, &fosl);
                  break;
          }
          vnd(n,sl,p,w,b,penalidade,&peso_objsl, &fosl);
          if (fosl > *fo)
          {
             for (int i = 0; i < n; i++) s[i] = sl[i];
             *fo = fosl;
             *peso_objetos = peso_objsl;
             k = 1;
          }
          else k++;
       }//while2
       fimCPU = clock();
    }//while 1

    printf("-------------------------------------------------\n");
    printf("Melhor solucao encontrada pelo VNS em %0.f segundos:\n", tempo);
    printf("Funcao objetivo: %d\n", *fo);
    printf("Peso da mochila: %d    Inviabilidade = %d \n", *peso_objetos, MAX(0,*peso_objetos - b));
    printf("-------------------------------------------------\n");
    libera_vetor(sl);
}//vns


void AG(int n,
        int *s,
        int *p,
        int *w,
        int b,
        int penalidade,
        int *peso_objetos,
        int *fo,
        int nind,
        int max_geracoes,
        double prob_crossover,
        double prob_mutacao)
{
    int **pop; // populacao
    int *fo_pop; // funcao objetivo corrente de um dado individuo da populacao
    int *inv_pop;  // quantidade de inviabilidade de cada individuo
    int *peso_objetos_pop; // peso dos objetos de cada individuo
    int **pop_sobrev; // populacao sobrevivente
    int *fo_pop_sobrev; // funcao objetivo corrente de um dado individuo da populacao sobrevivente
    int *inv_pop_sobrev;  // quantidade de inviabilidade de cada individuo da populacao sobrevivente
    int *peso_objetos_pop_sobrev; // peso dos objetos de cada individuo da populacao sobrevivente
    int *s_star;   // vetor que contem a melhor solucao gerada
    int fo_star;   // valor da melhor solucao gerada

    s_star = cria_vetor(n);
    fo_star = *fo = -INT_MAX;
    nind = nind * 2;
    pop = cria_matriz(nind, n);
    inv_pop = cria_vetor(nind);
    peso_objetos_pop = cria_vetor(nind);
    fo_pop = cria_vetor(nind);
    inicializa_vetor(inv_pop,nind);
    inicializa_vetor(peso_objetos_pop,nind);
    inicializa_vetor(fo_pop,nind);
    for (int j=0;j<nind;j++) inicializa_vetor(pop[j],n);
    inicializa_vetor(s_star,n);

    pop_sobrev = cria_matriz(nind/2, n);
    inv_pop_sobrev = cria_vetor(nind/2);
    peso_objetos_pop_sobrev = cria_vetor(nind/2);
    fo_pop_sobrev = cria_vetor(nind/2);
    inicializa_vetor(inv_pop_sobrev,nind/2);
    inicializa_vetor(peso_objetos_pop_sobrev,nind/2);
    inicializa_vetor(fo_pop_sobrev,nind/2);
    for (int j=0;j<nind/2;j++) inicializa_vetor(pop_sobrev[j],n);

    /* Geracao da populacao inicial */
    for (int j=0; j< nind/2; j++){
        constroi_solucao_aleatoria(pop[j], n);
        //imprime_solucao(pop[j],n);
        peso_objetos_pop[j] = calcula_peso_objetos(pop[j], n, w);
        inv_pop[j] = calcula_inviabilidade(peso_objetos_pop[j], b);
        fo_pop[j] = calcula_fo(pop[j], n, p, inv_pop[j], penalidade);
        printf("Individuo %d : fo = %2d  peso = %2d  inviabilidade = %d \n",
               j, fo_pop[j], peso_objetos_pop[j], inv_pop[j]);
        if (inv_pop[j]){
           repara_inviabilidade(n,pop[j],p,w,b,penalidade,&peso_objetos_pop[j],&fo_pop[j],&inv_pop[j]);
           printf("Individuo %d reparado : fo = %2d  peso = %2d  inviabilidade = %d \n",
                   j, fo_pop[j], peso_objetos_pop[j], inv_pop[j]);
           //imprime_solucao(pop[j],n);
        }
        if (fo_pop[j] > fo_star){
           fo_star = fo_pop[j];
           atualiza_melhor_solucao(pop[j], s_star, n);
        }
    }
    printf("fo do Melhor individuo da populacao inicial = %2d\n",fo_star);

    int ngeracoes = 0;
    while (ngeracoes < max_geracoes){
      ngeracoes++;
      /* Aplicar crossover */
      int quant_filhos = 0;
      while (quant_filhos < nind/2){
          /* Selecao aleatoria de pais */
          int jpai1 = random(nind/2);
          int jpai2 = random(nind/2);
          if (randomico(0,1) < prob_crossover){
             int ponto_de_corte = random(n);
             crossover(pop[jpai1], pop[jpai2], pop[quant_filhos+nind/2], pop[quant_filhos+nind/2+1], n, ponto_de_corte);
             quant_filhos+=2;
          }
      }
      /* Aplicar mutacao */
      for (int j=0; j < nind; j++)
        if (randomico(0,1) < prob_mutacao)
           mutacao(pop[j], n);
      /* Avaliar a populacao inteira (pais e filhos) */
      for (int j=0; j<nind; j++){
        peso_objetos_pop[j] = calcula_peso_objetos(pop[j], n, w);
        inv_pop[j] = calcula_inviabilidade(peso_objetos_pop[j], b);
        fo_pop[j] = calcula_fo(pop[j], n, p, inv_pop[j], penalidade);
        printf("Individuo %d : fo = %2d  peso = %2d  inviabilidade = %d \n",
               j, fo_pop[j], peso_objetos_pop[j], inv_pop[j]);
        if (inv_pop[j]){
           repara_inviabilidade(n,pop[j],p,w,b,penalidade,&peso_objetos_pop[j],&fo_pop[j],&inv_pop[j]);
           printf("Individuo %d reparado : fo = %2d  peso = %2d  inviabilidade = %d \n",
                   j, fo_pop[j], peso_objetos_pop[j], inv_pop[j]);
        }
        if (fo_pop[j] > fo_star){
           fo_star = fo_pop[j];
           atualiza_melhor_solucao(pop[j], s_star, n);
        }
      }
      /* Definir a populacao sobrevivente */
      /* fo de todos os individuos da populacao, isto e', pais e filhos */
      for (int j=0; j<nind; j++)
        printf("fo_pop[%2d] = %2d\n",j,fo_pop[j]);
      for (int j=0; j<nind/2; j++){
        /* escolha dos individuos sobreviventes por selecao aleatoria */
        // int individuo_escolhido = random(nind);
        /* escolha dos individuos sobreviventes pelo mecanismo da roleta russa */
        int individuo_escolhido = roleta(nind, fo_pop);

        for (int i=0; i<n; i++) pop_sobrev[j][i] = pop[individuo_escolhido][i];
        fo_pop_sobrev[j] = fo_pop[individuo_escolhido];
        peso_objetos_pop_sobrev[j] = peso_objetos_pop[individuo_escolhido];
        inv_pop_sobrev[j] = inv_pop[individuo_escolhido];
      }
      /* Zerar a populacao e seus dados */
      inicializa_vetor(inv_pop,nind);
      inicializa_vetor(peso_objetos_pop,nind);
      inicializa_vetor(fo_pop,nind);
      for (int j=0;j<nind;j++) inicializa_vetor(pop[j],n);
      /* Primeira metade da populacao <-- populacao sobrevivente */
      for (int j=0; j<nind/2; j++){
        for (int i=0; i<n; i++) pop[j][i] = pop_sobrev[j][i];
        fo_pop[j] = fo_pop_sobrev[j];
        peso_objetos_pop[j] = peso_objetos_pop_sobrev[j];
        inv_pop[j] = inv_pop_sobrev[j];
      }
      /* fo dos individuos sobreviventes */
      for (int j=0; j<nind/2; j++)
        printf("fo_pop[%2d] = %2d\n",j,fo_pop[j]);
      /* Zerar a matriz e os vetores que armazenam os dados da populacao sobrevivente */
      inicializa_vetor(inv_pop_sobrev,nind/2);
      inicializa_vetor(peso_objetos_pop_sobrev,nind/2);
      inicializa_vetor(fo_pop_sobrev,nind/2);
      for (int j=0;j<nind/2;j++) inicializa_vetor(pop_sobrev[j],n);
    }
    imprime_solucao(s_star,n);
    atualiza_melhor_solucao(s_star, s, n);
    *fo = fo_star;
    *peso_objetos = calcula_peso_objetos(s_star, n, w);;

    printf("-------------------------------------------------\n");
    printf("Melhor solucao encontrada pelo Algoritmo Genetico:\n");
    printf("Funcao objetivo: %d\n", *fo);
    printf("Peso da mochila: %d    Inviabilidade = %d \n", *peso_objetos, MAX(0,*peso_objetos - b));
    printf("-------------------------------------------------\n");

    libera_matriz(pop, nind);
    libera_vetor(inv_pop);
    libera_vetor(peso_objetos_pop);
    libera_vetor(fo_pop);
    libera_matriz(pop_sobrev, nind/2);
    libera_vetor(inv_pop_sobrev);
    libera_vetor(peso_objetos_pop_sobrev);
    libera_vetor(fo_pop_sobrev);
    libera_vetor(s_star);
}

/* Esta rotina devolve o individuo escolhido pelo mecanismo da roleta russa */
int roleta(int nind, int *fo_pop)
{
  register int j;
  double aux;
  double *escala, *fracao;
  int escolhido;

  fracao = cria_vetor_double(nind);
  escala = cria_vetor_double(nind);
  int soma = 0;
  for (int j=0; j < nind; j++){
    soma += fo_pop[j];
    printf("fo_pop[%d] = %d \n",j,fo_pop[j]);
  }
  for (int j=0; j < nind; j++){
    fracao[j] = (double) fo_pop[j]/soma;
    printf("fracao[%d] = %f \n",j,fracao[j]);
  }
  escala[0] = fracao[0];
  for (int j=1; j < nind; j++){
    escala[j] = escala[j-1] + fracao[j];
    printf("escala[%d] = %f \n",j,escala[j]);
  }
  aux = randomico(0,1);
  j = 0;
  while (escala[j] <= aux) j++;
  escolhido = j;
  free(fracao);
  free(escala);
  return escolhido;
}
