%%% ====================================================
%%% @LaTeX-file{
%%%    filename  = "CNMAC-p23.cls",
%%%    date      = "30/07/1999",
%%%    author    = "A. Sri Ranga",
%%%    abstract  = "This is a LaTeX documentclass for 
%%%                 proceedings volumes of the CNMAC.",
%%% }
%%% ====================================================
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{CNMAC-p23}

\LoadClass[10pt, a4paper, twoside]{article}
\setlength{\textwidth}{12.7cm}
\setlength{\textheight}{19.0cm}
\setlength{\topmargin}{0cm}
\setlength{\oddsidemargin}{1.61cm}
\setlength{\evensidemargin}{1.61cm}

%\renewcommand{\thefootnote}(\arabic{footnote}}

%\renewcommand{\thetheorem}{\arabic{section}.\arabic{theorem}.}
%\renewcommand{\thecor}{\arabic{section}.\arabic{cor}.}
%\renewcommand{\thelemma}{\arabic{section}.\arabic{lemma}.}

\renewcommand{\thesection}{\arabic{section}.}
\renewcommand{\theequation}{\thesection \arabic{equation}}

\renewenvironment{abstract}
{\begin{list}{}{%
  \setlength{\rightmargin}{0.5cm}
  \setlength{\leftmargin}{0.5cm}
  \small} 
  \item[] }
{\end{list}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand{\ps@headCNMAC}
{ \renewcommand{\@oddhead}
  {\begin{minipage}{\textwidth}
     {\footnotesize {\em Submetido para Proceedings do XXIII 
      CNMAC.}} \\
     {\footnotesize {\em \copyright \ Uma Publica\c{c}\~{a}o  
      da Sociedade Brasileira de Matem\'{a}tica Aplicada 
      e Computacional.}} \\
     \rule{\textwidth}{0.6pt} 
   \end{minipage}
  }
%  \renewcommand{\@oddfoot}
%  {\begin{center}
%     \arabic{page}
%   \end{center}
%  }
  \renewcommand{\@oddfoot}{}
  \renewcommand{\@evenhead}{\@oddhead}
  \renewcommand{\@evenfoot}{\@oddfoot}
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand\criartitulo{\par
  \begingroup
    \renewcommand\thefootnote{\@arabic\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
      
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@criartitulo

    \thispagestyle{headCNMAC}\@thanks
    \markright{\bf \small \copyright \ SBMAC \\ Proceedings of the XXII CNMAC  }
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\criartitulo\relax
  \global\let\@criartitulo\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
\def\@criartitulo{%
  \newpage
  \null
  \vskip 0em%
  \begin{center}%
  \let \footnote \thanks
    {\LARGE \@title \par}%
  \end{center}%
    \vskip 1.5em%
    {\normalsize
      \lineskip .5em%
      \begin{minipage}[b]{\textwidth}
        \@author
      \end{minipage}\par}%
    \vskip 1em%
    %{\large \@date}%
  \par
  \vskip 1em}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%\pagestyle{myheadings}
\newcommand{\runningheads}{\markboth}
\pagestyle{myheadings}

\normalsize

\setcounter{page}{1}

\endinput
