unit Principal;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, jpeg, ExtCtrls, ComCtrls;

const
        p2 = 100000000;
        p3 = 10000000;
        alfa = 0.95;
        T0 = 1600;
        SAmax = 3300;

type

  // registro dos jogos t1 x t2
  TJogo = record
        t1,
        t2:integer;
  end;

  // registro usado na matriz de controle
  TCelula = record
        casa,
        fora:integer;
  end;

  TBrasileiro = class(TForm)
    MainMenu1: TMainMenu;
    Exibir1: TMenuItem;
    Times1: TMenuItem;
    Solinicial1: TMenuItem;
    Distncias1: TMenuItem;
    Button1: TButton;
    Button2: TButton;
    RODAR1: TMenuItem;
    FO1: TMenuItem;
    Image1: TImage;
    ProgressBar1: TProgressBar;
    tabela2002: TMenuItem;
    GerarSoluoInicial1: TMenuItem;
    SoluoInicial1: TMenuItem;
    Sobre1: TMenuItem;
    SAIR1: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure Solinicial1Click(Sender: TObject);
    procedure Times1Click(Sender: TObject);
    procedure Distncias1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Principal1Click(Sender: TObject);
    procedure RODAR1Click(Sender: TObject);
    procedure FO1Click(Sender: TObject);
    procedure tabela2002Click(Sender: TObject);
    procedure SoluoInicial1Click(Sender: TObject);
    procedure Sobre1Click(Sender: TObject);
    procedure SAIR1Click(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var

  Brasileiro: TBrasileiro;

  {:: Vetor que guarda os nomes dos times existentes ::}
  VetorTimes : array[1..26] of string;

  {:: Matriz que guarda as distncias entre os times ::}
  { MatDist[time1, time2], sendo time1 e time2 os ndices de VetorTimes}
  MatDist: array[1..26,2..26] of integer;

  {:: Matriz que guarda os confrontos dos times ::}
  Tabela: array[1..13,1..29] of TJogo;

  {  o quadro de respostas "Jogos X Rodadas" }
  Tabela_Star: array[1..13,1..29] of TJogo;

  {:: Campos 27 e 28 em x referem-se a NI1 e NI2 respectivamente ::}
  {:: Campos 30 e 31 em y referem-se a NI3 e FO respectivamente ::}
  MatControle: array[1..28,1..31] of TCelula;

  {:: Funo Objetivo do problema envolvido ::}
  {:: Compreende o valor registrado pelas distncias entre ::}
  {:: as cidades menos os valores das penalidades existentes ::}
  {-- FO_Temp = FO + p2*NI2 + p3*NI3 --}
  FO_Temp : double;

  FO, Dist_Star : double; {Referente as distncias}

  { Registra o nmero de inviabilidades de cada tipo }
  NI2, NI3 : integer;

  fim, inicio: string;

  VetEstadio: array[1..26] of string;

implementation

uses rodadas, ListaTimes, Dist_times, Resultados, Tabela_2002, Sobre;

{$R *.DFM}

{&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&}

procedure CalculaFO_Temp(p2,p3:double);
begin
        FO_Temp:= (p2*NI2) + (p3*NI3) + FO;
end;

{&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&}

// Inicializa a MatControle[], bem como as variveis globais
procedure InicializarControle;
var
        i,j:integer;
begin
        for i:= 1 to 28 do
                for j:= 1 to 31 do
                begin
                        MatControle[i,j].casa:= 0;
                        MatControle[i,j].fora:= 0;
                end;
        NI2:= 0;
        NI3:= 0;
        FO:= 0;
end;

{&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&}

{:: Monta a Matriz de controle MatControle ::}
procedure MontarControle;
var
        time, j, r,
        somaNI2,somaNI3,
        dist, aux,
        controle, time_anterior, modulo:integer;
begin
     InicializarControle;
     time_anterior:= 0; // Inicializa time_anterior
     for time:= 1 to 26 do
     begin // begin 1 -> percorre todos os times
        somaNI3:= 0; // Reseta o valor de NI3 para cada time
        dist:= 0; // Reseta o valor da distncia percorrida para cada time
        controle:= 1; // Usado para marcar o jogo do time em uma dada rota
        r:=1;
        while (r <= 29) do
        begin  // begin 2 -> percorre todas as rodadas do time corrente
             j:=1; // contador do while
             somaNI2:= 0; // Conta o N. de vezes que o time joga na rodada r
             While (j <= 13) do
             begin // begin 3 -> percorre todos os jogos da rodada corrente
                // Modulariza o sinal do time 1
                if (Tabela[j,r].t1 < 0 ) then aux:= Tabela[j,r].t1 * -1
                else aux:= Tabela[j,r].t1;

                // Compara o time 1 com o time corrente
                if(aux = time) then
                begin // begin 4
                     // Verifica se time joga fora de casa
                     if (Tabela[j,r].t1 < 0 ) then
                     begin //begin 5
                        MatControle[time,r].fora:= MatControle[time,r].fora + 1;
                        MatControle[Tabela[j,r].t2,r].casa:= MatControle[Tabela[j,r].t2,r].casa + 1;
                        // verifica se  o primeiro jogo do time
                        if(controle = 1) then time_anterior:= time;

                        // calcula distncia percorrida pelo time
                        if( time_anterior < Tabela[j,r].t2 ) then
                        begin
                                dist:= dist + MatDist[time_anterior, Tabela[j,r].t2] ;
                                time_anterior:= Tabela[j,r].t2;
                        end
                        else
                        begin
                                dist:= dist + MatDist[Tabela[j,r].t2, time_anterior];
                                time_anterior:= Tabela[j,r].t2;
                        end;
                        controle:= controle + 1; // incrementa o jogo da rota
                        somaNI3:= somaNI3 + 1;   // incrementa o N. de vezes que o time joga fora de casa

                        // Incrementa o campo NI3 cada vez que o time joga mais de duas vezes fora de casa
                        if(somaNI3 > 2) then MatControle[time,30].casa:= MatControle[time,30].casa  + 1;

                     end //end 5
                     else
                     begin
                         MatControle[time,r].casa:= MatControle[time,r].casa + 1;
                         MatControle[Tabela[j,r].t2,r].fora:= MatControle[Tabela[j,r].t2,r].fora + 1;
                         somaNI3:= 0; // Reseta somaNI3 em caso de jogo em casa
                         // Calcula distncia de retorno do time
                         if(controle <> 1) then // caso o time esteja jogando fora de casa
                         begin
                                if( time < time_anterior ) then dist:= dist + MatDist[time, time_anterior]
                                else  dist:= dist + MatDist[time_anterior, time];
                                controle:= 1; // reseta o controle para o primeiro jogo da rota
                         end;
                     end;
                     // caso time encontrado, atualiza-se somaNI2 da rodada
                     somaNI2:= somaNI2 + 1;
                end  // end 4
                else
                if(Tabela[j,r].t2 = time) then
                begin // begin 5
                     // Verifica se time joga fora de casa
                     if (Tabela[j,r].t1 < 0 ) then
                     begin
                        modulo := Tabela[j,r].t1 * -1;
                        MatControle[time,r].casa:= MatControle[time,r].casa + 1;
                        MatControle[modulo,r].fora:= MatControle[modulo,r].fora + 1;
                        somaNI3:= 0; // Reseta somaNI3 em caso de jogo em casa
                        // Calcula a distncia de retorno do time
                        if(controle <> 1) then // caso o time esteja jogando fora de casa
                        begin
                               if( time < time_anterior ) then dist:= dist + MatDist[time, time_anterior]
                               else  dist:= dist + MatDist[time_anterior, time];
                               controle:= 1; // reseta o controle para o primeiro jogo da rota
                        end;
                     end
                     else
                     begin
                         MatControle[time,r].fora:= MatControle[time,r].fora + 1;
                         MatControle[Tabela[j,r].t1,r].casa:= MatControle[Tabela[j,r].t1,r].casa + 1;

                         // Calcula a distncia entre os times
                         if(controle = 1) then time_anterior:= time;

                         if( time_anterior < Tabela[j,r].t1 ) then
                         begin
                                dist:= dist + MatDist[time_anterior, Tabela[j,r].t1];
                                time_anterior:= Tabela[j,r].t1;
                         end
                         else
                         begin
                                dist:= dist + MatDist[Tabela[j,r].t1, time_anterior];
                                time_anterior:= Tabela[j,r].t1;
                         end;
                         controle:= controle + 1; // incrementa o jogo na rota
                         somaNI3:= somaNI3 + 1;   // incrementa o N. de vezes que o time joga fora de casa

                         // Incrementa caso o time dois jogue fora de casa
                         if(somaNI3 > 2) then MatControle[time,30].casa:= MatControle[time,30].casa  + 1;

                      end;
                     // caso time encontrado, atualiza-se somaNI2
                     somaNI2:= somaNI2 + 1;

                end;  // end 5
                j:= j + 1;   // incrementa contador while jogos

             end; // end 3  -> fim for jogos

             // Incrementa somaNI2 caso time corrente jogue mais de uma vez na rodada r
             if(somaNI2 > 1) then
             begin
                somaNI2:= somaNI2 - 1;
                MatControle[28,r].casa := MatControle[28,r].casa + somaNI2  ;
                NI2:= NI2 + somaNI2;
             end;
        r:= r + 1; //incrementa o contador While rodadas
        end;  // end 2 -> fim for rodadas

        // Atualiza valor global de NI3
        NI3:= NI3 + MatControle[time,30].casa;
        MatControle[time,31].casa:= dist; // Marca distncia percorrida na rota do time
        FO:= FO + dist; // Atualiza a funo objetivo referente as distncias percorridas - FO
     end; // end 1  -> fim for times
end;

{&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&}

{:: Calcula rota dos times aps realizada a troca de jogos ::}
procedure CalculaRota(time:integer);
var
        r, j,
        dist, controle,
        aux, somaNI3, time_anterior: integer;
begin
        NI3:= NI3 - MatControle[time,30].casa; // Subtrai de NI3 o N. de vezes que o time jogou mais de duas vezes fora de casa
        FO:= FO - MatControle[time,31].casa; // Subtrai de FO a distncia da antiga rota do time
        MatControle[time,30].casa:= 0; // Inicializa o campo referente a somaNI3 (NI3 parcial)
        MatControle[time,31].casa:= 0; // Inicializa a distncia da nova rota do time com 0
        dist:= 0; // Inicializa o valor da distncia percorrida para cada time
        somaNI3:= 0; // Inicializa
        controle:= 1; // Inicializa o time jogando em casa, dentro de sua rota
        time_anterior:= 0; // Inicializa time_anterior
        r:= 1;
        While( r <= 29) do
        begin  // begin 2 -> percorre todas as rodadas do time corrente
             j:=1; // contador do while
             While (j <= 13) do
             begin // begin 3 -> percorre todos os jogos da rodada corrente
                // Modulariza o sinal do time 1
                if (Tabela[j,r].t1 < 0 ) then aux:= Tabela[j,r].t1 * -1
                else aux:= Tabela[j,r].t1;

                if(controle = 1) then time_anterior:= time; // Quando time retorna para casa

                // Compara o time 1 com o time corrente
                if(aux = time) then
                begin // begin 4
                     // Verifica se time joga fora de casa
                     if (Tabela[j,r].t1 < 0 ) then
                     begin
                        // calcula distncia percorrida pelo time
                        if( time_anterior < Tabela[j,r].t2 ) then
                        begin
                                dist:= dist + MatDist[time_anterior, Tabela[j,r].t2] ;
                                time_anterior:= Tabela[j,r].t2;
                        end
                        else
                        begin
                                dist:= dist + MatDist[Tabela[j,r].t2, time_anterior];
                                time_anterior:= Tabela[j,r].t2;
                        end;
                        controle:= controle + 1; // incrementa o jogo da rota
                        somaNI3:= somaNI3 + 1;   // incrementa o N. de vezes que o time joga fora de casa

                        // Incrementa o campo NI3 cada vez que o time joga mais de duas vezes fora de casa
                        if(somaNI3 > 2) then MatControle[time,30].casa:= MatControle[time,30].casa  + 1;
                     end
                     else
                     begin
                         somaNI3:= 0; // Reseta somaNI3 em caso de jogo em casa
                         // Calcula distncia de retorno do time
                         if(controle <> 1) then // caso o time esteja jogando fora de casa
                         begin
                                if( time < time_anterior ) then dist:= dist + MatDist[time, time_anterior]
                                else dist:= dist + MatDist[time_anterior, time];
                                controle:= 1; // reseta o controle para o primeiro jogo da rota
                         end;
                     end;
                end  // end 4
                else
                if(Tabela[j,r].t2 = time) then
                begin // begin 5
                     // Verifica se time joga fora de casa
                     if (Tabela[j,r].t1 < 0 ) then
                     begin
                        somaNI3:= 0; // Reseta somaNI3 em caso de jogo em casa
                        // Calcula a distncia de retorno do time
                        if(controle <> 1) then // caso o time esteja jogando fora de casa
                        begin
                               if( time < time_anterior ) then dist:= dist + MatDist[time, time_anterior]
                               else dist:= dist + MatDist[time_anterior, time];

                               controle:= 1; // reseta o controle para o primeiro jogo da rota
                        end;
                     end
                     else
                     begin
                         // Calcula a distncia entre os times
                         if(controle = 1) then time_anterior:= time;

                         if( time_anterior < Tabela[j,r].t2 ) then
                         begin
                                dist:= dist + MatDist[time_anterior, Tabela[j,r].t2];
                                time_anterior:= Tabela[j,r].t2;
                         end
                         else
                         begin
                                dist:= dist + MatDist[Tabela[j,r].t2, time_anterior];
                                time_anterior:= Tabela[j,r].t2;
                         end;
                         controle:= controle + 1; // incrementa o jogo na rota
                         somaNI3:= somaNI3 + 1;   // incrementa o N. de vezes que o time joga fora de casa
                         // Incrementa caso o time jogue mais de duas vezes fora de casa
                         if(somaNI3 > 2) then MatControle[time,30].casa:= MatControle[time,30].casa  + 1;
                      end;
                end;  // end 5
                j:= j+1; // incrementa contador while jogos
             end; // end 3  -> fim for jogos
             r:= r+1; // incrementa contador while rodadas
        end;  // end 2 -> fim for rodadas

        // Atualiza valor global de NI3
         NI3:= NI3 + MatControle[time,30].casa;
         MatControle[time,31].casa:= dist; // Marca distncia percorrida na rota do time
         FO:= FO + dist; // Atualiza a funo objetivo referente as distncias percorridas - FO
end;

{&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&}

{:: Procedure que atualiza os campos da matriz MatControle ::}
{-- Soma 1 jogo quando um time entra na rodada e subtrai 1 quando sai --}
procedure AtualizaJogo(time1,time2,r,aux:integer);
begin
     // Atualiza campos casa e fora para os times envolvidos na troca
     if ( time1 > 0 ) then // Verifica se o time 1 est jogando dentro de casa
     begin
        MatControle[time1,r].casa:= MatControle[time1,r].casa + aux;
        MatControle[time2,r].fora:= MatControle[time2,r].fora + aux;
     end else
     begin
        time1:= time1 * -1; // Modulariza time_1
        MatControle[time2,r].casa:= MatControle[time2,r].casa + aux;
        MatControle[time1,r].fora:= MatControle[time1,r].fora + aux;
     end;
end;

{&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&}

{:: Movimento do tipo 2-optimal - troca de jogos de rodada ::}
{-- Representa a troca de dois jogos de suas rodadas --}
procedure TrocarJogos(j1, r1, j2, r2: integer);
var
   time_1, time_2:integer;
   modulo1, modulo2: integer;
begin
     if ( Tabela[j1, r1].t1 > 0 ) then  modulo1 := Tabela[j1, r1].t1
     else modulo1:= Tabela[j1, r1].t1 * -1;

     time_1 := Tabela[j1, r1].t1;
     time_2 := Tabela[j1, r1].t2;

     if ( Tabela[j2, r2].t1 > 0 ) then  modulo2 := Tabela[j2, r2].t1
     else modulo2:= Tabela[j2, r2].t1 * -1;

     // Decrementa N. de jogos dos times que saem da rodada r1
     AtualizaJogo(time_1, time_2, r1, -1);

     // Decrementa N. de jogos dos times que saem da rodada r2
     AtualizaJogo(Tabela[j2, r2].t1, Tabela[j2, r2].t2, r2, -1);

     // Troca os jogos de rodada
     Tabela[j1, r1].t1:= Tabela[j2, r2].t1;
     Tabela[j1, r1].t2:= Tabela[j2, r2].t2;

     Tabela[j2, r2].t1:= time_1;
     Tabela[j2, r2].t2:= time_2;

     // Incrementa N. de jogos dos times que entram da rodada r2
     AtualizaJogo(Tabela[j2, r2].t1, Tabela[j2, r2].t2, r2, 1);

     // Incrementa N. de jogos dos times que entram da rodada r1
     AtualizaJogo(Tabela[j1, r1].t1, Tabela[j1, r1].t2 , r1, 1);

     if (Tabela[j1, r1].t1 < 0) then modulo1 := Tabela[j1, r1].t1 * -1
     else modulo1 := Tabela[j1, r1].t1;

     if (Tabela[j2, r2].t1 < 0) then modulo2 := Tabela[j2, r2].t1 * -1
     else modulo2 := Tabela[j2, r2].t1;

     MontarControle;
end;

{&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&}

{:: Movimento do tipo 1-optimal - troca de sinal do jogo ::}
{-- Representa a troca do local onde o jogo se realizar --}
procedure TrocarSinal(jogo, rodada:integer);
var
   tim1, tim2 : integer; // valor dos times 1 e 2 em mdulo
begin
     //-- Atribuio dos valores dos times em variveis temporrias --
     //-- para manipulao no procedimento (em mdulo - positivos)--
     if (Tabela[jogo, rodada].t1 < 0) then
         tim1 := Tabela[jogo, rodada].t1 * -1
     else tim1 := Tabela[jogo, rodada].t1;
     tim2 := Tabela[jogo, rodada].t2;

     //-- Troca do sinal de t1 na Tabela de solues --
     Tabela[jogo, rodada].t1 := Tabela[jogo, rodada].t1 * -1;

     //-- Atualiza os campos casa e fora dos times tim1 e tim2 --
     if (Tabela[jogo, rodada].t1 > 0) then
     begin
          MatControle[tim1, rodada].casa := MatControle[tim1, rodada].casa + 1;
          MatControle[tim1, rodada].fora := MatControle[tim1, rodada].fora - 1;
          MatControle[tim2, rodada].casa := MatControle[tim2, rodada].casa - 1;
          MatControle[tim2, rodada].fora := MatControle[tim2, rodada].fora + 1;
     end else
     begin
          MatControle[tim1, rodada].casa := MatControle[tim1, rodada].casa - 1;
          MatControle[tim1, rodada].fora := MatControle[tim1, rodada].fora + 1;
          MatControle[tim2, rodada].casa := MatControle[tim2, rodada].casa + 1;
          MatControle[tim2, rodada].fora := MatControle[tim2, rodada].fora - 1;
     end;

     // Recalcula as rotas dos times 1 e 2; Atualiza NI3;
     if (tim1 <> 0) then
     begin
          CalculaRota(tim1);
          CalculaRota(tim2);
     end;
end;

{&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&}

{:: Inicializa os valores do vetor de times ::}
procedure InicializaVetorTimes;
var
   i : integer;
begin
     For i:=1 to 26 do
        VetorTimes[i] := '';
end;

{&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&}

{:: Inicializa os valores da Matriz de Distncias ::}
procedure InicializaMatrizDistancias;
var
   i,j: integer;
begin
     For i:=1 to 26 do
        For j:=i+1 to 26 do
           MatDist[i,j] := 0;
end;

{&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&}

{:: Inicializao da Tabela de Solues ::}
procedure InicializaTabela;
var
   x, y: integer;
begin
     For x:=1 to 13 do
        For y:=1 to 29 do
        begin
           Tabela[x,y].t1 := 0;
           Tabela[x,y].t2 := 0;

           Tabela_Star[x,y].t1 := 0;
           Tabela_Star[x,y].t2 := 0;
        end;
end;

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

{::  Monta o Vetor de Times e a Matriz de Distncias   ::}
{:: a partir da leitura do arquivo de entrada de dados ::}
procedure MontarVetores(arquivo:string);
var
        arq: Text; {manipulao de arquivo de entrada}
        time: string; {guarda o nome do time - temporrio}
        dist: integer; {guarda o valor da distncia - temporrio}
        ntimes: integer; {Contador para o nmero de times}
        i, j: integer; {Contadores para preenchimento de MatDist}
begin
        {Inicializao dos Vetor e Matriz}
        InicializaVetorTimes; {Inicializa o Vetor de Times - nomes}
        InicializaMatrizDistancias;  {Inicializa a Matriz de distncias}

        {Inicializao das variveis de manipulao temporria}
        time := '';
        ntimes := 1;

        {:: Inicia a manipulao do arquivo de entrada de dados ::}
        Assign(arq, arquivo);
        Reset(arq);

             {:: Inicia a montagem do vetor de times VetorTimes ::}
             readln(arq, time);
             While (time <> '') do
             begin
                  VetorTimes[ntimes] := time;
                  ntimes := ntimes + 1;
                  readln(arq, time);
             end;
             ntimes := ntimes - 1; {ntimes guarda o n. de times existente}
             {:: Fim da montagem do Vetor de Times VetorTimes ::}

             {:: Inicia a montagem da Matriz de Distncias MatDist ::}
             For i:=1 to ntimes do
                For j:=i+1 to ntimes do
                begin
                     readln(arq, dist);
                     MatDist[i,j] := dist;
                end;
             {:: Fim da montagem da Matriz MatDist ::}

        Close(arq);
        {:: Fim da manipulao do arquivo de entrada de dados ::}
end;

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

{:: Montagem da Tabela de Soluo Inicial ::}
procedure TabelaSolucaoInicial;
var
        i,j,t1,t2,sinal:integer;
        sort:double;
begin
        {:: Inicializa a Tabela de Solues ::}
        InicializaTabela;

        {Inicializao das variveis de uso da rotina}
        t1:=1;
        t2:=2;

        {:: Preenchimento dos jogos da Tabela ::}
        for i:= 1 to 13 do
                for j:= 1 to 29 do
                begin
                     // sorteia se o time vai jogar fora ou dentro de casa
                     sort:= Random;
                     if(sort < 0.5) then sinal:= -1
                     else sinal := 1;

                     if(t1 = 26) then Exit;
                     Tabela[i,j].t1:= t1*sinal;
                     Tabela[i,j].t2:= t2;
                     t2:= t2+1;
                     if ( t2=27 ) then
                     begin
                          t1:= t1+1;
                          t2:= t1+1;
                     end;
                end;
end;

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

procedure CarregaEstadios;
var
   estadio: TextFile;
   i:integer;
   linha: string;
begin
     i:= 1;
     AssignFile(estadio,'Estadios.txt');
     Reset(estadio);
     While not Eof(estadio) do
     begin
          Readln(estadio, linha);
          VetEstadio[i]:= linha;
          i:= i + 1;
     end;
     CloseFile(estadio);
end;

// Monta o arquivo de sada com os jogos discriminados por rodada
procedure MontarArqSaida;
var
   tab:TextFile;
   rod,jog,time1:integer;
   arquivo:string;
begin
     arquivo:= 'tabela'+fim[1]+fim[2]+fim[4]+fim[5]+fim[7]+fim[8]+'.txt';
     CarregaEstadios;
     Assign(tab,arquivo);
     Rewrite(tab);
     writeln(tab,'Inicio:  '+ inicio);
     writeln(tab,'Termino: '+ fim);
     writeln(tab,'FO_temp: '+ FloatToSTr(Fo_Temp));
     writeln(tab,'Distncia total percorrida: '+ FloatToStr(Dist_Star)+ '  km');
     writeln(tab,'NI2: '+ IntToStr(NI2));
     writeln(tab,'NI3: '+ IntToStr(NI3));
     writeln(tab,'Alfa: '+ FloatToStr(alfa));
     writeln(tab,'T0: '+ IntToStr(T0));
     writeln(tab,'SAmax: '+ IntToStr(SAmax));
     writeln(tab,'===============================');
     writeln(tab,'TABELA DO CAMPEONATO BRASILEIRO');
     writeln(tab,'');
     for rod:= 1 to 29 do
     begin
          writeln(tab,'');
          writeln(tab,'---------------------------------------');
          writeln(tab, 'Rodada '+IntToStr(rod));
          writeln(tab,'');
          for jog:= 1 to 13 do
          begin
               if( Tabela[jog,rod].t1 < 0 ) then
               begin
                    time1:=Tabela[jog,rod].t1 * -1;
                    writeln(tab, VetorTimes[Tabela[jog,rod].t2] + '   X   ' + VetorTimes[time1]+ '           '+ VetEstadio[Tabela[jog,rod].t2]);
               end
               else
                    if(Tabela[jog,rod].t1 > 0) then
                    begin
                         time1:= Tabela[jog,rod].t1;
                         writeln(tab, VetorTimes[time1] + '   X   ' + VetorTimes[Tabela[jog,rod].t2]+ '           '+VetEstadio[time1]);
                    end;
          end;
     end;
     CloseFile(tab);
end;

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//&&&&&&&&&&&&&&&&&&         SIMULATED ANNEALING         &&&&&&&&&&&&&&&&&&&&&&&
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

procedure Simulated_Annealing(alfa, T0: double; SAmax: integer);
var
    IterT, jog, rod, jog0, rod0, jog1, rod1: integer;
    delta, T, taxa: double;
    FO_Star, FO_Anterior: double;
    r1,r2,j1,j2,
    opcao: integer;
begin
    for jog := 1 To 13 do
        for rod := 1 To 29 do
        begin
            Tabela_Star[jog,rod].t1:= Tabela[jog,rod].t1;
            Tabela_Star[jog,rod].t2:= Tabela[jog,rod].t2;
        end;
    IterT := 0;
    T := T0;
    FO_Star:= FO_Temp;
    While (T > 0.00000000001) do
    begin
        Brasileiro.ProgressBar1.Position:= 1600 - Trunc(T+1);
        While (IterT < SAmax) do
        begin
            FO_Anterior:= FO_Temp;
            IterT := IterT + 1;
            opcao:= Trunc(random(2));
            // GerarVizinho;
            if(opcao = 0) then
            begin
                r1:= 0; r2:= 0;
                while (r1 = r2) do
                begin
                    r1:=Trunc(random(29)) + 1;
                    r2:=Trunc(random(29)) + 1;
                end;
                j1:=Trunc(random(13)) + 1;
                j2:=Trunc(random(13)) + 1;
                TrocarJogos(j1,r1,j2,r2);
            end
            else
            if(opcao = 1) then
            begin
                r1:=Trunc(random(29)) + 1;;
                j1:=Trunc(random(13)) + 1;;
                TrocarSinal(j1,r1);
            end;

            CalculaFO_Temp(p2,p3);
            delta := FO_Temp - FO_Star;
            if (delta < 0) then
            begin
                // Atualiza a Tabela_Star
                for jog0 := 1 To 13 do
                        for rod0 := 1 To 29 do
                        begin
                           Tabela_Star[jog0, rod0].t1:= Tabela[jog0, rod0].t1;
                           Tabela_Star[jog0, rod0].t2:= Tabela[jog0, rod0].t2;
                        end;
                // Atualiza a funo objetivo
                FO_Star := FO_Temp;
                Dist_Star:= FO;
            end
            else
            begin
                taxa:= random;
                // Verifica se movimento de piora ser aceito
                if ( taxa > {(1 - delta/T)} Exp(- delta / T) ) then
                begin
                    //destrocar os movimentos caso no aceite os movimentos
                    If (opcao = 0) then TrocarJogos(j1,r1,j2,r2)
                    else TrocarSinal(j1,r1);
                    FO_Temp:= FO_Anterior;
                end
                else // Aceita movimento de piora de acordo com uma certa taxa
                begin
                     // Atualiza a Tabela_Star
                     for jog0 := 1 To 13 do
                         for rod0 := 1 To 29 do
                         begin
                              Tabela_Star[jog0, rod0].t1:= Tabela[jog0, rod0].t1;
                              Tabela_Star[jog0, rod0].t2:= Tabela[jog0, rod0].t2;
                         end;
                        // Atualiza a funo objetivo
                        FO_Star := FO_Temp;
                        Dist_Star:= FO;
                end;
            end;
        end;
        T := alfa * T;
        IterT := 0;
    end;
    for jog1:= 1 to 13 do
    begin
        for rod1:= 1 to 29 do
        begin
            Tabela[jog1, rod1].t1:= Tabela_Star[jog1, rod1].t1;
            Tabela[jog1, rod1].t2:= Tabela_Star[jog1, rod1].t2;
        end;
    end;
        fim:= TimeToStr(Time);
        MessageBeep(16);
        MontarArqSaida;
        ShowMessage('TERMINOU A EXECUO!!!');
        Brasileiro.ProgressBar1.Visible:= False;
        FO:=Dist_Star;
end;

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&


procedure Inicializa;
begin
      MontarVetores('times.txt');
      TabelaSolucaoInicial;
      NI2:= 0;
      NI3:= 0;
      FO:= 0;
      MontarControle;
      CalculaFO_Temp(p2,p3);
end;

procedure TBrasileiro.FormShow(Sender: TObject);
begin
        Inicializa;
        ProgressBar1.Position:= 0;
        ProgressBar1.Max:= T0;
end;

procedure TBrasileiro.Solinicial1Click(Sender: TObject);
begin
     Solucao.Show;
end;

procedure TBrasileiro.Times1Click(Sender: TObject);
begin
        Times.ShowModal;
end;

procedure TBrasileiro.Distncias1Click(Sender: TObject);
begin
        Distancias.ShowModal;
end;

// troca dois jogos de lugar
procedure TBrasileiro.Button1Click(Sender: TObject);
var
        r1,j1,r2,j2:integer;
begin
        r1:=StrToInt(inputBox('TROCAR JOGOS','DIGITE A RODADA DO 1 JOGO',''));
        j1:=StrToInt(inputBox('TROCAR JOGOS','DIGITE O JOGO',''));
        r2:=StrToInt(inputBox('TROCAR JOGOS','DIGITE A RODADA DO 2 JOGO',''));
        j2:=StrToInt(inputBox('TROCAR JOGOS','DIGITE O JOGO',''));
        TrocarJogos(j1,r1,j2,r2);
end;

// traca a localidade de um dado jogo
procedure TBrasileiro.Button2Click(Sender: TObject);
var
        r,j:integer;
begin
        r:=StrToInt(inputBox('TROCAR JOGOS','DIGITE A RODADA DO 1 JOGO',''));
        j:=StrToInt(inputBox('TROCAR JOGOS','DIGITE O JOGO',''));
        TrocarSinal(j,r);
end;

// fecha a o programa
procedure TBrasileiro.Principal1Click(Sender: TObject);
begin
        Brasileiro.close;
end;

// Executa o problema
procedure TBrasileiro.RODAR1Click(Sender: TObject);
begin
        inicio:= TimeToStr(Time);
        ProgressBar1.Visible:= True;
        Simulated_Annealing(alfa, T0, SAmax);
end;

// Mostra os resulatdos
procedure TBrasileiro.FO1Click(Sender: TObject);
begin
     Resultado.Show;
end;

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

function Descobre_Indice_Time(time:string):integer;
var
   i: integer;
begin
     for i:= 1 to 26 do
          if(VetorTimes[i] = time) then
          begin
               Descobre_Indice_Time:= i;
               break;
          end else Descobre_Indice_Time:= 0;
end;

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

procedure Calcula_FO_CBF(arq:string);
var
   arquivo:TextFile;
   time: string;
   controle, j, r,indice:integer;
   branco: boolean;
begin
     r:= 1;
     j:= 1;
     controle:=1;
     AssignFile(arquivo,arq);
     Reset(arquivo);
     while not Eof(arquivo) do
     begin
          branco:= true;
          readln(arquivo,time);

          if(time = '') then
          begin
               r:= r + 1;
               j:= 1;
               branco:= false;
          end;

          if( branco ) then
          begin
               indice:= Descobre_Indice_Time(time);

               // verifica se foi encontrado o primeiro time
               if(controle = 1) then
               begin
                    Tabela[j,r].t1:= indice;
                    controle:=controle + 1;
               end
               else // verifica se foi encontrado o segundo time
               if(controle = 2) then
               begin
                    Tabela[j,r].t2:= indice;
                    controle:=1;
                    j:= j + 1;
               end;
          end;
     end;
     CloseFile(arquivo);
end;

// Realiza o clculo da funo objetivo referente  tabela feita pela CBF 2002
procedure TBrasileiro.tabela2002Click(Sender: TObject);
begin
    InicializaTabela;
    NI2:= 0;
    NI3:= 0;
    FO:= 0;
    Calcula_FO_CBF('Campeonato_2002.txt');
    MontarControle;
    CalculaFO_Temp(p2,p3);
    CBF.Show;
end;

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

//Gera uma soluo inicial aleatria
procedure TBrasileiro.SoluoInicial1Click(Sender: TObject);
var
   i,r1,r2,j1,j2:integer;
begin
     Inicializa;
     ShowMessage('SOLUO GERADA!!!');
end;

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

procedure TBrasileiro.Sobre1Click(Sender: TObject);
begin
     About.ShowModal;
end;

procedure TBrasileiro.SAIR1Click(Sender: TObject);
begin
     Brasileiro.Close;
end;

end.
