unit EditarTimes;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TEditar_Times = class(TForm)
    Edit1: TEdit;
    Time: TLabel;
    Anterior: TButton;
    OK: TButton;
    Proximo: TButton;
    Sair: TButton;
    procedure SairClick(Sender: TObject);
    procedure AnteriorClick(Sender: TObject);
    procedure ProximoClick(Sender: TObject);
    procedure OKClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Editar_Times: TEditar_Times;

  Times: array[1..26] of String;
  Dist: array[1..325] of integer;

  posicao: integer;

implementation

{$R *.DFM}

{:: Inicializa Vetor com o nome dos times ::}
procedure InicializaTimes;
var
   i: integer;
begin
     For i:=1 to 26 do
        Times[i]:='';
end;


{:: Verifica se o Vetor Times possui algum campo vazio ::}
Function TimesCampoVazio(): boolean;
var
   i: integer;
   temp: boolean;
begin
     temp := false;
     For i:=1 to 26 do
        if (Times[i]='') then
        begin
             temp := true;
             break;
        end;
     TimesCampoVazio := temp;
end;


{:: Inicializa Vetor com as distncias ::}
procedure InicializaDist;
var
   i: integer;
begin
     For i:=1 to 325 do
        Dist[i]:= 0;
end;

{:: Preenche os Vetores Times e Dist pelo Form ::}
procedure Cadastrar;
begin
     InicializaTimes;
     InicializaDist;
end;


procedure TEditar_Times.SairClick(Sender: TObject);
begin
     Editar_Times.Close;
end;

procedure TEditar_Times.AnteriorClick(Sender: TObject);
begin
     if (posicao > 1) then
     begin
        posicao := posicao - 1;
        Edit1.Text := Times[posicao];
     end;
end;

procedure TEditar_Times.ProximoClick(Sender: TObject);
begin
     if (posicao < 26) then
     begin
        posicao := posicao + 1;
        Edit1.Text := Times[posicao];
     end;
end;


procedure HabilitarTimes;
begin
     Editar_Times.Edit1.Enabled := true;
     Editar_Times.OK.Enabled := true;
     Editar_Times.Anterior.Enabled := true;
     Editar_Times.Proximo.Enabled := true;
end;


procedure DesabilitarTimes;
begin
     Editar_Times.Edit1.Enabled := false;
     Editar_Times.OK.Enabled := false;
     Editar_Times.Anterior.Enabled := false;
     Editar_Times.Proximo.Enabled := false;
end;


procedure HabilitarDist;
begin

end;


procedure TEditar_Times.OKClick(Sender: TObject);
begin
     if ( not TimesCampoVazio ) then
        if (posicao < 26) then
        begin
             if (Editar_Times.Edit1.Text <> '') then
             begin
                  Times[posicao]:=Editar_Times.Edit1.Text;
                  posicao := posicao + 1;
                  Edit1.Text := Times[posicao];
             end;
        end else
        begin
            HabilitarDist;
            DesabilitarTimes;
        end;
end;

end.
