#include <math.h>

/* Resolve um sistema Ax=b por substituicoes progressivas */
void SubstituicaoProgressiva(int n, float **a, float *x, float *b)
{
  int i, j;
  float soma;

  for (i = 1; i <= n; i++ ){
    soma = 0;
    for (j = 1; j <= i-1; j++) {
      soma = soma + a[i][j]*x[j];      
    }
    x[i] = (b[i] - soma) / a[i][i];
  }
}

/* Resolve um sistema Ax=b por substituicoes regressivas */
void SubstituicaoRetroativa(int n, float **a, float *x, float *b)
{
  int i, j;
  float soma;

  i = n;
  while (i >= 1){
    soma = 0;
    for (j = i+1; j <= n; j++) {
      soma = soma + a[i][j]*x[j];      
    }
    x[i] = (b[i] - soma) / a[i][i];
    i--;
  }
}

/* Calcula o residuo R dado por R = b - Ax */
void CalculaResiduo(int n, float *b, float **a, float *x, float *r)
{
   int i, j;
   float soma;
   for (i=1; i<=n; i++){
     soma = 0;
     for (j=1; j<=n; j++){
       soma = soma + a[i][j]*x[j];    
     }
     r[i] = b[i] - soma;        
   }    
}

/* Calcula o erro residual */
float CalculaErro(int n, float *r)
{
  int i;
  float maior;
  
  maior = 0;
  for (i=1; i<=n; i++){
    if ( fabs(r[i]) > maior){
      maior = fabs(r[i]);     
    }    
  }      
  return maior;      
}

/* Triangulariza superiormente uma matriz */
void Eliminacao(int n, float **a, float *b)
{
  int i, j, k;
  float m;
  
  for (k = 1; k <= n-1; k++){
    for (i = k+1; i <= n; i++){
      m = -a[i][k] / a[k][k];
      for (j=k+1; j<=n; j++){
        a[i][j] = a[i][j] + m * a[k][j];    
      }
      b[i] = b[i] + m * b[k];    
    }    
  }    
}

/* Triangulariza superiormente uma matriz pelo
   mtodo de Gauss com pivotao parcial. O vetor
   de termos independentes b tambm  afetado    */
void GaussPivoteamentoParcial(int n, float **a, float *b)
{
  int i, j, k, r;
  float w, m, aux;
  
  for (k = 1; k <= n-1; k++){
    w = fabs(a[k][k]);
    r = k;
    for (i=k; i<=n; i++){
      if (fabs(a[i][k]) > w){
        w = fabs(a[i][k]);
        r = i;
      }
    }
    for (j=k; j<=n; j++){
      aux = a[k][j];
      a[k][j] = a[r][j];
      a[r][j] = aux;
    }
    aux = b[k];
    b[k] = b[r];
    b[r] = aux;
    for (i = k+1; i <= n; i++){
      m = -a[i][k] / a[k][k];
      for (j=k+1; j<=n; j++){
        a[i][j] = a[i][j] + m * a[k][j];    
      }
      b[i] = b[i] + m * b[k];    
    }    
  }    
}
