/* Mtodo de Gauss para resolver sistemas lineares */
/* Autor: Marcone Jamilson Freitas Souza           */
/* E-mail: marcone@iceb.ufop.br                    */
/* ltima modificao: 05 de abril de 2009                             */

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <limits.h>
#include "Util.h"
#include "MetodosSistemas.h"

/* Programa principal                           */
int main(int argc, char* argv[])
{
    int n;         /* dimensao da matriz            */
    float *b,      /* vetor de termos independentes */
          *b_orig, /* vetor de termos independentes original */
          *x,      /* vetor solucao                 */
          **a,     /* matriz dos coeficientes       */
          **a_orig;/* matriz dos coeficientes original */
    float *r;  /* vetor residuo                 */
    float erro;
    
    printf("Entre com a dimensao da matriz = ");
    scanf("%d", &n);

    r = cria_vetor(n+1);
    b = cria_vetor(n+1);
    b_orig = cria_vetor(n+1);
    x = cria_vetor(n+1);
    le_arq_vetor("b.txt",n,b);

    a = cria_matriz(n+1,n+1);
    a_orig = cria_matriz(n+1,n+1);
    le_arq_matriz("a.txt",n,n,a);

    /* a_orig <--- a */
    printf("Matriz lida:\n");
    for (int i=1; i<=n; i++){
      for (int j=1; j<=n; j++){
        printf("%g \t",a[i][j]);
        a_orig[i][j] = a[i][j];
      }
      printf("\n");
    }

    /* b_orig <--- b */
    printf("Vetor de termos independentes lido:\n");
    for (int i=1; i<=n; i++){
      printf("%g \n",b[i]);
      b_orig[i] = b[i];
    }

    /* Chama um procedimento para triangularizar a 
       matriz de coeficientes do sistema linear   */
    //Eliminacao(n,a,b);
    printf("Matriz triangular superior resultante:\n");
    for (int i=1; i<=n; i++){
      for (int j=1; j<=n; j++){
        if (j < i) printf("\t");
        else printf("%7.4f\t",a[i][j]);
      }
      printf("\n");
    }

    printf("Vetor de termos independentes resultante:\n");
    for (int i=1; i<=n; i++){
      printf("%g \n",b[i]);
    }
    
    /* Resolve o sistema Ax=b, onde A  uma matriz
       triangular superior                        */
    SubstituicaoRetroativa(n,a,x,b);
    printf("\nVetor solucao:\n");
    imprime_vetor("x",x,n);
    
    /* Calcula o vetor resduo R = b - Ax */
    CalculaResiduo(n, b_orig, a_orig, x, r);
    printf("\nVetor Residuo:\n");
    imprime_vetor("r",r,n);

    /* Calcula o erro cometido dado por max{r_i; 1 <= i <= n} */
    erro = CalculaErro(n,r);
    printf("\nErro = %g\n", erro);

    getchar();getchar();

    libera_vetor(b);
    libera_vetor(x);
    libera_matriz(a, n+1);
    return 0;
}
