#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <limits.h>
#include <time.h>
#include "Util.h"


/* cria memoria para um vetor float de tam posicoes */
float *cria_vetor(int tam)
{
  float *vetor;

  vetor = (float *) malloc(tam*sizeof(float));
  if (!vetor){
  	printf("Falta memoria para alocar o vetor de ponteiros");
    exit(1);
  }
  return vetor;
}



/* Cria matriz de ponteiros para float com nlinhas e ncolunas */
float **cria_matriz(int nlinhas, int ncolunas)
{
  register int i;
  float **matriz;

  matriz = (float **) malloc(nlinhas*sizeof(float *));
  if (!matriz) {
        printf("Falta memoria para alocar a matriz de ponteiros\n");
        exit(1);
  }
  for (i=0; i < nlinhas; i++) {
    matriz[i] = (float *) malloc(ncolunas*sizeof(float));
    if (!matriz[i]){
      printf("Falta memoria para alocar a matriz de ponteiros.\n");
      exit(1);
    }
  }
  return matriz;
}



/* libera memoria de um vetor float */
void libera_vetor(float *vetor)
{
  free(vetor);
}


/* libera memoria de uma matriz de float */
void libera_matriz(float **matriz, int nlinhas)
{
  register int i;

  for (i=nlinhas-1; i >= 0; i--)
    free((float *) matriz[i]);
  free((float *) matriz);
}



/* imprime um vetor de float */
void imprime_vetor(char nome[], float *s, int n)
{
    for (int j=1; j <= n; j++) printf("%s[%2d]=%g \n",nome,j,s[j]);
}


/* Gera numero aleatorio entre min e max */
float randomico(float min, float max)
{
  if (min == max) return min;
  return ((float) (rand()%10000/10000.0)*(max-min) + min);
}


/* atualiza um vetor de float */
void atualiza_vetor(float *recebe, float *doa, int n)
{
   for (int j=1; j <= n; j++) recebe[j] = doa[j];
}

/* Inicializa um vetor de float */
void inicializa_vetor(float *vetor, int tam)
{
    for (int j=0; j<=tam; j++) vetor[j] = 0;
}


/* le um arquivo com matriz "a" de m linhas e n colunas */
void le_arq_matriz(char nomearq[], int nlinhas, int ncolunas, float **a)
{
  int i, j;
  float valor;
  FILE *arquivo;

  arquivo = fopen(nomearq,"r");
  if (!arquivo) {
     printf("O Arquivo %s nao pode ser aberto.\n", nomearq);
     getchar();
     exit(1);
  }
  i = 1;
  while (i <= nlinhas){
    j = 1;
    while (j <= ncolunas){
      fscanf(arquivo, "%g", &valor);
      a[i][j] = valor;
      j++;
    };
    i++;
  }

  if (i != nlinhas+1) { // verifica a "integridade" dos dados lidos
     printf("O Arquivo %s nao corresponde as especificacoes.\n", nomearq);
     printf("O Arquivo %s possui %d registros enquanto o problema tem %d linhas.\n", nomearq, i, nlinhas);
     getchar();  exit(1);
  }
  fclose(arquivo);
}


/* le um arquivo com vetor de termos independentes b com n elementos */
void le_arq_vetor(char nomearq[], int n, float *vetor)
{
  int i;
  float valor;
  FILE *arquivo;

  arquivo = fopen(nomearq,"r");
  if (!arquivo) {
     printf("O Arquivo %s nao pode ser aberto.\n", nomearq);
     getchar();
     exit(1);
  }
  i = 1;
  while (i <= n){
    fscanf(arquivo, "%g", &valor);
    vetor[i] = valor;
    i++;
  }
  fclose(arquivo);
}


/* Limpa um arquivo */
void limpa_arquivo(char nomearq[])
{
  FILE *arquivo;
  arquivo = fopen(nomearq,"w");
  if (!arquivo){
     printf("O arquivo %s nao pode ser aberto",nomearq);
     getchar();
     exit(1);
  }
  fclose(arquivo);
}
