/* Resolve um sistema Ax=b por substituicoes progressivas */
void SubstituicaoProgressiva(int n, float **a, float *x, float *b);

/* Resolve um sistema Ax=b por substituicoes regressivas */
void SubstituicaoRetroativa(int n, float **a, float *x, float *b);

/* Calcula o residuo R dado por R = b - Ax */
void CalculaResiduo(int n, float *b, float **a, float *x, float *r);

/* Calcula o erro residual */
float CalculaErro(int n, float *r);

/* Triangulariza superiormente uma matriz */
void Eliminacao(int n, float **a, float *b);

/* Triangulariza superiormente uma matriz pelo
   mtodo de Gauss com pivotao parcial. O vetor
   de termos independentes b tambm  afetado    */
void GaussPivoteamentoParcial(int n, float **a, float *b);
