package model;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import methodsDesambiguation.INDIParameters;


public class Log {

	public Log(HashMap<Integer, Cluster> collection,String base,INDIParameters param, double pmc,double pma, double k) throws IOException {
		
		
		File logFile = new File("log_"+base);
		logFile.mkdir();
	
		Set<Integer> coll = collection.keySet();
		Iterator<Integer> ite = coll.iterator();
		
		FileWriter writeAcum = new FileWriter(logFile.getAbsolutePath() + File.separator+ base + "_Metricas.txt",true);
		PrintWriter logAcum = new PrintWriter(writeAcum);
		
		int numRepre=0;
		
		for(Cluster c: collection.values() )
			numRepre += c.getLeaders().getCitations().size();
					
		logAcum.println(param.getBaseLoad() + " " +pmc + " " + pma + "  " + k + " " + numRepre);
		logAcum.close();
		writeAcum.close();
					
		while(ite.hasNext())
		{
			File exp = new File(logFile.getAbsolutePath() + File.separator + "Experimento_"+String.valueOf(param.getBaseLoad()+1));
			if(exp.exists())
				exp.delete();
			else
				exp.mkdir();
			
			Integer key = ite.next();
			Cluster clu = new Cluster();			
			clu = collection.get(key);
			
			String fileName = exp.getAbsolutePath() + File.separator + clu.getNameRepresentative()+ "." +key.toString()+ ".txt";
			FileWriter writer = new FileWriter(fileName);
			PrintWriter log = new PrintWriter(writer);
			log.print(clu.toString());
			log.close();
			writer.close();
			
		}	
	}

}