package model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

import methodsDesambiguation.INDIParameters;
import Util.Similarity;

public class Leaders {
	private ArrayList<Citation> citations = new ArrayList<Citation>();
	private ArrayList<String> coAuthors = new ArrayList<String>();
	private ArrayList<String> authors = new ArrayList<String>();
	private ArrayList<String> title = new ArrayList<String>();
	private ArrayList<String> venue = new ArrayList<String>();
	
	public ArrayList<Citation> getCitations() {
		return citations;
	}

	public void addCoaAuthors(ArrayList<String> coAuthors) {
		if (coAuthors.isEmpty())
			return;
		
		for (String coAuthor : coAuthors) {
			if (!this.getCoAuthors().contains(coAuthor)){
				this.getCoAuthors().add(coAuthor);
			}
		}
		return;
	}
	
	public void addTitle(ArrayList<String> lTitle) {
		if (lTitle.isEmpty())
			return;
		
		for (String term : lTitle) {
			if (!this.getTitle().contains(term)){
				this.getTitle().add(term);
			}
		}
		return;
	}
	
	public void addVenue(ArrayList<String> lVenue) {
		if (lVenue.isEmpty())
			return;
		
		for (String term : lVenue) {
			if (!this.getVenue().contains(term)){
				this.getVenue().add(term);
			}
		}
		return;
	}
	

	public boolean removeCitations(Citation cit, INDIParameters param) {
		boolean remove=false;
                boolean remove1 = false;
		int index=0;
		int numCoAuthors = cit.getCoauthors().size();
		int qtde;

		for (Iterator<Citation> iter = this.getCitations().iterator(); iter
				.hasNext();) {
			Citation citation = new Citation();
			citation = iter.next();

			int numCoAuthorsCit = citation.getCoauthors().size();
			qtde = 0;

			// Testa a similaridade entre o author da citacao a ser inserida e a
			// que ja existe no grupo lider
			if (Similarity.comparacaoPorFragmento(citation.getAuthor(),	cit.getAuthor(), param.getP_lim())) {
				
				qtde = citation.getCoauthors().size();
								
				if (Similarity.compFragmentosCoautores(citation.getCoauthors(), cit.getCoauthors(), param.getP_lim(), qtde) ) {
					if (numCoAuthors > numCoAuthorsCit) {
						index = this.getCitations().indexOf(citation);
						remove = true;
                                                remove1 = true;
						break;

					}else if(cit.getVenue().size() > citation.getVenue().size()){
						index = this.getCitations().indexOf(citation);
						remove = true;
                                                remove1= false;
						break;
					}
				}

			}
		}
		if(remove){
                   
			Citation removeCit = this.getCitations().get(index);
                        if(remove1){
                        for(Citation cits:this.getCitations()){
                            System.out.println(cits);
                        }
                        System.out.println("------------------------------------------------");
                        System.out.println("remove " + removeCit);
                        System.out.println("registro inserido " + cit);
                        System.out.println("================================================");
                        }
			this.getAuthors().remove(removeCit.getAuthor());
			this.setCoAuthors(removeList(this.getCoAuthors(),removeCit.getCoauthors()));
			this.setTitle(removeList(this.getTitle(),removeCit.getTitle()));
			this.setVenue(removeList(this.getVenue(),removeCit.getVenue()));
			this.getCitations().remove(index);
			for(Citation c : this.getCitations()){
				this.addCoaAuthors(c.getCoauthors());
				this.addTitle(c.getTitle());
				this.addVenue(c.getVenue());
			}
			
		}
		return remove;
	}
	
	public ArrayList removeList(ArrayList<String> list,ArrayList<String> listToRemove){
		
		if(list.isEmpty() || listToRemove.isEmpty())
			return list;
			
		for(String termRemove : listToRemove){
			list.remove(termRemove);
		}
		
		return list;
	}
	
	public void addCitations(Citation citation) {

		this.citations.add(citation);
		// Criar metodo para inserir somente Coautores que não estejam presentes
		// na lista.
		this.authors.add(citation.getAuthor());
		this.addCoaAuthors(citation.getCoauthors());
		this.addTitle(citation.getTitle());
		this.addVenue(citation.getVenue());

	}

	public ArrayList<String> getTitle() {
		return title;
	}

	public void setTitle(ArrayList<String> title) {
		this.title = title;
	}

	public ArrayList<String> getVenue() {
		return venue;
	}

	public void setVenue(ArrayList<String> venue) {
		this.venue = venue;
	}

	public ArrayList<String> getCoAuthors() {
		return coAuthors;
	}

	public void setCoAuthors(ArrayList<String> coAuthors) {
		this.coAuthors = coAuthors;
	}

	public ArrayList<String> getAuthors() {
		return authors;
	}

	public void setAuthors(ArrayList<String> authors) {
		this.authors = authors;
	}

}
