package model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import methodsDesambiguation.INDIParameters;
import Util.Similarity;


public class Cluster {

	private String nameRepresentative="";
	private int idCluster;
	private static int numCluster = 0;
	
	private int idAutorReal;
	private Hashtable<String, Integer> nameVariation = new Hashtable<String, Integer>();
	private ArrayList<String> coauthors = new ArrayList<String>();
	private ArrayList<Citation> citations = new ArrayList<Citation>();
	private ArrayList<String> titles = new ArrayList<String>();
	private Leaders leaders = new Leaders();
	private double numVar;
	private static int maxCit;
	
	
	public int getIdAutorReal() {
		return idAutorReal;
	}

	public void setIdAutorReal(int idAutorReal) {
		this.idAutorReal = idAutorReal;
	}
	
	public Cluster() {
		super();
		numCluster++;
		this.idCluster = numCluster ;
	}
		
	public int getIdCluster() {
		return idCluster;
	}

	public void setIdCluster(int idCluster) {
		this.idCluster = idCluster;
	}

	public double getNumVar() {
		return numVar;
	}

	
	public void setNumVar(double numVar) {
		this.numVar = numVar;
	}

	public ArrayList<String> getTitles() {
		return titles;
	}

	public void setTitles(ArrayList<String> titles) {
		this.titles.addAll(titles);
	}

	public ArrayList<String> getCoauthors() {
		return coauthors;
	}
	
	public static int getMaxCit() {
		return maxCit;
	}

	public void setCoauthors(ArrayList<String> coauthors) {
		
		if(coauthors == null)
			return;
		
		Iterator<String> it = coauthors.iterator();

		while (it.hasNext()) {
			String coau = it.next();
			if (!this.coauthors.contains(coau)) {
				this.coauthors.add(coau);
			}
		}
		
	}

	public String getNameRepresentative() {
		return nameRepresentative;
	}

	public void setNameRepresentative(String name) {
		if(name.length() > this.nameRepresentative.length()){
			this.nameRepresentative = name;
		}
		/*else if(name.length() == this.nameRepresentative.length() ){
			if(this.nameVariation.containsKey(name)){
				if( this.nameVariation.get(name) > this.nameVariation.get(this.nameRepresentative) )
					this.nameRepresentative = name;
			}
		}*/
	}

	public Hashtable<String, Integer> getNameVariation() {
		return nameVariation;
	}

	public void setNameVariation(String nameVariation) {
		int numVar;
		
		if(this.nameVariation.containsKey(nameVariation)){
			numVar = this.nameVariation.get(nameVariation);
			numVar++;
			this.nameVariation.remove(nameVariation);
			this.nameVariation.put(nameVariation, numVar);
		}
		else{
			numVar = 1;
			this.nameVariation.put(nameVariation, numVar);
		}
	}

	public ArrayList<Citation> getCitations() {
		return citations;
	}

	public void setCitations(Citation citations) {
		this.citations.add(citations);
	}

	public void setLeaders(Leaders leaders) {
		this.leaders = leaders;
	}
	
	public Leaders getLeaders(){
		return this.leaders;
	}
	
	public void addCitation(Citation cit,INDIParameters param){
		this.setCitations(cit);
		this.setCoauthors(cit.getCoauthors());
		this.setTitles(cit.getTitle());
		this.setNameVariation(cit.getAuthor());
		this.setNameRepresentative(cit.getAuthor());
		
		if( (this.citations.size() % 2 ) == 0)
			this.maxCit = (int) (this.citations.size() * 0.5);
		else
			this.maxCit = (int) (this.citations.size() * 0.5) + 1;
				
		if(chooseLeaders(cit, this,param)){
			this.getLeaders().addCitations(cit);
		}
	}	
	
	

	public void iniCluster(INDIParameters param){
		for(Iterator<Citation> iter = this.getCitations().iterator();iter.hasNext();){
			
			Citation cit = iter.next();
			if(chooseLeaders(cit, this, param)){		
				this.getLeaders().addCitations(cit);
			}
		}
	}	
		
	//Metodo chooseLeaders baseado em metricas de similaridade;
	
	public boolean chooseLeaders(Citation cit, Cluster clu,INDIParameters param){
		boolean choose = false;
		boolean heuristcCoAuthor = false;
		boolean heuristcTitleAndVenue = false; 
		int comumCoAuthor;		
		
		Leaders leaders = new Leaders();
		leaders = clu.getLeaders();
		
		//Caso a citacao seja a primeiro a ser inserida no cluster
		//Ela necessariamente deve ser definida como lider
		if( leaders.getCitations().size() == 0 )
			return true;
		
		
		heuristcCoAuthor = Similarity.listCompareCossineSim(cit.getCoauthors(), leaders.getCoAuthors(), 0.8 ,1);
		heuristcTitleAndVenue = !Similarity.heuristicTitleAndVenueLeaders(leaders, cit, param.getcSimTitle() + param.getIncremento(), param.getcSimVenue() + param.getIncremento() );
	
				
		if(heuristcCoAuthor || heuristcTitleAndVenue)
		{		
			if(this.getLeaders().getCitations().size()  < this.maxCit)
                        {
                          return true;
                        }
			else{
				return this.getLeaders().removeCitations(cit, param);
				
			}
				
		}
			
		return choose;
	}
	


	@Override
	public String toString(){
				
		String cluster;
		cluster = "====================================================================================\n";
		cluster +="Id do Grupo: " + this.idCluster + " Nome representativo: " + this.nameRepresentative + "\n";
		cluster += "------------------------------------------------------------------------------------\n";
		cluster += "Número de Registros =  "+ this.citations.size() + "\n";
		cluster += "------------------------------------------------------------------------------------\n";
		Iterator<Citation> iter = this.citations.iterator();
		
		while(iter.hasNext()){
			cluster += iter.next() + "\n";
		}
		
		cluster += "------------------------------------------------------------------------------------\n";
		cluster += "Número de Registros Representativos =  "+ this.leaders.getCitations().size()  +"\n";
		cluster += "------------------------------------------------------------------------------------\n";
		Iterator<Citation> iterLeader = this.leaders.getCitations().iterator();
		
		while(iterLeader.hasNext()){
			cluster+= iterLeader.next() + "\n";
		}
		cluster += "====================================================================================\n";
		return cluster;
	}


	
}