package model;

import java.util.ArrayList;

public class Citation {
	
	private int id;
	private int idCluster;
	private int idAuthor;
	private String author;
	private ArrayList<String> coauthors = new ArrayList<String>();
	private ArrayList<String> title = new ArrayList<String>();
	private ArrayList<String> venue = new ArrayList<String>();
	private int year;
	
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public int getIdAuthor() {
		return idAuthor;
	}
	public void setIdAuthor(int idAuthor) {
		this.idAuthor = idAuthor;
	}
	public int getIdCluster() {
		return idCluster;
	}
	public void setIdCluster(int idCluster) {
		this.idCluster = idCluster;
	}
	public String getAuthor() {
		return author;
	}
	public void setAuthor(String author) {
		this.author = author;
	}
	public ArrayList<String> getCoauthors() {
		return coauthors;
	}
	public void setCoauthors(ArrayList<String> coauthors) {
		if(coauthors == null)
			this.coauthors = null;
		else
			this.coauthors = coauthors;
	}
	public ArrayList<String> getTitle() {
		ArrayList<String> cleanTitle = title;
		cleanTitle.remove("algorithm");
		cleanTitle.remove("model");
		cleanTitle.remove("network");
		cleanTitle.remove("imag");
		cleanTitle.remove("comput");
		cleanTitle.remove("detect");
		
		return cleanTitle;
	}
	public void setTitle(ArrayList<String> title) {
		this.title = title;
	}
	public ArrayList<String> getVenue() {
		ArrayList<String> cleanVenue = venue;
		cleanVenue.remove("comput");
		cleanVenue.remove("intern");
		cleanVenue.remove("ieee");
		cleanVenue.remove("system");
		cleanVenue.remove("proceed");
		cleanVenue.remove("symposium");
		cleanVenue.remove("journal");
		cleanVenue.remove("design");
		cleanVenue.remove("autom");
		cleanVenue.remove("aid");		
		return cleanVenue;
	}
	public void setVenue(ArrayList<String> venue) {
		this.venue = venue;
	}
	public int getYear() {
		return year;
	}
	public void setYear(int year) {
		this.year = year;
	}
	
	@Override
	public String toString()
	{
		return this.id + "<>" +  this.idCluster + "<>" + this.idAuthor + "<>"  + this.author + "<>" + this.coauthors + "<>" + this.title + "<>" + this.venue + "<>" + this.year;
		
	}

}
