package methodsDesambiguation;

import io.ReaderAllBase;
import io.ReaderPerYear;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import model.Citation;
import model.Cluster;
import model.Leaders;
import model.Log;
import Util.Similarity;

public class INDILeaders{
	
	public HashMap<Integer,Cluster> collection = new HashMap<Integer,Cluster>();
	

	public INDILeaders (ArrayList<String> nameFiles,File path,INDIParameters param){
		
		ArrayList<Citation> citations = new ArrayList<Citation>();
		ReaderPerYear readerPerYear = new ReaderPerYear();
		try {
                        
                        
                        citations = readerPerYear.reader(nameFiles, path.getAbsolutePath() + File.separator);
                        ArrayList<Cluster> clusInBase = new ArrayList<Cluster>();
			clusInBase = EvaluationMetrics.createClusterReference(citations);
			
			for(Iterator<Cluster> iter = clusInBase.iterator(); iter.hasNext();){
				Cluster clu = new Cluster();
				clu = iter.next();
				clu.iniCluster(param);
				collection.put(clu.getIdCluster(), clu);
			}
			
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	// Esse metodo e uma adaptação de um metodo do artigo INDI
	// Lembrar de citar
	
	public void findCluster(ArrayList<Citation> citations, INDIParameters param) throws IOException {
		boolean find = false;
		boolean heuristicCoAuthors, heuristicTitle;
		double p_lim = param.getP_lim();
		int idCluster = 90000;
		int qtde = param.getQtde();
		double simTitle = param.getSimTitle();
		double simVenue = param.getSimVenue();
		double incremento = param.getIncremento();

		Cluster cluSim;
		int cluN = 0;
		int cluE = 0;
		
		for (Citation cit : citations) {
			find = false;
			//System.out.println(cit);
			for (Iterator<Cluster> it = collection.values().iterator(); it.hasNext()
					&& find == false;) {
				cluSim = it.next();

				Leaders leaders = new Leaders();
				leaders = cluSim.getLeaders();

				// verificando similaridade do nome do cluster e do nome do
				// autor da citacao
				if (Similarity.comparacaoPorFragmento(
						cluSim.getNameRepresentative(), cit.getAuthor(),
						p_lim)) {
					heuristicCoAuthors = false;
					heuristicTitle = false;

					// verifica se os coautores do novoArtigo sao similares aos
					// coautores do grupo de lideres(No INDI seria os coautores
					// do cluster);
					heuristicCoAuthors = cit.getCoauthors().size() == 0 || leaders.getCoAuthors().size() == 0 ? false : Similarity.compFragmentosCoautores(
							cit.getCoauthors(), leaders.getCoAuthors(),	p_lim, qtde);
					
					if (heuristicCoAuthors) {
						// Verifica se o titulos ou veiculos de publicacao grupo
						// de lideres
						// sao similares ao da nova citacao;
						heuristicTitle = Similarity.heuristicTitleAndVenue(
								leaders, cit, simTitle, simVenue);
					}
					// Realiza um tratamento para os casos que o nova citação ou
					// o cluster nao possuierem coautores;
					else if ( cit.getCoauthors().isEmpty() ||  leaders.getCoAuthors().isEmpty() ) {
						heuristicCoAuthors = true;
						heuristicTitle = Similarity.heuristicTitleAndVenue(leaders, cit, simTitle+incremento, simVenue+incremento);
					}
					// O autor analisado ja existe na base;
					if (heuristicCoAuthors && heuristicTitle) {
						find = true;
						Cluster c = collection.get(cluSim.getIdCluster());
						
						
						
						c.addCitation(cit,param);
						
						
						
						cluE++;
						
					}

				}
			}
			//O autor a ser inserido não possui nenhuma citacao
			//cadastrada na colecao
			if(find == false){
				Cluster cluTemp = new Cluster();
				cluTemp.addCitation(cit,param);
				collection.put(cluTemp.getIdCluster(),cluTemp);
				cluN++;
			}
		}
			
		
		return;
	}

	
	
	public String runDesambiguation(ArrayList<String> nameFiles,File path, INDIParameters param) {
		// TODO Auto-generated method stub
		
		ArrayList<Citation> neoCitations = new ArrayList<Citation>();
		ReaderPerYear readerPerYear = new ReaderPerYear();
		
		String result = "";
		
		

		try {
			
			neoCitations = readerPerYear.reader(nameFiles, path.getAbsolutePath() + File.separator);
			findCluster(neoCitations,param);
			ArrayList<Citation> cits = new ArrayList<Citation>();
			ReaderAllBase reader = new ReaderAllBase();
			cits = reader.reader(path);
			
		
			ArrayList<Cluster> clusGenerated = EvaluationMetrics.createClusterGenerated(collection);
			ArrayList<Cluster> clusReference = EvaluationMetrics.createClusterReference(cits);
			
			double pmc = EvaluationMetrics.PMC(clusReference, clusGenerated, cits.size());
			double pma = EvaluationMetrics.PMA(clusReference, clusGenerated, cits.size());
			double k = EvaluationMetrics.metricK(clusReference, clusGenerated,
					cits.size());
			result = param.getBaseLoad() + "\t" + pmc + "\t" + pma + "\t" + k + "\n";
                        String base = path.getAbsolutePath().replace(path.getParent() + File.separator, "");
			Log log = new Log(collection,base , param, pmc, pma, k);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return result;
	}
	
}
