package methodsDesambiguation;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

import model.Citation;
import model.Cluster;


public class EvaluationMetrics {
	
	public static ArrayList<Cluster> createClusterReference (ArrayList<Citation> cits){
		
		ArrayList<Cluster> clusRef =  new ArrayList<Cluster>();
		Hashtable<Integer,Cluster> clusInRef = new Hashtable<Integer,Cluster>();
		
		Iterator<Citation> iterCits = cits.iterator();
		
		while(iterCits.hasNext()){
			Citation cit = iterCits.next();
			
			//Teste se o cluster a qual a citacao pertece ja foi criado.
			if(clusInRef.containsKey(cit.getIdCluster())){
				int idClu = cit.getIdCluster();
				Cluster clu = new Cluster();
				clu = clusInRef.get(idClu);
				clu.setCitations(cit);
				clu.setTitles(cit.getTitle());
				clu.setCoauthors(cit.getCoauthors());		
			}else{
				Cluster clu = new Cluster();
				clu.setIdAutorReal(cit.getIdCluster());
				clu.setCoauthors(cit.getCoauthors());
				clu.setNameRepresentative(cit.getAuthor());
				clu.setTitles(cit.getTitle());
				clu.setCitations(cit);
				
				clusInRef.put(clu.getIdAutorReal(), clu);	
			}
		}
		
		Enumeration<Cluster> e = clusInRef.elements();
		while(e.hasMoreElements()){
			clusRef.add(e.nextElement());
		}
		return clusRef;
	}

	public static ArrayList<Cluster> createClusterGenerated (HashMap<Integer,Cluster> collection){
		ArrayList<Cluster> cluGen = new ArrayList<Cluster>();
		
		for(Iterator<Cluster> iter = collection.values().iterator(); iter.hasNext();)
			cluGen.add(iter.next());
	
		return cluGen;
	}
	
	public static double PMC(ArrayList<Cluster> clusReference,
			ArrayList<Cluster> clusGenerated, int N) {

		double pmc = 0.0;

		// Numero de clusteres referencia(manualmente gerados)
		int r = clusReference.size();
		// Numero de clusteres gerados pelo metodo
		int q = clusGenerated.size();
		// Numero de citacoes do cluster i(gerado pelo metodo) que pertencem ao
		// cluster j(gerado manualmente);
		int n_ij = 0;
		// Numero total de citacoes que pertencem ao cluster i(geradas pelo
		// metodo)
		int n_i;

		Cluster clusterRef;
		Cluster clusterGen;

		Citation cit;

		for (int i = 0; i < q; ++i) {
			clusterGen = new Cluster();
			clusterGen = clusGenerated.get(i);
			n_i = clusterGen.getCitations().size();
			if (n_i != 0) {
				for (int j = 0; j < r; ++j) {
					n_ij = 0;
					clusterRef = new Cluster();
					clusterRef = clusReference.get(j);

					for (int indexGen = 0; indexGen < clusterGen.getCitations()
							.size(); ++indexGen) {
						int idCitGen = clusterGen.getCitations().get(indexGen)
								.getId();
						for (int indexRef = 0; indexRef < clusterRef
								.getCitations().size(); ++indexRef) {
							if (idCitGen == clusterRef.getCitations()
									.get(indexRef).getId())
								n_ij++;
						}
					}
					double parc = (Math.pow(n_ij, 2.0) / n_i);
					pmc += parc; 
				}

			}
		}

		pmc = (pmc / N);

		return pmc;
	}

	public static double PMA(ArrayList<Cluster> clusReference,
			ArrayList<Cluster> clusGenerated, int N) {
		double pma = 0.00;

		// numero de clusters gerados manualmente
		int r = clusReference.size();
		// numero de clusters gerados pelo metodo
		int q = clusGenerated.size();
		// numero de citacoes do cluster i(gerado pelo metodo) que pertencem ao
		// cluster j(gerado manualmente)
		int n_ij = 0;
		// numero de citacoes do cluster j gerado manualmente
		int n_j;

		Cluster clusterGen;
		Cluster clusterRef;

		for (int j = 0; j < r; ++j) {
			clusterRef = new Cluster();
			clusterRef = clusReference.get(j);
			n_j = clusterRef.getCitations().size();

			for (int i = 0; i < q; ++i) {
				n_ij = 0;
				clusterGen = new Cluster();
				clusterGen = clusGenerated.get(i);

				for (int indexRef = 0; indexRef < clusterRef.getCitations()
						.size(); ++indexRef) {
					int idCitRef = clusterRef.getCitations().get(indexRef)
							.getId();

					for (int indexGen = 0; indexGen < clusterGen.getCitations()
							.size(); ++indexGen) {
						if (idCitRef == clusterGen.getCitations().get(indexGen)
								.getId())
							n_ij++;
					}

				}
				if (n_j != 0){
					double parc = (Math.pow(n_ij, 2.0) / n_j);
					pma += parc;
				}
					
			}
		}

		pma = pma / N;

		return pma;
	}

	public static double k(double pmc, double pma){
		double k = pmc * pma;
				
		k = Math.sqrt(k);
	
		return k;		
	}
	
	public static double metricK(ArrayList<Cluster> clusReference, ArrayList<Cluster> clusGenerated, int N){
		double k,pmc,pma;
		
		pmc = PMC(clusReference,clusGenerated,N);
		pma = PMA(clusReference,clusGenerated,N);
		k = k(pmc,pma);
		
		return k;
		
		
	}

	
}
