
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import methodsDesambiguation.INDILeaders;
import methodsDesambiguation.INDIParameters;

/*
 * To change this template, choose Tools | Templates and open the template in
 * the editor.
 */
/**
 *
 * @author herculano
 */
public class main extends javax.swing.JFrame {

    /**
     * Creates new form main
     */
    boolean choosePath = false;

    public main() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jBPrincipal = new javax.swing.JButton();
        jTBasePath = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jTSimVenue = new javax.swing.JTextField();
        jTSimTitle = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        jTSimVenueGR = new javax.swing.JTextField();
        jTSimTitleGR = new javax.swing.JTextField();
        jTCoAuthor = new javax.swing.JTextField();
        jTIncrement = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jSeparator2 = new javax.swing.JSeparator();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        jBPrincipal.setText("Selecionar Coleção");
        jBPrincipal.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBPrincipalActionPerformed(evt);
            }
        });

        jTBasePath.setEditable(false);

        jLabel5.setText("Similaridade Título - GR:");

        jLabel6.setText("Similaridade Veículo - GR:");

        jLabel4.setText("Co-autores:");

        jTSimVenue.setToolTipText("Somente ponto flutuante");

        jTSimTitle.setToolTipText("Somente ponto flutuante");

        jLabel3.setText("Valor Incremental:");

        jTSimVenueGR.setToolTipText("Somente ponto flutuante");

        jTSimTitleGR.setToolTipText("Somente ponto flutuante");

        jTCoAuthor.setToolTipText("Somente inteiros");

        jTIncrement.setToolTipText("Somente ponto flutuante");

        jLabel2.setText("Similaridade Veículo:");

        jLabel1.setText("Similaridade Título:");

        jLabel7.setText("Escolha do Registro Representativo");

        jLabel8.setText("Método de desambiguação");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(27, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTBasePath, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 234, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jBPrincipal, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jLabel6)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTSimVenueGR, javax.swing.GroupLayout.PREFERRED_SIZE, 46, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLabel1)
                            .addComponent(jLabel2)
                            .addComponent(jLabel3)
                            .addComponent(jLabel4)
                            .addComponent(jLabel5))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(jTSimTitleGR)
                            .addComponent(jTCoAuthor, javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTIncrement, javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTSimVenue, javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTSimTitle, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 46, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addComponent(jSeparator2, javax.swing.GroupLayout.PREFERRED_SIZE, 266, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(jLabel7)
                        .addComponent(jLabel8)))
                .addGap(35, 35, 35))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(58, 58, 58)
                .addComponent(jLabel8)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTSimTitle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTSimVenue, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTIncrement, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel3))
                .addGap(50, 50, 50)
                .addComponent(jSeparator2, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jLabel7)
                .addGap(25, 25, 25)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTCoAuthor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel4))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTSimTitleGR, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel5))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTSimVenueGR, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel6))
                .addGap(18, 18, 18)
                .addComponent(jTBasePath, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(33, 33, 33)
                .addComponent(jBPrincipal)
                .addContainerGap(64, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jBPrincipalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBPrincipalActionPerformed
        // TODO add your handling code here:

        if (!choosePath) {

            JFileChooser jFilePath = new JFileChooser();
            jFilePath.setApproveButtonText("Selecionar");
            jFilePath.setCurrentDirectory(new java.io.File("."));
            jFilePath.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            int value = jFilePath.showOpenDialog(this);
            if (value == JFileChooser.APPROVE_OPTION) {
                jTBasePath.setText(jFilePath.getSelectedFile().getAbsolutePath());
                jBPrincipal.setText("Desambiguar Coleção");
                choosePath = true;
            }
        } else {
            if(verifica()){
                try {
                    rian();
                } catch (IOException ex) {
                    Logger.getLogger(main.class.getName()).log(Level.SEVERE, null, ex);
                }
                limpa();
            }else{
                JOptionPane.showMessageDialog(jBPrincipal, "Verifique se todos os campos estão preenchidos corretamente");
                
            }
        }



    }//GEN-LAST:event_jBPrincipalActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /*
         * Set the Nimbus look and feel
         */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /*
         * If Nimbus (introduced in Java SE 6) is not available, stay with the
         * default look and feel. For details see
         * http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(main.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(main.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(main.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(main.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /*
         * Create and display the form
         */
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new main().setVisible(true);
            }
        });
    }
    
    public void limpa(){
        jTSimTitle.setText("");
        jTSimVenue.setText("");
        jTCoAuthor.setText("");
        jTSimTitleGR.setText("");
        jTSimVenueGR.setText("");
        jTBasePath.setText("");
        jTIncrement.setText("");
        jBPrincipal.setText("Selecionar Coleção");
        choosePath = false;
    }
    
    
    public boolean verifica(){
        boolean ver = false;
        
        if(jTBasePath.getText().isEmpty())
            return ver;
        else if(jTSimTitle.getText().isEmpty())
            return ver;
        else if(jTSimVenue.getText().isEmpty())
            return ver;
        else if(jTSimTitleGR.getText().isEmpty())
            return ver;
        else if(jTSimVenueGR.getText().isEmpty())
            return ver;
        else if(jTCoAuthor.getText().isEmpty())
            return ver;
               
        return true;
    }

    public void rian() throws IOException {
        String path = jTBasePath.getText() + File.separator;
        File filePath = new File(path);
        String[] lista = filePath.list();
        List<String> listFiles = new ArrayList<String>(Arrays.asList(lista));
        Collections.sort(listFiles);
        
        String result;
        
        for (int baseLoad = 0; baseLoad < listFiles.size() - 1; baseLoad++) {
            result = "";
            
            double limComp = 0.3;
            int coAuthor = Integer.parseInt(jTCoAuthor.getText());
            double simTitle = Double.parseDouble(jTSimTitle.getText());
            double simVenue = Double.parseDouble(jTSimVenue.getText());
            double inc = Double.parseDouble(jTIncrement.getText());
            double simTitleGR = Double.parseDouble(jTSimTitleGR.getText());
            double simVenueGR = Double.parseDouble(jTSimVenueGR.getText());
            
            INDIParameters param = new INDIParameters(simVenue, simTitle, limComp, coAuthor, inc, coAuthor, simVenueGR, simTitleGR, baseLoad);

            int totalBase = listFiles.size();

            ArrayList<String> files = new ArrayList<String>();
            ArrayList<String> filesNeo = new ArrayList<String>();

            for (int j = 0; j < totalBase; j++) {
                if (j < param.getBaseLoad()) {
                    files.add(listFiles.get(j));
                } else {
                    filesNeo.add(listFiles.get(j));

                }

            }
            
                                
            INDILeaders method = new INDILeaders(files, filePath, param);
            
            result = method.runDesambiguation(filesNeo, filePath, param);
            
           
        }


    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBPrincipal;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JTextField jTBasePath;
    private javax.swing.JTextField jTCoAuthor;
    private javax.swing.JTextField jTIncrement;
    private javax.swing.JTextField jTSimTitle;
    private javax.swing.JTextField jTSimTitleGR;
    private javax.swing.JTextField jTSimVenue;
    private javax.swing.JTextField jTSimVenueGR;
    // End of variables declaration//GEN-END:variables
}
