package io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

import model.Citation;
import model.Stemmer;
import model.StopWords;


public class ReaderAllBase {
	
	public ArrayList<Citation> reader(File path) throws IOException{
		ArrayList<Citation> citations = new ArrayList<Citation>();
		
		File[] files = path.listFiles();
		
		for(int i = 0; i < files.length;i++){
			
			try{
				FileReader reader = new FileReader(files[i]);
				BufferedReader bufReader = new BufferedReader(reader);
				String line;
				StopWords stpWords = new StopWords();
				ArrayList<String> listStpWords = new ArrayList<String>();
				listStpWords = stpWords.listStpWords();
				
				
				while((line = bufReader.readLine()) != null){
					
					StringTokenizer token = new StringTokenizer(line,"<>");
					Citation cit = new Citation();
					String author, aux;
					StringReader sTitle,sVenue;
					int year, id,idCluster, idAuthor;
					
					ArrayList<String> coauthors = new ArrayList<String>();
					ArrayList<String> title = new ArrayList<String>();
					ArrayList<String> venue = new ArrayList<String>();

					// Le id da citacao.
					id = Integer.parseInt(token.nextToken());
					cit.setId(id);

					// Le o id do author e da variacao do author.
					aux = token.nextToken();
					StringTokenizer id_Author = new StringTokenizer(aux, "_");

					idCluster = Integer.parseInt(id_Author.nextToken());
					cit.setIdCluster(idCluster);

					idAuthor = Integer.parseInt(id_Author.nextToken());
					cit.setIdAuthor(idAuthor);

					// Lista de coautores.
					aux = token.nextToken();
					

					if (!aux.equals("nulo") || !aux.equals("")) {
						StringTokenizer coau = new StringTokenizer(aux, ":");
						while (coau.hasMoreTokens())
							coauthors.add(coau.nextToken());
						cit.setCoauthors(coauthors);
					}

					// Le o titulo da publicação.
					aux = token.nextToken();
					aux = stpWords.removeStpWords(aux, listStpWords);
					Stemmer stem = new Stemmer();
					sTitle = new StringReader(aux);
					title = stem.runStem(sTitle);
					cit.setTitle(title);
					

					// Le o veiculo de publicação
					aux = token.nextToken();
					aux = stpWords.removeStpWords(aux,listStpWords);
					sVenue = new StringReader(aux);
					venue = stem.runStem(sVenue);
					cit.setVenue(venue);
					

					// Le o author
					author = token.nextToken();
					cit.setAuthor(author);
					
					// Le o Ano
					aux = files[i].getName();
					aux = aux.replace("Base_", "");
					aux = aux.replace(".txt", "");
					year = Integer.parseInt(aux);
					cit.setYear(year);

					
					citations.add(cit);
					
					
				}
				
			}catch(FileNotFoundException e){
				System.err.println(files[i] + " não encontrado.");
			}
			
		}
	
		return citations;
	}

}
