package Util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import model.Citation;
import model.Leaders;
import uk.ac.shef.wit.simmetrics.similaritymetrics.CosineSimilarity;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Levenshtein;

public class Similarity {
	
	//Comparacao por fragmentos dos coAutores de cit com os coAutores do grupo de lideres 
	public static boolean compFragmentosCoautores(ArrayList<String> coauthor1,ArrayList<String> coauthor2,double lim,int qtde)
	{
		int comum=0;
				
		if ((coauthor1.isEmpty()) || (coauthor2.isEmpty()))
			return false;

		for (String name1 : coauthor1) {
			boolean found = false;
			for(String name2 : coauthor2){
				if(name1 != null && name2 != null){
					if(comparacaoPorFragmento(name1,name2,lim) && !found)
					{
						comum++;
						found=true;
					}	
				}
			}	
		}
		if(comum >= qtde)
			return true;
		
		else return false;
	}

	// Comparacao por fragmentos utilizando distancia de levenshtein.
	public static boolean comparacaoPorFragmento(String nome1, String nome2,
			double p_lim) {

		// System.out.println(nome1+"\t"+nome2);
		String[] p_nome1 = nome1.split("[ ]");
		String[] p_nome2 = nome2.split("[ ]");

		// for (int i=0; i<p_nome1.length; i++)
		// System.out.print(p_nome1[i]+" ");
		// System.out.println();
		// for (int i=0; i<p_nome2.length; i++)
		// System.out.print(p_nome2[i]+" ");
		// System.out.println();
		// System.out.println();

		boolean[] v_marcado_nome1 = new boolean[p_nome1.length];
		boolean[] v_marcado_nome2 = new boolean[p_nome2.length];

		int i, j;
				
		double v_limInterno = p_lim;
		if (p_lim > 0 && p_lim < 1) {
			// v_limInterno = Math.floor(Util.min(p_nome1.length, p_nome2.length
			// ) * p_lim);

		}

		if (p_nome1[0].length() > 1 && p_nome2[0].length() > 1) {
			if (LD(p_nome1[0], p_nome2[0]) > v_limInterno) {
				return false;
			}
		} else {
			if (p_nome1[0].length() > 1) {
				if (!p_nome2[0]
						.equalsIgnoreCase(firstLetter(p_nome1[0]))) {
					return false;
				}
			} else {
				if (!p_nome1[0]
						.equalsIgnoreCase(firstLetter(p_nome2[0]))) {
					return false;
				}
			}
		}

		if (p_nome1[p_nome1.length - 1].length() > 1
				&& p_nome2[p_nome2.length - 1].length() > 1) {
			if (LD(p_nome1[p_nome1.length - 1], p_nome2[p_nome2.length - 1]) > v_limInterno) {
				return false;
			}
		} else {
			return false;
		}

		for (i = 1; i < p_nome1.length - 1; i++) {
			for (j = 1; j < p_nome2.length - 1; j++) {
				if (p_nome1[i].length() > 1 && p_nome2[j].length() > 1
						&& LD(p_nome1[i], p_nome2[j]) < v_limInterno) {
					v_marcado_nome1[i] = true;
					v_marcado_nome2[j] = true;
				}
			}
		}

		for (i = 1; i < p_nome1.length - 1; i++) {
			for (j = 1; j < p_nome2.length - 1; j++) {
				if ((!v_marcado_nome1[i])
						&& p_nome1[i].length() > 1
						&& p_nome2[j].length() == 1
						&& firstLetter(p_nome1[i]).equalsIgnoreCase(
								p_nome2[j])) {
					v_marcado_nome1[i] = true;
					v_marcado_nome2[j] = true;
				}
			}
		}

		for (i = 1; i < p_nome1.length - 1; i++) {
			for (j = 1; j < p_nome2.length - 1; j++) {
				if (p_nome1[i].length() == 1
						&& (!v_marcado_nome2[j])
						&& p_nome2[j].length() > 1
						&& firstLetter(p_nome2[j]).equalsIgnoreCase(
								p_nome1[i])) {
					v_marcado_nome1[i] = true;
					v_marcado_nome2[j] = true;
				}
			}
		}

		for (i = 1; i < p_nome1.length - 1; i++) {
			for (j = 1; j < p_nome2.length - 1; j++) {
				if ((!v_marcado_nome1[i]) && (!v_marcado_nome2[j])
						&& p_nome1[i].length() == 1 && p_nome2[j].length() == 1
						&& p_nome2[j].equalsIgnoreCase(p_nome1[i])) {
					v_marcado_nome1[i] = true;
					v_marcado_nome2[j] = true;
				}
			}
		}

		for (i = 1; i < p_nome1.length - 1; i++) {
			if (!v_marcado_nome1[i]) {
				for (j = 1; j < p_nome2.length - 1; j++) {
					if (!v_marcado_nome2[j]) {
						return false;
					}
				}
			}
		}
		return true;
	}

	
	static String firstLetter(String frag1) {

		if (frag1 != null && !frag1.equals("")) {
			return frag1.substring(0, 1);
		} else
			return "";
	}
	
	//Verifica qts coAutores da citacao sao coAutores do grupo de liders ou do cluster(Casamento exato)
	public static int listCompareExact(ArrayList<String> a1, ArrayList<String> a2) {
		int result = 0;

		if ((a1 == null) || (a2 == null))
			return result;

		String auxName;
		Iterator<String> it = a1.iterator();

		while (it.hasNext()) {
			auxName = it.next();
			if (a2.contains(auxName))
				result = +1;
		}
		
		return result;

	}
	
	//Verifica qts coAutores da citacao nao pertencem ao grupo representativo;
	public static boolean listCompareCossineSim(ArrayList<String> a1, ArrayList<String> a2,double sim, int qtde) {
		boolean result = false;
		int comum = 0;

		if ((a1.isEmpty()) || (a2.isEmpty()))
			return result;

		for (String str1: a1) {
			for (String str2:a2) {
				double parcResult;
				CosineSimilarity metric = new CosineSimilarity();
				parcResult = metric.getSimilarity(str1,str2);
				if (parcResult >= sim) {
					comum = +1;
					break;
				}
			}
		}
		
		if( (a1.size() - comum) >= qtde )
			return true;
		
		return result;

	}
	
	
	public static boolean heuristicTitleAndVenueLeaders(Leaders leaders,Citation cit, double simTitle, double simVenue){
		CosineSimilarity metric = new CosineSimilarity();
		
		if( (cosineDistance(ListToArray(leaders.getTitle()), ListToArray(cit.getTitle())) > simTitle ) || 
				(cosineDistance(ListToArray(leaders.getVenue()),ListToArray(cit.getVenue())) > simVenue) )
			return true;
		
		return false;
		
	}
	
	public static boolean heuristicTitleAndVenue(Leaders leaders, Citation cit, double simTitle, double simVenue){
		
		
		if( (cosineDistance(ListToArray(leaders.getTitle()), ListToArray(cit.getTitle())) > simTitle ) || 
				(cosineDistance(ListToArray(leaders.getVenue()),ListToArray(cit.getVenue())) > simVenue) )
			return true;
				
		
		return false;
	}

	//Verifica se as palavras similares a da lista estao posicionadas no rank de acordo com o limite(limit);
    //Se limit igual a 0 a palavra so precisa estar no rank;
	public static int wordsRankCossineSimLimite(ArrayList<String> list,TreeMap<String,List<Integer>> rank,int limit,double sim){
		int result =0;
		
		if(list.isEmpty() || rank.isEmpty())
			return result;
		
		for(String term:list){
			Iterator iter = rank.entrySet().iterator();
			
			while(iter.hasNext()){
				double isSimilarity;
				Map.Entry entry = (Map.Entry) iter.next();
				String term2 = (String) entry.getKey();
				
				CosineSimilarity metric = new CosineSimilarity();
				isSimilarity = metric.getSimilarity(term, term2);
				
				if(isSimilarity >= sim)
				{
					result++;
					break;
				}
					
			}
		}		
		return result;
	}
	
	public static double cosineDistance(String first[], String second[]) {
		double normFirst = 0.0D;
		double normSecond = 0.0D;
		Hashtable hashFirst = new Hashtable();
		Hashtable hashSecond = new Hashtable();

		for (int i = 0; i < first.length; i++) {
			Integer value = (Integer) hashFirst.put(first[i], new Integer(1));

			if (value != null) {
				int val = value.intValue();
				hashFirst.remove(first[i]);
				value = (Integer) hashFirst.put(first[i], new Integer(val + 1));
				normFirst -= Math.pow(val, 2D);
				normFirst += Math.pow(val + 1, 2D);
			} else {
				normFirst++;
			}

		}

		double internalProduct = 0.0D;
		for (int i = 0; i < second.length; i++) {
			Integer value = (Integer) hashSecond.put(second[i], new Integer(1));
			if (value != null) {
				int val = value.intValue();
				hashSecond.remove(second[i]);
				value = (Integer) hashSecond.put(second[i],
						new Integer(val + 1));
				normSecond -= Math.pow(val, 2D);
				normSecond += Math.pow(val + 1, 2D);
			} else {
				normSecond++;
			}

			Integer valueFirst = (Integer) hashFirst.get(second[i]);
			if (valueFirst != null)
				internalProduct += valueFirst.intValue();
		}

		return internalProduct / Math.sqrt(normFirst * normSecond);
	}
	
	static private int Minimum(int a, int b, int c) {
		int mi;

		mi = a;
		if (b < mi) {
			mi = b;
		}
		if (c < mi) {
			mi = c;
		}
		return mi;

	}
	
	static public int LD(String s, String t) {
		int d[][]; // matrix
		int n; // length of s
		int m; // length of t
		int i; // iterates through s
		int j; // iterates through t
		char s_i; // ith character of s
		char t_j; // jth character of t
		int cost; // cost

		// Step 1

		n = s.length();
		m = t.length();
		if (n == 0) {
			return m;
		}
		if (m == 0) {
			return n;
		}
		d = new int[n + 1][m + 1];

		// Step 2

		for (i = 0; i <= n; i++) {
			d[i][0] = i;
		}

		for (j = 0; j <= m; j++) {
			d[0][j] = j;
		}

		// Step 3

		for (i = 1; i <= n; i++) {

			s_i = s.charAt(i - 1);

			// Step 4

			for (j = 1; j <= m; j++) {

				t_j = t.charAt(j - 1);

				// Step 5

				if (s_i == t_j) {
					cost = 0;
				} else {
					cost = 1;
				}

				// Step 6

				d[i][j] = Minimum(d[i - 1][j] + 1, d[i][j - 1] + 1,
						d[i - 1][j - 1] + cost);

			}

		}

		// Step 7

		return d[n][m];

	}

	
	public static String[] ListToArray(ArrayList<String> list){
		String[] listArray = new String[list.size()];
		
		for(int i = 0; i < list.size(); i++){
			listArray[i] = list.get(i);
		}
		
		return listArray;
	}

}
