/*
 * Decompiled with CFR 0.152.
 */
package methodsDesambiguation;

import Util.Similarity;
import io.ReaderAllBase;
import io.ReaderPerYear;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import methodsDesambiguation.EvaluationMetrics;
import methodsDesambiguation.INDIParameters;
import model.Citation;
import model.Cluster;
import model.Leaders;
import model.Log;

public class INDILeaders {
    public HashMap<Integer, Cluster> collection = new HashMap();

    public INDILeaders(ArrayList<String> nameFiles, File path, INDIParameters param) {
        ArrayList<Citation> citations = new ArrayList();
        ReaderPerYear readerPerYear = new ReaderPerYear();
        try {
            citations = readerPerYear.reader(nameFiles, path.getAbsolutePath() + File.separator);
            ArrayList<Object> clusInBase = new ArrayList();
            clusInBase = EvaluationMetrics.createClusterReference(citations);
            Iterator<Object> iter = clusInBase.iterator();
            while (iter.hasNext()) {
                Cluster clu = new Cluster();
                clu = (Cluster)iter.next();
                clu.iniCluster(param);
                this.collection.put(clu.getIdCluster(), clu);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void findCluster(ArrayList<Citation> citations, INDIParameters param) throws IOException {
        boolean find = false;
        double p_lim = param.getP_lim();
        int idCluster = 90000;
        int qtde = param.getQtde();
        double simTitle = param.getSimTitle();
        double simVenue = param.getSimVenue();
        double incremento = param.getIncremento();
        int cluN = 0;
        int cluE = 0;
        for (Citation cit : citations) {
            find = false;
            Iterator<Cluster> it = this.collection.values().iterator();
            while (it.hasNext() && !find) {
                Cluster cluSim = it.next();
                Leaders leaders = new Leaders();
                leaders = cluSim.getLeaders();
                if (!Similarity.comparacaoPorFragmento(cluSim.getNameRepresentative(), cit.getAuthor(), p_lim)) continue;
                boolean heuristicCoAuthors = false;
                boolean heuristicTitle = false;
                boolean bl = heuristicCoAuthors = cit.getCoauthors().size() == 0 || leaders.getCoAuthors().size() == 0 ? false : Similarity.compFragmentosCoautores(cit.getCoauthors(), leaders.getCoAuthors(), p_lim, qtde);
                if (heuristicCoAuthors) {
                    heuristicTitle = Similarity.heuristicTitleAndVenue(leaders, cit, simTitle, simVenue);
                } else if (cit.getCoauthors().isEmpty() || leaders.getCoAuthors().isEmpty()) {
                    heuristicCoAuthors = true;
                    heuristicTitle = Similarity.heuristicTitleAndVenue(leaders, cit, simTitle + incremento, simVenue + incremento);
                }
                if (!heuristicCoAuthors || !heuristicTitle) continue;
                find = true;
                Cluster c = this.collection.get(cluSim.getIdCluster());
                c.addCitation(cit, param);
                ++cluE;
            }
            if (find) continue;
            Cluster cluTemp = new Cluster();
            cluTemp.addCitation(cit, param);
            this.collection.put(cluTemp.getIdCluster(), cluTemp);
            ++cluN;
        }
    }

    public String runDesambiguation(ArrayList<String> nameFiles, File path, INDIParameters param) {
        ArrayList<Citation> neoCitations = new ArrayList();
        ReaderPerYear readerPerYear = new ReaderPerYear();
        String result = "";
        try {
            neoCitations = readerPerYear.reader(nameFiles, path.getAbsolutePath() + File.separator);
            this.findCluster(neoCitations, param);
            ArrayList<Citation> cits = new ArrayList();
            ReaderAllBase reader = new ReaderAllBase();
            cits = reader.reader(path);
            ArrayList<Cluster> clusGenerated = EvaluationMetrics.createClusterGenerated(this.collection);
            ArrayList<Cluster> clusReference = EvaluationMetrics.createClusterReference(cits);
            double pmc = EvaluationMetrics.PMC(clusReference, clusGenerated, cits.size());
            double pma = EvaluationMetrics.PMA(clusReference, clusGenerated, cits.size());
            double k = EvaluationMetrics.metricK(clusReference, clusGenerated, cits.size());
            result = param.getBaseLoad() + "\t" + pmc + "\t" + pma + "\t" + k + "\n";
            String base = path.getAbsolutePath().replace(path.getParent() + File.separator, "");
            Log log = new Log(this.collection, base, param, pmc, pma, k);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

