/*
 * Decompiled with CFR 0.152.
 */
package Util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import model.Citation;
import model.Leaders;
import uk.ac.shef.wit.simmetrics.similaritymetrics.CosineSimilarity;

public class Similarity {
    public static boolean compFragmentosCoautores(ArrayList<String> coauthor1, ArrayList<String> coauthor2, double lim, int qtde) {
        int comum = 0;
        if (coauthor1.isEmpty() || coauthor2.isEmpty()) {
            return false;
        }
        for (String name1 : coauthor1) {
            boolean found = false;
            for (String name2 : coauthor2) {
                if (name1 == null || name2 == null || !Similarity.comparacaoPorFragmento(name1, name2, lim) || found) continue;
                ++comum;
                found = true;
            }
        }
        return comum >= qtde;
    }

    public static boolean comparacaoPorFragmento(String nome1, String nome2, double p_lim) {
        int j;
        int i;
        String[] p_nome1 = nome1.split("[ ]");
        String[] p_nome2 = nome2.split("[ ]");
        boolean[] v_marcado_nome1 = new boolean[p_nome1.length];
        boolean[] v_marcado_nome2 = new boolean[p_nome2.length];
        double v_limInterno = p_lim;
        if (!(p_lim > 0.0) || p_lim < 1.0) {
            // empty if block
        }
        if (p_nome1[0].length() > 1 && p_nome2[0].length() > 1 ? (double)Similarity.LD(p_nome1[0], p_nome2[0]) > v_limInterno : (p_nome1[0].length() > 1 ? !p_nome2[0].equalsIgnoreCase(Similarity.firstLetter(p_nome1[0])) : !p_nome1[0].equalsIgnoreCase(Similarity.firstLetter(p_nome2[0])))) {
            return false;
        }
        if (p_nome1[p_nome1.length - 1].length() > 1 && p_nome2[p_nome2.length - 1].length() > 1) {
            if ((double)Similarity.LD(p_nome1[p_nome1.length - 1], p_nome2[p_nome2.length - 1]) > v_limInterno) {
                return false;
            }
        } else {
            return false;
        }
        for (i = 1; i < p_nome1.length - 1; ++i) {
            for (j = 1; j < p_nome2.length - 1; ++j) {
                if (p_nome1[i].length() <= 1 || p_nome2[j].length() <= 1 || !((double)Similarity.LD(p_nome1[i], p_nome2[j]) < v_limInterno)) continue;
                v_marcado_nome1[i] = true;
                v_marcado_nome2[j] = true;
            }
        }
        for (i = 1; i < p_nome1.length - 1; ++i) {
            for (j = 1; j < p_nome2.length - 1; ++j) {
                if (v_marcado_nome1[i] || p_nome1[i].length() <= 1 || p_nome2[j].length() != 1 || !Similarity.firstLetter(p_nome1[i]).equalsIgnoreCase(p_nome2[j])) continue;
                v_marcado_nome1[i] = true;
                v_marcado_nome2[j] = true;
            }
        }
        for (i = 1; i < p_nome1.length - 1; ++i) {
            for (j = 1; j < p_nome2.length - 1; ++j) {
                if (p_nome1[i].length() != 1 || v_marcado_nome2[j] || p_nome2[j].length() <= 1 || !Similarity.firstLetter(p_nome2[j]).equalsIgnoreCase(p_nome1[i])) continue;
                v_marcado_nome1[i] = true;
                v_marcado_nome2[j] = true;
            }
        }
        for (i = 1; i < p_nome1.length - 1; ++i) {
            for (j = 1; j < p_nome2.length - 1; ++j) {
                if (v_marcado_nome1[i] || v_marcado_nome2[j] || p_nome1[i].length() != 1 || p_nome2[j].length() != 1 || !p_nome2[j].equalsIgnoreCase(p_nome1[i])) continue;
                v_marcado_nome1[i] = true;
                v_marcado_nome2[j] = true;
            }
        }
        for (i = 1; i < p_nome1.length - 1; ++i) {
            if (v_marcado_nome1[i]) continue;
            for (j = 1; j < p_nome2.length - 1; ++j) {
                if (v_marcado_nome2[j]) continue;
                return false;
            }
        }
        return true;
    }

    static String firstLetter(String frag1) {
        if (frag1 != null && !frag1.equals("")) {
            return frag1.substring(0, 1);
        }
        return "";
    }

    public static int listCompareExact(ArrayList<String> a1, ArrayList<String> a2) {
        int result = 0;
        if (a1 == null || a2 == null) {
            return result;
        }
        for (String auxName : a1) {
            if (!a2.contains(auxName)) continue;
            result = 1;
        }
        return result;
    }

    public static boolean listCompareCossineSim(ArrayList<String> a1, ArrayList<String> a2, double sim, int qtde) {
        boolean result = false;
        int comum = 0;
        if (a1.isEmpty() || a2.isEmpty()) {
            return result;
        }
        block0: for (String str1 : a1) {
            Iterator<String> i$ = a2.iterator();
            while (i$.hasNext()) {
                CosineSimilarity metric = new CosineSimilarity();
                String str2 = i$.next();
                double parcResult = metric.getSimilarity(str1, str2);
                if (!(parcResult >= sim)) continue;
                comum = 1;
                continue block0;
            }
        }
        if (a1.size() - comum >= qtde) {
            return true;
        }
        return result;
    }

    public static boolean heuristicTitleAndVenueLeaders(Leaders leaders, Citation cit, double simTitle, double simVenue) {
        CosineSimilarity metric = new CosineSimilarity();
        return Similarity.cosineDistance(Similarity.ListToArray(leaders.getTitle()), Similarity.ListToArray(cit.getTitle())) > simTitle || Similarity.cosineDistance(Similarity.ListToArray(leaders.getVenue()), Similarity.ListToArray(cit.getVenue())) > simVenue;
    }

    public static boolean heuristicTitleAndVenue(Leaders leaders, Citation cit, double simTitle, double simVenue) {
        return Similarity.cosineDistance(Similarity.ListToArray(leaders.getTitle()), Similarity.ListToArray(cit.getTitle())) > simTitle || Similarity.cosineDistance(Similarity.ListToArray(leaders.getVenue()), Similarity.ListToArray(cit.getVenue())) > simVenue;
    }

    public static int wordsRankCossineSimLimite(ArrayList<String> list, TreeMap<String, List<Integer>> rank, int limit, double sim) {
        int result = 0;
        if (list.isEmpty() || rank.isEmpty()) {
            return result;
        }
        block0: for (String term : list) {
            Iterator<Map.Entry<String, List<Integer>>> iter = rank.entrySet().iterator();
            while (iter.hasNext()) {
                CosineSimilarity metric = new CosineSimilarity();
                Map.Entry<String, List<Integer>> entry = iter.next();
                String term2 = entry.getKey();
                double isSimilarity = metric.getSimilarity(term, term2);
                if (!(isSimilarity >= sim)) continue;
                ++result;
                continue block0;
            }
        }
        return result;
    }

    public static double cosineDistance(String[] first, String[] second) {
        double normFirst = 0.0;
        double normSecond = 0.0;
        Hashtable<String, Integer> hashFirst = new Hashtable<String, Integer>();
        Hashtable<String, Integer> hashSecond = new Hashtable<String, Integer>();
        for (int i = 0; i < first.length; ++i) {
            Integer value = hashFirst.put(first[i], new Integer(1));
            if (value != null) {
                int val = value;
                hashFirst.remove(first[i]);
                value = hashFirst.put(first[i], new Integer(val + 1));
                normFirst -= Math.pow(val, 2.0);
                normFirst += Math.pow(val + 1, 2.0);
                continue;
            }
            normFirst += 1.0;
        }
        double internalProduct = 0.0;
        for (int i = 0; i < second.length; ++i) {
            Integer value = hashSecond.put(second[i], new Integer(1));
            if (value != null) {
                int val = value;
                hashSecond.remove(second[i]);
                value = hashSecond.put(second[i], new Integer(val + 1));
                normSecond -= Math.pow(val, 2.0);
                normSecond += Math.pow(val + 1, 2.0);
            } else {
                normSecond += 1.0;
            }
            Integer valueFirst = (Integer)hashFirst.get(second[i]);
            if (valueFirst == null) continue;
            internalProduct += (double)valueFirst.intValue();
        }
        return internalProduct / Math.sqrt(normFirst * normSecond);
    }

    private static int Minimum(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }

    public static int LD(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = Similarity.Minimum(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    public static String[] ListToArray(ArrayList<String> list) {
        String[] listArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            listArray[i] = list.get(i);
        }
        return listArray;
    }
}

