/*
 * Decompiled with CFR 0.152.
 */
package model;

import Util.Similarity;
import java.util.ArrayList;
import java.util.Iterator;
import methodsDesambiguation.INDIParameters;
import model.Citation;

public class Leaders {
    private ArrayList<Citation> citations = new ArrayList();
    private ArrayList<String> coAuthors = new ArrayList();
    private ArrayList<String> authors = new ArrayList();
    private ArrayList<String> title = new ArrayList();
    private ArrayList<String> venue = new ArrayList();

    public ArrayList<Citation> getCitations() {
        return this.citations;
    }

    public void addCoaAuthors(ArrayList<String> coAuthors) {
        if (coAuthors.isEmpty()) {
            return;
        }
        for (String coAuthor : coAuthors) {
            if (this.getCoAuthors().contains(coAuthor)) continue;
            this.getCoAuthors().add(coAuthor);
        }
    }

    public void addTitle(ArrayList<String> lTitle) {
        if (lTitle.isEmpty()) {
            return;
        }
        for (String term : lTitle) {
            if (this.getTitle().contains(term)) continue;
            this.getTitle().add(term);
        }
    }

    public void addVenue(ArrayList<String> lVenue) {
        if (lVenue.isEmpty()) {
            return;
        }
        for (String term : lVenue) {
            if (this.getVenue().contains(term)) continue;
            this.getVenue().add(term);
        }
    }

    public boolean removeCitations(Citation cit, INDIParameters param) {
        boolean remove = false;
        int index = 0;
        int numCoAuthors = cit.getCoauthors().size();
        Iterator<Citation> iter = this.getCitations().iterator();
        while (iter.hasNext()) {
            Citation citation = new Citation();
            citation = iter.next();
            int numCoAuthorsCit = citation.getCoauthors().size();
            int qtde = 0;
            if (!Similarity.comparacaoPorFragmento(citation.getAuthor(), cit.getAuthor(), param.getP_lim())) continue;
            qtde = citation.getCoauthors().size();
            if (!Similarity.compFragmentosCoautores(citation.getCoauthors(), cit.getCoauthors(), param.getP_lim(), qtde)) continue;
            if (numCoAuthors > numCoAuthorsCit) {
                index = this.getCitations().indexOf(citation);
                remove = true;
                break;
            }
            if (cit.getVenue().size() <= citation.getVenue().size()) continue;
            index = this.getCitations().indexOf(citation);
            remove = true;
            break;
        }
        if (remove) {
            Citation removeCit = this.getCitations().get(index);
            this.getAuthors().remove(removeCit.getAuthor());
            this.setCoAuthors(this.removeList(this.getCoAuthors(), removeCit.getCoauthors()));
            this.setTitle(this.removeList(this.getTitle(), removeCit.getTitle()));
            this.setVenue(this.removeList(this.getVenue(), removeCit.getVenue()));
            this.getCitations().remove(index);
            for (Citation c : this.getCitations()) {
                this.addCoaAuthors(c.getCoauthors());
                this.addTitle(c.getTitle());
                this.addVenue(c.getVenue());
            }
        }
        return remove;
    }

    public ArrayList removeList(ArrayList<String> list, ArrayList<String> listToRemove) {
        if (list.isEmpty() || listToRemove.isEmpty()) {
            return list;
        }
        for (String termRemove : listToRemove) {
            list.remove(termRemove);
        }
        return list;
    }

    public void addCitations(Citation citation) {
        this.citations.add(citation);
        this.authors.add(citation.getAuthor());
        this.addCoaAuthors(citation.getCoauthors());
        this.addTitle(citation.getTitle());
        this.addVenue(citation.getVenue());
    }

    public ArrayList<String> getTitle() {
        return this.title;
    }

    public void setTitle(ArrayList<String> title) {
        this.title = title;
    }

    public ArrayList<String> getVenue() {
        return this.venue;
    }

    public void setVenue(ArrayList<String> venue) {
        this.venue = venue;
    }

    public ArrayList<String> getCoAuthors() {
        return this.coAuthors;
    }

    public void setCoAuthors(ArrayList<String> coAuthors) {
        this.coAuthors = coAuthors;
    }

    public ArrayList<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(ArrayList<String> authors) {
        this.authors = authors;
    }
}

