/*
 * Decompiled with CFR 0.152.
 */
package model;

import Util.Similarity;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import methodsDesambiguation.INDIParameters;
import model.Citation;
import model.Leaders;

public class Cluster {
    private String nameRepresentative = "";
    private int idCluster;
    private static int numCluster = 0;
    private int idAutorReal;
    private Hashtable<String, Integer> nameVariation = new Hashtable();
    private ArrayList<String> coauthors = new ArrayList();
    private ArrayList<Citation> citations = new ArrayList();
    private ArrayList<String> titles = new ArrayList();
    private Leaders leaders = new Leaders();
    private double numVar;
    private static int maxCit;

    public int getIdAutorReal() {
        return this.idAutorReal;
    }

    public void setIdAutorReal(int idAutorReal) {
        this.idAutorReal = idAutorReal;
    }

    public Cluster() {
        this.idCluster = ++numCluster;
    }

    public int getIdCluster() {
        return this.idCluster;
    }

    public void setIdCluster(int idCluster) {
        this.idCluster = idCluster;
    }

    public double getNumVar() {
        return this.numVar;
    }

    public void setNumVar(double numVar) {
        this.numVar = numVar;
    }

    public ArrayList<String> getTitles() {
        return this.titles;
    }

    public void setTitles(ArrayList<String> titles) {
        this.titles.addAll(titles);
    }

    public ArrayList<String> getCoauthors() {
        return this.coauthors;
    }

    public static int getMaxCit() {
        return maxCit;
    }

    public void setCoauthors(ArrayList<String> coauthors) {
        if (coauthors == null) {
            return;
        }
        for (String coau : coauthors) {
            if (this.coauthors.contains(coau)) continue;
            this.coauthors.add(coau);
        }
    }

    public String getNameRepresentative() {
        return this.nameRepresentative;
    }

    public void setNameRepresentative(String name) {
        if (name.length() > this.nameRepresentative.length()) {
            this.nameRepresentative = name;
        }
    }

    public Hashtable<String, Integer> getNameVariation() {
        return this.nameVariation;
    }

    public void setNameVariation(String nameVariation) {
        if (this.nameVariation.containsKey(nameVariation)) {
            int numVar = this.nameVariation.get(nameVariation);
            this.nameVariation.remove(nameVariation);
            this.nameVariation.put(nameVariation, ++numVar);
        } else {
            int numVar = 1;
            this.nameVariation.put(nameVariation, numVar);
        }
    }

    public ArrayList<Citation> getCitations() {
        return this.citations;
    }

    public void setCitations(Citation citations) {
        this.citations.add(citations);
    }

    public void setLeaders(Leaders leaders) {
        this.leaders = leaders;
    }

    public Leaders getLeaders() {
        return this.leaders;
    }

    public void addCitation(Citation cit, INDIParameters param) {
        this.setCitations(cit);
        this.setCoauthors(cit.getCoauthors());
        this.setTitles(cit.getTitle());
        this.setNameVariation(cit.getAuthor());
        this.setNameRepresentative(cit.getAuthor());
        maxCit = this.citations.size() % 2 == 0 ? (int)((double)this.citations.size() * 0.5) : (int)((double)this.citations.size() * 0.5) + 1;
        if (this.chooseLeaders(cit, this, param)) {
            this.getLeaders().addCitations(cit);
        }
    }

    public void iniCluster(INDIParameters param) {
        for (Citation cit : this.getCitations()) {
            if (!this.chooseLeaders(cit, this, param)) continue;
            this.getLeaders().addCitations(cit);
        }
    }

    public boolean chooseLeaders(Citation cit, Cluster clu, INDIParameters param) {
        boolean choose = false;
        boolean heuristcCoAuthor = false;
        boolean heuristcTitleAndVenue = false;
        Leaders leaders = new Leaders();
        leaders = clu.getLeaders();
        if (leaders.getCitations().size() == 0) {
            return true;
        }
        heuristcCoAuthor = Similarity.listCompareCossineSim(cit.getCoauthors(), leaders.getCoAuthors(), 0.8, 1);
        boolean bl = heuristcTitleAndVenue = !Similarity.heuristicTitleAndVenueLeaders(leaders, cit, param.getcSimTitle() + param.getIncremento(), param.getcSimVenue() + param.getIncremento());
        if (heuristcCoAuthor || heuristcTitleAndVenue) {
            if (this.getLeaders().getCitations().size() < maxCit) {
                return true;
            }
            return this.getLeaders().removeCitations(cit, param);
        }
        return choose;
    }

    public String toString() {
        String cluster = "====================================================================================\n";
        cluster = cluster + "Id do Grupo: " + this.idCluster + " Nome representativo: " + this.nameRepresentative + "\n";
        cluster = cluster + "------------------------------------------------------------------------------------\n";
        cluster = cluster + "N\u00famero de Registros =  " + this.citations.size() + "\n";
        cluster = cluster + "------------------------------------------------------------------------------------\n";
        Iterator<Citation> iter = this.citations.iterator();
        while (iter.hasNext()) {
            cluster = cluster + iter.next() + "\n";
        }
        cluster = cluster + "------------------------------------------------------------------------------------\n";
        cluster = cluster + "N\u00famero de Registros Representativos =  " + this.leaders.getCitations().size() + "\n";
        cluster = cluster + "------------------------------------------------------------------------------------\n";
        Iterator<Citation> iterLeader = this.leaders.getCitations().iterator();
        while (iterLeader.hasNext()) {
            cluster = cluster + iterLeader.next() + "\n";
        }
        cluster = cluster + "====================================================================================\n";
        return cluster;
    }
}

