/*
 * Decompiled with CFR 0.152.
 */
package methodsDesambiguation;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import model.Citation;
import model.Cluster;

public class EvaluationMetrics {
    public static ArrayList<Cluster> createClusterReference(ArrayList<Citation> cits) {
        ArrayList<Cluster> clusRef = new ArrayList<Cluster>();
        Hashtable<Integer, Cluster> clusInRef = new Hashtable<Integer, Cluster>();
        for (Citation cit : cits) {
            if (clusInRef.containsKey(cit.getIdCluster())) {
                int idClu = cit.getIdCluster();
                Cluster clu = new Cluster();
                clu = (Cluster)clusInRef.get(idClu);
                clu.setCitations(cit);
                clu.setTitles(cit.getTitle());
                clu.setCoauthors(cit.getCoauthors());
                continue;
            }
            Cluster clu = new Cluster();
            clu.setIdAutorReal(cit.getIdCluster());
            clu.setCoauthors(cit.getCoauthors());
            clu.setNameRepresentative(cit.getAuthor());
            clu.setTitles(cit.getTitle());
            clu.setCitations(cit);
            clusInRef.put(clu.getIdAutorReal(), clu);
        }
        Enumeration e = clusInRef.elements();
        while (e.hasMoreElements()) {
            clusRef.add((Cluster)e.nextElement());
        }
        return clusRef;
    }

    public static ArrayList<Cluster> createClusterGenerated(HashMap<Integer, Cluster> collection) {
        ArrayList<Cluster> cluGen = new ArrayList<Cluster>();
        Iterator<Cluster> iter = collection.values().iterator();
        while (iter.hasNext()) {
            cluGen.add(iter.next());
        }
        return cluGen;
    }

    public static double PMC(ArrayList<Cluster> clusReference, ArrayList<Cluster> clusGenerated, int N) {
        double pmc = 0.0;
        int r = clusReference.size();
        int q = clusGenerated.size();
        int n_ij = 0;
        for (int i = 0; i < q; ++i) {
            Cluster clusterGen = new Cluster();
            clusterGen = clusGenerated.get(i);
            int n_i = clusterGen.getCitations().size();
            if (n_i == 0) continue;
            for (int j = 0; j < r; ++j) {
                n_ij = 0;
                Cluster clusterRef = new Cluster();
                clusterRef = clusReference.get(j);
                for (int indexGen = 0; indexGen < clusterGen.getCitations().size(); ++indexGen) {
                    int idCitGen = clusterGen.getCitations().get(indexGen).getId();
                    for (int indexRef = 0; indexRef < clusterRef.getCitations().size(); ++indexRef) {
                        if (idCitGen != clusterRef.getCitations().get(indexRef).getId()) continue;
                        ++n_ij;
                    }
                }
                double parc = Math.pow(n_ij, 2.0) / (double)n_i;
                pmc += parc;
            }
        }
        return pmc /= (double)N;
    }

    public static double PMA(ArrayList<Cluster> clusReference, ArrayList<Cluster> clusGenerated, int N) {
        double pma = 0.0;
        int r = clusReference.size();
        int q = clusGenerated.size();
        int n_ij = 0;
        for (int j = 0; j < r; ++j) {
            Cluster clusterRef = new Cluster();
            clusterRef = clusReference.get(j);
            int n_j = clusterRef.getCitations().size();
            for (int i = 0; i < q; ++i) {
                n_ij = 0;
                Cluster clusterGen = new Cluster();
                clusterGen = clusGenerated.get(i);
                for (int indexRef = 0; indexRef < clusterRef.getCitations().size(); ++indexRef) {
                    int idCitRef = clusterRef.getCitations().get(indexRef).getId();
                    for (int indexGen = 0; indexGen < clusterGen.getCitations().size(); ++indexGen) {
                        if (idCitRef != clusterGen.getCitations().get(indexGen).getId()) continue;
                        ++n_ij;
                    }
                }
                if (n_j == 0) continue;
                double parc = Math.pow(n_ij, 2.0) / (double)n_j;
                pma += parc;
            }
        }
        return pma /= (double)N;
    }

    public static double k(double pmc, double pma) {
        double k = pmc * pma;
        k = Math.sqrt(k);
        return k;
    }

    public static double metricK(ArrayList<Cluster> clusReference, ArrayList<Cluster> clusGenerated, int N) {
        double pmc = EvaluationMetrics.PMC(clusReference, clusGenerated, N);
        double pma = EvaluationMetrics.PMA(clusReference, clusGenerated, N);
        double k = EvaluationMetrics.k(pmc, pma);
        return k;
    }
}

