unit UObjetos;
interface
uses Classes;
type
  TPesos = class
    public
      PesNEstDifArt: Integer;
      PesNSobShow: Integer;
  end;

    TArtista = class
    public
      Nome: String;
      Estilo: String;
  end;

  TNoite = class
    public
      Estilo: String;
      NArtista: Integer;
  end;

  TEntrada = class
    public
      LstCasas: TList;
      LstArtistas: TList;
      LstNoites: TList;

      constructor Create;
      procedure PreencherListas(Dir: String);
      destructor Destroy; override;
  end;

  TCasa = class
    private
      procedure CalcNEstDifArt(E: TEntrada);

    public
      Nome: String;
      LstNoites: TList;

      NEstDifArt: Integer;
      FncObj: Integer;

      constructor TCasa;
      procedure CalcFncObj(E: TEntrada; P: TPesos);
  end;

  TSolucao = class
    private
      function CalcFncObjCasas(E: TEntrada; P: TPesos): Integer;
      procedure CalcNSobShow(E: TEntrada);

    public
      LstCasas: TList;
      NSobShow: Integer;
      FncObjTotal: Integer;

      constructor Create(LC: TList);
      procedure Inicializar(E: TEntrada);
      function Clone: TSolucao;
      procedure Movimento(COrig, CDest, NOrig, NDest: Integer);
      procedure CalcFncObjTotal(E: TEntrada; P: TPesos);
  end;

  TSimAnn = class
    public
      procedure Executar(TI, TC, TR: Double; NIte: Integer; var S: TSolucao; E: TEntrada; P: TPesos);
  end;


implementation

uses SysUtils, QDialogs, QForms, UFrmCasas;

                        { TEntrada }

constructor TEntrada.Create;
begin
  Self.LstArtistas := TList.Create;
  Self.LstCasas    := TList.Create;
  Self.LstNoites   := TList.Create;
end;

procedure TEntrada.PreencherListas(Dir: String);
var
 Art: TArtista;
 Casa: TCasa;
 Noite: TNoite;
 i: Integer;
begin
  for i := 0 to 7 do
   begin
     Art := TArtista.Create;
     Art.Nome   := 'Nome. do artista: ' + IntToStr(i);
     Art.Estilo := 'A: ' + IntToStr(i+3);
     Self.LstArtistas.Add(Art);
   end;

  for i := 0 to 11 do
   begin
     Noite := TNoite.Create;
     Noite.Estilo := 'A: ' + IntToStr(i);
     Noite.NArtista := -1;
     Self.LstNoites.Add(Noite);
   end;

  for i := 0 to 5 do
   begin
     Casa := TCasa.Create;
     Casa.Nome := 'N. da casa: ' + IntToStr(i);
     Self.LstCasas.Add(Casa);
   end;
end;

destructor TEntrada.Destroy;
begin
  Self.LstArtistas.Destroy;
  Self.LstCasas.Destroy;
  Self.LstNoites.Destroy;
  inherited;
end;

                        { TCasa }

constructor TCasa.TCasa;
begin
  NEstDifArt := 0;
end;

procedure TCasa.CalcNEstDifArt(E: TEntrada);
var
 i: Integer;
 N1: TNoite;
 Art: TArtista;
begin
  NEstDifArt := 0;
  for i := 0 to LstNoites.Count-1 do
   begin
     N1 := LstNoites.Items[i];
     Art := E.LstArtistas.Items[N1.NArtista];
     if N1.Estilo <> Art.Estilo then
      NEstDifArt := NEstDifArt + 1;
   end;
end;

procedure TCasa.CalcFncObj(E: TEntrada; P: TPesos);
begin
  CalcNEstDifArt(E);
  FncObj := NEstDifArt * P.PesNEstDifArt;
end;


                        { TSolucao }

constructor TSolucao.Create(LC: TList);
var
 i: Integer;
 C1, C2: TCasa;
begin
  NSobShow := 0;
  Self.LstCasas := TList.Create;
  for i := 0 to LC.Count-1 do
   begin
     C1 := LC.Items[i];
     C2 := TCasa.Create;
     C2.Nome := C1.Nome;
     Self.LstCasas.Add(C2);
   end;
end;

procedure TSolucao.Inicializar(E: TEntrada);    //Soluo Inicial
var
 i, j: Integer;
 Casa: TCasa;
 N1, N2: TNoite;
begin
  for i := 0 to Self.LstCasas.Count-1 do
   begin
     Casa := Self.LstCasas.Items[i];
     Casa.LstNoites := TList.Create;
     for j := 0 to E.LstNoites.Count-1 do
      begin
        N1 := E.LstNoites.Items[j];
        N2 := TNoite.Create;
        N2.Estilo := N1.Estilo;
        N2.NArtista := random(E.LstArtistas.Count);
        Casa.LstNoites.Add(N2);
      end;
   end;
end;

procedure TSolucao.CalcNSobShow(E: TEntrada);
var
 i, j, k: Integer;
 Casa: TCasa;
 Noite: TNoite;
 LstNArt: TList;
 NArt: Integer;
begin
  //NSobShow := 0;
  //LstNArt := TList.Create;
  {for i := 0 to E.LstCasas.Count-1 do
   begin
     for j := 0 to Self.LstCasas.Count-1 do
      begin
        Casa := Self.LstCasas.Items[j];
        Noite := Casa.LstNoites.Items[i];
        for k := 0 to LstNArt.Count-1 do
         begin
           NArt := Integer(LstNArt.Items[k]);
           if Noite.NArtista = NArt then
            NSobShow := NSobShow + 1
           else
            LstNArt.Add(Pointer(Noite.NArtista));
         end;
        if LstNArt.Count = 0 then
         LstNArt.Add(Pointer(Noite.NArtista));
      end;
   end;}
end;

procedure TSolucao.Movimento(COrig, CDest, NOrig, NDest: Integer);  //Movimento
var
 CO, CD: TCasa;
 NO, ND: TNoite;
begin
  CO := Self.LstCasas.Items[COrig];
  NO := CO.LstNoites.Items[NOrig];

  CD := Self.LstCasas.Items[CDest];
  ND := CD.LstNoites.Items[NDest];

  NO := CO.LstNoites.Extract(CO.LstNoites.Items[NOrig]);
  ND := CD.LstNoites.Extract(CD.LstNoites.Items[NDest]);

  //CO.LstNoites.Insert(NOrig, ND);
  //CD.LstNoites.Insert(NDest, NO);

  CO.LstNoites.Add(ND);
  CD.LstNoites.Add(NO);
end;

function TSolucao.CalcFncObjCasas(E: TEntrada; P: TPesos): Integer;
var
 i: Integer;
 FO: Integer;
 Casa: TCasa;
begin
  FO := 0;
  for i := 0 to LstCasas.Count-1 do
   begin
     Casa := LstCasas.Items[i];
     Casa.CalcFncObj(E, P);
     FO := FO + Casa.FncObj;
   end;
  Result := FO;
end;

procedure TSolucao.CalcFncObjTotal(E: TEntrada; P: TPesos);
begin
  CalcNSobShow(E);
  FncObjTotal := CalcFncObjCasas(E, P);
  FncObjTotal := FncObjTotal + (NSobShow * P.PesNSobShow);
end;

function TSolucao.Clone: TSolucao;
var
 C, CC: TCasa;
 N, NC: TNoite;
 Clone: TSolucao;
 i, j: Integer;
begin
 Clone := TSolucao.Create(Self.LstCasas);

 Clone.NSobShow    := Self.NSobShow;
 Clone.FncObjTotal := Self.FncObjTotal;

 for i := 0 to Self.LstCasas.Count-1 do
  begin
   C  := Self.LstCasas.Items[i];
   CC := Clone.LstCasas.Items[i];

   CC.Nome       := C.Nome;
   CC.NEstDifArt := C.NEstDifArt;
   CC.FncObj     := C.FncObj;

   CC.LstNoites := TList.Create;

   for j := 0 to C.LstNoites.Count-1 do
    begin
      N  := C.LstNoites.Items[j];
      NC := TNoite.Create;
      NC.Estilo   := N.Estilo;
      NC.NArtista := N.NArtista;
      CC.LstNoites.Add(NC);
    end;
  end;

 Result := Clone;
end;


                        { TSimAnn }

procedure TSimAnn.Executar(TI, TC, TR: Double; NIte: Integer; var S: TSolucao; E: TEntrada; P: TPesos);
var
 SAux: TSolucao;
 Iter: Integer;
 X, Temp: Extended;
 FOTMelhor, FOTAntes, FOTDepois: Integer;
 CO, CD, NO, ND: Integer;
 COrig, CDest: TCasa;
begin
 Iter := 0;
 X := 0;
 FOTMelhor := 0;
 FOTAntes  := 0;
 FOTDepois := 0;

 S.CalcFncObjTotal(E, P);
 FOTMelhor := S.FncObjTotal;
 SAux := S.Clone();
 FOTAntes := FOTMelhor;

 Temp := TI;
 while(Temp > TC) do
  begin
   while(Iter < NIte) do
    begin
      FrmCasas.Label1.Caption := IntToStr(S.FncObjTotal);
      Iter := Iter + 1;

      CO := random(SAux.LstCasas.Count);
      CD := CO;
      while(CD = CO) do
       CD := random(SAux.LstCasas.Count);

      COrig := SAux.LstCasas.Items[CO];
      CDest := SAux.LstCasas.Items[CD];

      NO := random(COrig.LstNoites.Count);
      ND := random(CDest.LstNoites.Count);

      FOTAntes := SAux.FncObjTotal;

      SAux.Movimento(CO, CD, NO, ND);//fazer um movimento com a soluo correte

      SAux.CalcFncObjTotal(E, P);
      FOTDepois := SAux.FncObjTotal;

      if(FOTDepois < FOTAntes) then
       begin
         FOTAntes := FOTDepois;
         if(FOTAntes < FOTMelhor) then
          begin
            FOTMelhor := FOTAntes;
            S.Destroy;
            S := SAux.Clone();
          end;
       end
      else
       begin
         X := random(100000000);
         X := X/100000000;
         if(X < exp(-(FOTDepois - FOTAntes)/Temp)) then
          FOTAntes := FOTDepois
         else
          begin
            SAux.Movimento(CD, CO, ND, NO);
            SAux.CalcFncObjTotal(E, P);
          end;
       end;
    end;
   Temp := TR*Temp;
   Iter := 0;
  end;
 SAux.Destroy;
end;

end.
