%% PSO
tam_vet=130; %numero de caracteristicas a serem analisadas

%##############------parametros------################
c1=2.05; %peso do pbest
c2=2.05; %peso do gbest
limite_velo=4;
num_ind=30;
max_iter=30;
%####################################################

%############    populacao inicial    ###############
particula(1,1:tam_vet) = 1; %Uma particula com todas as features

for ii=1:num_ind
   aux=randi([1,tam_vet])
    for jj=1:aux
        particula(ii,randi([1,tam_vet]))= 1;
    end    
end

%####################################################



%############----velocidade inicial-----#############
velocidade = (rand(num_ind,tam_vet)*2-1);
%####################################################

plotar=0; %1 para plotar fitness

%##############------parametros------################
wini=0.9;
wend=0.2;
%####################################################


%-----
iter=0;
m=0;
fitness_gbs=0;
fitness_melhor=0;
gbs=zeros(1,tam_vet);
fitness_pbs=zeros(1,num_ind);
pbs=zeros(num_ind,tam_vet);
gbest_vector=[];


while (iter<max_iter)
    iter=iter+1;
    for i=1:(num_ind)
        
        fprintf('\nAvaliando particula %i da iteracao %i ... \n',i,iter)
        tic
        %#############  funcao fitness  ###################
        fitness(i)=sum(particula(i,:));
        %#############------------------###################
        fprintf('\nTempo para avaliar particula %i: \n',i)
        toc
    end
    for i=1:(num_ind)      
        %seleciona PBest
        
        if fitness(i)>=fitness_pbs(i)
            fitness_pbs(i)=fitness(i);
            pbs(i,:)=particula(i,:);
        end
        
        %seleciona GBest
        if (fitness_pbs(i)>=fitness_gbs)
            fitness_gbs=fitness_pbs(i)
            gbs=pbs(i,:);
            gbest_vector=[gbest_vector fitness_gbs];
        end
         
        
        fprintf('\nAcuracia da particula %i da iteracao %i :  %f \n',i,iter,fitness_pbs(i));
        
        
        
        %###########   calculo da velocidade  ############
        if iter>1
            velocidade(i,:)=velocidade(i,:)+c1*rand()*(pbs(i,:)-particula(i,:))+c2*rand()*(gbs-particula(i,:));
        end
        
        
        for j=1:tam_vet
            
            %limite velocidade
            
            if velocidade(i,j)>limite_velo
                velocidade(i,j)=limite_velo;
            end
            if velocidade(i,j)<-limite_velo
                velocidade(i,j)=-limite_velo;
            end
            
            
            %calculo da sigmoide
            s=1/(1+exp(-velocidade(i,j)));
            
            %troca de bit
            if rand()<s
                particula(i,j)=1;
            else
                particula(i,j)=0;
            end
            
        end
        
        %###########   grafico   ##############
        if plotar==1
            plot(iter,fitness_gbs,'y*');
            drawnow;
            hold on;
        end
        %########################################
    end
 save('estadoBPsoFeatSelection', '-regexp', '^(?!(DB|PUWaveDB)$).')    
end