
% Read files in LIBSVM format
[label_vector, instance_matrix] = read_sparse('histograms.txt');

% Pre-process data
instance_matrix2 = full(instance_matrix)';
[instance_matrix2,row_factor] = removeconstantrows(instance_matrix2);
[instance_matrix2,col_factor,temp] = unique(instance_matrix2','rows');

% Scaling data
% instance_matrix =
% (instance_matrix-repmat(min(instance_matrix,[],1),size(instance_matrix,1),1))./(repmat(max(instance_matrix,[],1)-min(instance_matrix,[],1),size(instance_matrix,1),1));
[instance_matrix2,scale_factor] = mapminmax(instance_matrix2');   
% [instance_matrix2,scale_factor] = mapstd(instance_matrix2');  
label_vector2 = label_vector(col_factor);

% Cross validation 
[best_c,best_g,best_cv,hC] = modsel(label_vector2,instance_matrix2');

% --- define svm options ---

svm_type = 0;       % epsilon SVM
kernel_type = 2;    % RBF kernel: exp(-gamma*|u-v|^2)
gamma = best_g;     % 'width' of the Gaussian basis function
cost = best_c;      % C parameter in loss function
%epsilon = 0.1;      % epsilon parameter in loss function
 
options = ['-s ', num2str(svm_type),...
 ' -t ', num2str(kernel_type),...
 ' -g ', num2str(gamma),...
 ' -c ', num2str(cost)];
% ' -p ', num2str(epsilon)];
 
% --- solve the problem ---
fprintf('Starting LIBSVM\n');
tic;
model = svmtrain(label_vector2, instance_matrix2', options);
fprintf('Optimization finished in %3.2f sec\n',toc);
 
% --- pre-process test data ---
instance_matrix = removeconstantrows('apply',removeconstantrows(instance_matrix)',row_factor);
instance_matrix = mapminmax('apply',instance_matrix,scale_factor);
% instance_matrix = mapstd('apply',instance_matrix,scale_factor);

% --- generalize solution ---
[pred_label accuracy decision_val] = svmpredict(label_vector, instance_matrix', model);

