% Autor : Eduardo Luz
% Ateno : Esta funo deve ser utilizada com a biblioteca libsvm
% http://www.csie.ntu.edu.tw/~cjlin/libsvm/
function [cm model predict_matrix label_matrix] = svm_Classifier_CH_1(modsel_weight, inputs, targets, inputsTest, targetsTest, C, gamma)

if nargin < 5
   C = 100; % default
   gamma = 1/size(inputs,2);
elseif nargin < 6    
   gamma = 1/size(inputs,2);
end


% formata para uso em SVM - para cada classe
for t=2:size(targets,2)
    targets(find(targets(:,t)==1),t)=t;     
end
trainLabels = sum(targets');

%-training_label_vector:
%            An m by 1 vector of training labels (type must be double).
%-training_instance_matrix:
%            An m by n matrix of m training instances with n features.
%            It can be dense or sparse (type must be double).
%
% ex.:
% model = svmtrain(trainLabels', inputs, '-c 1 -g 0.07');

%-s svm_type : set type of SVM (default 0)
%	0 -- C-SVC%
%	1 -- nu-SVC
%	2 -- one-class SVM
%	3 -- epsilon-SVR
%	4 -- nu-SVR
% -t kernel_type : set type of kernel function (default 2)
%	0 -- linear: u'*v
%	1 -- polynomial: (gamma*u'*v + coef0)^degree%
%	2 -- radial basis function: exp(-gamma*|u-v|^2)%
%	3 -- sigmoid: tanh(gamma*u'*v + coef0)
%-d degree : set degree in kernel function (default 3)
%-g gamma : set gamma in kernel function (default 1/num_features)
%-r coef0 : set coef0 in kernel function (default 0)
%-c cost : set the parameter C of C-SVC, epsilon-SVR, and nu-SVR (default 1)
%-n nu : set the parameter nu of nu-SVC, one-class SVM, and nu-SVR (default 0.5)
%-p epsilon : set the epsilon in loss function of epsilon-SVR (default 0.1)
%-m cachesize : set cache memory size in MB (default 100)
%-e epsilon : set tolerance of termination criterion (default 0.001)
%-h shrinking: whether to use the shrinking heuristics, 0 or 1 (default 1)
%-b probability_estimates: whether to train a SVC or SVR model for probability estimates, 0 or 1 (default 0)
%-wi weight: set the parameter C of class i to weight*C, for C-SVC (default 1)
%
%The k in the -g option means the number of attributes in the input data.

% gamma = 1/71 = 0.0141
% gamma = 1/31 = 0.0323
% gamma = 1/21 = 0.0476

% com kernel de funco quadrtica
%model = svmtrain(trainLabels', inputs, '-c 10 -t 1 -g 0.0141');

% com kernel RBF
str = sprintf([modsel_weight,' -c %d -t 2 -g %f -d 4'],C,gamma);
%model = svmtrain(trainLabels', inputs, '-c 10 -t 2 -g 0.0476');
%fprintf('Tempo treino : \n')
%tic
model = svmtrain(trainLabels', inputs, str);
%toc

% formata para uso em SVM - para cada classe
for t=2:size(targetsTest,2)
    targetsTest(find(targetsTest(:,t)==1),t)=t;     
end
testingLabels = sum(targetsTest');

%% Matriz de confuso e exatido para dados de treino
%-testing_label_vector:
%            An m by 1 vector of prediction labels. If labels of test
%            data are unknown, simply use any random values. (type must be double)
%-testing_instance_matrix:
%            An m by n matrix of m testing instances with n features.
%            It can be dense or sparse. (type must be double)
[predict_label_train, accuracy_train, dec_values_train] = svmpredict(trainLabels', inputs, model); % test the training data

%plota mtriz de confuso
ConfMatrix_train = confusionmat(trainLabels',predict_label_train);

%% Matriz de confuso e exatido para dados de teste
%-testing_label_vector:
%            An m by 1 vector of prediction labels. If labels of test
%            data are unknown, simply use any random values. (type must be double)
%-testing_instance_matrix:
%            An m by n matrix of m testing instances with n features.
%            It can be dense or sparse. (type must be double)
%fprintf('Tempo teste : \n')
%tic
[predict_label, accuracy, dec_values] = svmpredict(testingLabels', inputsTest, model); % test the training data
%toc

%plota mtriz de confuso
%cm = confusionmat(testingLabels',predict_label);

for i=1: size(predict_label,1)
switch(predict_label(i))
    case 1,
        predict_matrix(i,:) = [1 0];            
    case 2,
        predict_matrix(i,:) = [0 1];            
    
end
end

for i=1: size(testingLabels,2)
switch(testingLabels(i))
    case 1,
        label_matrix(i,:) = [1 0];            
    case 2,
        label_matrix(i,:) = [0 1];            
    
end
end
%[C,CM,IND,PER] = CONFUSION(TARGETS,OUTPUTS)
[c cm] = confusion(label_matrix', predict_matrix');



end