function [X,Y,Z,hC,bestc,bestg] = modsel_CH_2_plus(type, modsel_weight,label,inst)
% Model selection for (lib)SVM by searching for the best param on a 2D grid
% example:
%
% load heart_scale.mat
% [X,Y,Z,hC,bestc,bestg] = modsel(heart_scale_label,heart_scale_inst);
%
% where X,Y,Z are the contour data and hC is the contour handle

%contour plot

tamBaseTreino = round(size(inst,1)*0.50);
indexBaseTest = tamBaseTreino +1;

% utiliza 60% pra teino e 40% para teste (validao)
data1 = inst(1:tamBaseTreino,:);
target1 = label(1:tamBaseTreino,:);
data2 = inst(indexBaseTest:end,:);
target2 = label(indexBaseTest:end,:);

label(label==-1) = 2;
label(label==0) = 2;

c_begin = 6; c_end = -4; c_step = -1;
g_begin = 2; g_end = -8; g_step = -1;

bestc = 2^c_begin;
bestg = 2^g_begin;

for log2c = c_begin:c_step:c_end
    for log2g = g_begin:g_step:g_end
        %cmd = [modsel_weight,' -c ',num2str(2^log2c),' -g ',num2str(2^log2g)]; 
        
        sensitivityClass1= [];
        sensitivityClass2= [];
        sensitivityClass3= [];
        sensitivityClass4= [];
        acc = [];
        for k=1:2            
           % for k=1:10  % testa 10 vezes
               if(k==1)
                    [cm] = svm_Classifier(modsel_weight, data1, target1, data2, target2, 2^log2c, 2^log2g);
               else
                    [cm] = svm_Classifier(modsel_weight, data2, target2, data1, target1, 2^log2c, 2^log2g);
               end
                
                if max(label) == 2
                    sensitivityClass1 = cm(1,1)/sum(cm(1,:));
                    sensitivityClass2 = cm(2,2)/sum(cm(2,:));
                    
                    %acc(1) =
                    %(sensitivityClass1+sensitivityClass2+sensitivityClass3)/3;
                    % d mais peso para SVEB e VEB
                    acc(k) = (sensitivityClass1+(sensitivityClass2*1))/2;
                else
                    sensitivityClass1 = cm(1,1)/sum(cm(1,:));
                    sensitivityClass2 = cm(2,2)/sum(cm(2,:));
                    sensitivityClass3 = cm(3,3)/sum(cm(3,:));
                    sensitivityClass4 = cm(4,4)/sum(cm(4,:));                
                    %acc(1) = (sensitivityClass1+sensitivityClass2+sensitivityClass3+sensitivityClass4)/4;
                    % d mais peso para SVEB e VEB
                    acc(k) = (sensitivityClass1+(sensitivityClass2*1)+(sensitivityClass3*1)+sensitivityClass4)/4;
                end
                %end
            %end   

        end
        
        meanAcc = (acc(1)+acc(2))/2;        
        fprintf('--- Current accuracy = %6.3f \n',meanAcc)        
        %fprintf('desvio padro da preciso = %f \n',std(accuracy))        
        %especificidade -> horizontal na matrix de confuso 
        %for t=1:size(cm,2) % => nmero de classes
        %   fprintf('especificidade classe %d = %f \n',t,specificityClass(t))        
        %   fprintf('sensitividade classe %d = %f \n',t,sensitivityClass(t))        
        %   fprintf('\n')
        %end

        if(meanAcc > maxAccuracyTest)
            maxAccuracyTest = meanAcc;
            bestc = 2^log2c; bestg = 2^log2g; bestcv = meanAcc;
            fprintf('*** Best parameters founded! \n')

        end        
        disp([num2str(log2c),' ',num2str(log2g),' (best c=',num2str(bestc),' g=',num2str(bestg),' rate=',num2str(meanAcc)])
            
    end
end
X=0;Y=0;Z=0;hC=0;
end

