function [X,Y,Z,hC,bestc,bestg] = modsel_CH_2(modsel_weight, label,inst)
% Model selection for (lib)SVM by searching for the best param on a 2D grid
% example:
%
% load heart_scale.mat
% [X,Y,Z,hC,bestc,bestg] = modsel(heart_scale_label,heart_scale_inst);
%
% where X,Y,Z are the contour data and hC is the contour handle

%contour plot
if max(label) == 2
    wa = @(e1,e2,s1,s2)(1-(e1*1/s1+e2*1/s2)/2)*100; %weighted accuracy
elseif max(label) == 3
    wa = @(e1,e2,e3,s1,s2,s3)(1-(e1*1/s1+e2*1/s2+e3*1/s3)/3)*100; %weighted accuracy
elseif max(label) == 4
    wa = @(e1,e2,e3,e4,s1,s2,s3,s4)(1-(e1*1/s1+e2*1/s2+e3*1/s3+e4*1/s4)/4)*100; %weighted accuracy
else
    wa = @(e1,e2,e3,e4,e5,s1,s2,s3,s4,s5)(1-(e1*1/s1+e2*1/s2+e3*1/s3+e4*1/s4+e5*1/s5)/5)*100; %weighted accuracy
end

label(label==-1) = 2;
label(label==0) = 2;
fold = 5;

c_begin = 6; c_end = -2; c_step = -1;
g_begin = 2; g_end = -6; g_step = -1;


bestcv = 0;
bestc = 2^c_begin;
bestg = 2^g_begin;
i = 1; j = 1;
indices = crossvalind('Kfold',label,fold);
for log2c = c_begin:c_step:c_end
    for log2g = g_begin:g_step:g_end
        % quem deve ter mais peso??
        cmd = [modsel_weight, ' -c ',num2str(2^log2c),' -g ',num2str(2^log2g)]; 
        
        cp = classperf(label);
        for k = 1:fold
            test = (indices == k); train = ~test;
            mdl = svmtrain(label(train,:),inst(train,:),cmd);
            [class] = svmpredict(label(test,:),inst(test,:),mdl);
            classperf(cp,class,test);
        end
        
        if max(label) == 2
            cv = wa(cp.errorDistributionByClass(1), ...
            cp.errorDistributionByClass(2), ...            
            cp.SampleDistributionByClass(1),...
            cp.SampleDistributionByClass(2));  
        elseif max(label) == 3
            cv = wa(cp.errorDistributionByClass(1), ...
            cp.errorDistributionByClass(2), ...
            cp.errorDistributionByClass(3), ...
            cp.SampleDistributionByClass(1),...
            cp.SampleDistributionByClass(2),...
            cp.SampleDistributionByClass(3));  
        elseif max(label) == 4
            cv = wa(cp.errorDistributionByClass(1), ...
            cp.errorDistributionByClass(2), ...
            cp.errorDistributionByClass(3), ...
            cp.errorDistributionByClass(4), ...
            cp.SampleDistributionByClass(1),...
            cp.SampleDistributionByClass(2),...
            cp.SampleDistributionByClass(3),...
            cp.SampleDistributionByClass(4));  
        else
            cv = wa(cp.errorDistributionByClass(1), ...
            cp.errorDistributionByClass(2), ...
            cp.errorDistributionByClass(3), ...
            cp.errorDistributionByClass(4), ...
            cp.errorDistributionByClass(5), ...
            cp.SampleDistributionByClass(1),...
            cp.SampleDistributionByClass(2),...
            cp.SampleDistributionByClass(3),...
            cp.SampleDistributionByClass(4),...
            cp.SampleDistributionByClass(5));  
        end
        
        if (cv > bestcv) || ((cv == bestcv) && (2^log2c < bestc) && (2^log2g == bestg))
            bestcv = cv; bestc = 2^log2c; bestg = 2^log2g;
        end
        disp([num2str(log2c),' ',num2str(log2g),' (best c=',num2str(bestc),' g=',num2str(bestg),' rate=',num2str(bestcv)])
        
       if max(label) == 2
            fprintf('e1= %3.0f (acc=%6.2f) ** ',cp.errorDistributionByClass(1),100* (1-(cp.errorDistributionByClass(1)/cp.SampleDistributionByClass(1))));
            fprintf('e2=%3.0f (acc=%6.2f) ** ', cp.errorDistributionByClass(2),100* (1-(cp.errorDistributionByClass(2)/cp.SampleDistributionByClass(2))));
         
        elseif max(label) == 3
            fprintf('e1= %3.0f (acc=%6.2f) ** ',cp.errorDistributionByClass(1),100* (1-(cp.errorDistributionByClass(1)/cp.SampleDistributionByClass(1))));
            fprintf('e2=%3.0f (acc=%6.2f) ** ', cp.errorDistributionByClass(2),100* (1-(cp.errorDistributionByClass(2)/cp.SampleDistributionByClass(2))));
            fprintf('e3=%3.0f (acc=%6.2f) \n',cp.errorDistributionByClass(3),100* (1-(cp.errorDistributionByClass(3)/cp.SampleDistributionByClass(3))));
        
        elseif max(label) == 4
            fprintf('e1= %3.0f (acc=%6.2f) ** ',cp.errorDistributionByClass(1),100* (1-(cp.errorDistributionByClass(1)/cp.SampleDistributionByClass(1))));
            fprintf('e2=%3.0f (acc=%6.2f) ** ', cp.errorDistributionByClass(2),100* (1-(cp.errorDistributionByClass(2)/cp.SampleDistributionByClass(2))));
            fprintf('e3=%3.0f (acc=%6.2f) \n',cp.errorDistributionByClass(3),100* (1-(cp.errorDistributionByClass(3)/cp.SampleDistributionByClass(3))));
            fprintf('e4=%3.0f (acc=%6.2f) \n',cp.errorDistributionByClass(4),100* (1-(cp.errorDistributionByClass(4)/cp.SampleDistributionByClass(4))));
        
        else
            fprintf('e1= %3.0f (acc=%6.2f) ** ',cp.errorDistributionByClass(1),100* (1-(cp.errorDistributionByClass(1)/cp.SampleDistributionByClass(1))));
            fprintf('e2=%3.0f (acc=%6.2f) ** ', cp.errorDistributionByClass(2),100* (1-(cp.errorDistributionByClass(2)/cp.SampleDistributionByClass(2))));
            fprintf('e3=%3.0f (acc=%6.2f) \n',cp.errorDistributionByClass(3),100* (1-(cp.errorDistributionByClass(3)/cp.SampleDistributionByClass(3))));
            fprintf('e4=%3.0f (acc=%6.2f) \n',cp.errorDistributionByClass(4),100* (1-(cp.errorDistributionByClass(4)/cp.SampleDistributionByClass(4))));
            fprintf('e5=%3.0f (acc=%6.2f) \n',cp.errorDistributionByClass(5),100* (1-(cp.errorDistributionByClass(5)/cp.SampleDistributionByClass(5))));
        
        end  
        %fprintf('\n e1= %d',cp.errorDistributionByClass(1));
        
        Z(i,j) = cv;        
        j = j+1;
    end
    j = 1;
    i = i+1;
end
xlin = linspace(c_begin,c_end,size(Z,1));
ylin = linspace(g_begin,g_end,size(Z,2));
[X,Y] = meshgrid(xlin,ylin); 
acc_range = (ceil(bestcv)-3.5:.5:ceil(bestcv));
[C,hC] = contour(X,Y,Z',acc_range);    

%legend plot
set(get(get(hC,'Annotation'),'LegendInformation'),'IconDisplayStyle','Children')
ch = get(hC,'Children');
tmp = cell2mat(get(ch,'UserData'));
[M,N] = unique(tmp);
c = setxor(N,1:length(tmp));
for i = 1:length(N)
    set(ch(N(i)),'DisplayName',num2str(acc_range(i)))
end  
for i = 1:length(c) 
    set(get(get(ch(c(i)),'Annotation'),'LegendInformation'),'IconDisplayStyle','Off')
end
legend('show')  

%bullseye plot
hold on;
plot(log2(bestc),log2(bestg),'o','Color',[0 0.5 0],'LineWidth',2,'MarkerSize',15); 
axs = get(gca);
plot([axs.XLim(1) axs.XLim(2)],[log2(bestg) log2(bestg)],'Color',[0 0.5 0],'LineStyle',':')
plot([log2(bestc) log2(bestc)],[axs.YLim(1) axs.YLim(2)],'Color',[0 0.5 0],'LineStyle',':')
hold off;
title({['Best log2(C) = ',num2str(log2(bestc)),',  log2(gamma) = ',num2str(log2(bestg)),',  Accuracy = ',num2str(bestcv),'%'];...
    ['(C = ',num2str(bestc),',  gamma = ',num2str(bestg),')']})
xlabel('log2(C)')
ylabel('log2(gamma)')

