% Autor : Eduardo Luz
% Ateno : Esta funo deve ser utilizada com a biblioteca libsvm
% http://www.csie.ntu.edu.tw/~cjlin/libsvm/
function accuracy = libsvmrp102(inputs, targets, inputsTest, targetsTest)

targets(find(targets(:,2)==1),2)=2;
targets(find(targets(:,3)==1),3)=3;
targets(find(targets(:,4)==1),4)=4;
trainLabels = sum(targets'); 

%-training_label_vector:
%            An m by 1 vector of training labels (type must be double).
%-training_instance_matrix:
%            An m by n matrix of m training instances with n features.
%            It can be dense or sparse (type must be double).
%
% ex.:
% model = svmtrain(trainLabels', inputs, '-c 1 -g 0.07');

%-s svm_type : set type of SVM (default 0)
%	0 -- C-SVC%
%	1 -- nu-SVC
%	2 -- one-class SVM
%	3 -- epsilon-SVR
%	4 -- nu-SVR
% -t kernel_type : set type of kernel function (default 2)
%	0 -- linear: u'*v
%	1 -- polynomial: (gamma*u'*v + coef0)^degree%
%	2 -- radial basis function: exp(-gamma*|u-v|^2)%
%	3 -- sigmoid: tanh(gamma*u'*v + coef0)
%-d degree : set degree in kernel function (default 3)
%-g gamma : set gamma in kernel function (default 1/num_features)
%-r coef0 : set coef0 in kernel function (default 0)
%-c cost : set the parameter C of C-SVC, epsilon-SVR, and nu-SVR (default 1)
%-n nu : set the parameter nu of nu-SVC, one-class SVM, and nu-SVR (default 0.5)
%-p epsilon : set the epsilon in loss function of epsilon-SVR (default 0.1)
%-m cachesize : set cache memory size in MB (default 100)
%-e epsilon : set tolerance of termination criterion (default 0.001)
%-h shrinking: whether to use the shrinking heuristics, 0 or 1 (default 1)
%-b probability_estimates: whether to train a SVC or SVR model for probability estimates, 0 or 1 (default 0)
%-wi weight: set the parameter C of class i to weight*C, for C-SVC (default 1)
%
%The k in the -g option means the number of attributes in the input data.

% gamma = 1/21 = 0.04761

% com kernel de funco quadrtica
%model = svmtrain(trainLabels', inputs, '-c 10 -t 1 -g 0.04761');

% com kernel RBF
model = svmtrain(trainLabels', inputs, '-c 1 -t 2 -g 0.04761');

targetsTest(find(targetsTest(:,2)==1),2)=2;
targetsTest(find(targetsTest(:,3)==1),3)=3;
targetsTest(find(targetsTest(:,4)==1),4)=4;
testingLabels = sum(targetsTest');

%-testing_label_vector:
%            An m by 1 vector of prediction labels. If labels of test
%            data are unknown, simply use any random values. (type must be double)
%-testing_instance_matrix:
%            An m by n matrix of m testing instances with n features.
%            It can be dense or sparse. (type must be double)
[predict_label, accuracy, dec_values] = svmpredict(testingLabels', inputsTest, model); % test the training data

end