% Autor : Eduardo Luz
% funo : Aplica PCA no grupo passado como refer6encia e retorna um grupo
% reduzido com base no percentual de aproximao (percentual)
% - 
% See also, cargardados.m e featureExtraction.m
%
% Retorno : 
% ex.: [newGroup]=applyPCA(G{3}.da, 99)


function [newData index]=applyPCA(data, percentual)

% se percentual passado for maior que 1, assume que usurio est
% trabalhando com percentual de 1 - 100. Caso contrrio, assume 0.0 a 1.0 
if(percentual>1)
    percentual = percentual / 100;
end

% score -> the representation of X in the principal component space (novos
% dados deentrada)
[pc score lat]= princomp(zscore(data));

ret = cumsum(lat)./sum(lat);

x = find(ret > percentual);

%newData = score(:,1:x(1));
newData = score;

index = x(1);
end