% createiristemplate - generates a biometric template from an iris in
% an eye image.
%
% Usage: 
% [template, mask] = createiristemplate(eyeimage_filename)
%
% Arguments:
%	eyeimage_filename   - the file name of the eye image
%
% Output:
%	template		    - the binary iris biometric template
%	mask			    - the binary iris noise mask
%
% Author: 
% Libor Masek
% masekl01@csse.uwa.edu.au
% School of Computer Science & Software Engineering
% The University of Western Australia
% November 2003

function [polar_array_sub label] = IRIS2MAT_twelve_partition_UBIRIS(eyeimage_filename, houghpara_filename, imgSize, classID)



% path for writing diagnostic images
global DIAGPATH
DIAGPATH = 'diagnostics';

%normalisation parameters
%radial_res = 16;
%angular_res = 128;
radial_res = imgSize(1);
angular_res = imgSize(2);
% with settings 16 and 128, a 2048 bit iris template is
% created

eyeimage = imread(eyeimage_filename); 
%eyeimage = rgb2gray(eyeimage);%UBIRIS
eyeimage = rgb2gray(eyeimage(:,:,1:3));

savefile = [houghpara_filename,'-houghpara.mat'];
[stat,mess]=fileattrib(savefile);

if stat == 1
    % if this file has been processed before
    % then load the circle parameters and
    % noise information for that file.
    load(savefile);
    
else
    
    % if this file has not been processed before
    % then perform automatic segmentation and
    % save the results to a file
    
    [circleiris circlepupil] = segmentiris(eyeimage);
    save(savefile,'circleiris','circlepupil');
    
end


imagewithcircles = uint8(eyeimage);

%get pixel coords for circle around iris
[x,y] = circlecoords([circleiris(2),circleiris(1)],circleiris(3),size(eyeimage));
ind2 = sub2ind(size(eyeimage),double(y),double(x)); 

%get pixel coords for circle around pupil
[xp,yp] = circlecoords([circlepupil(2),circlepupil(1)],circlepupil(3),size(eyeimage));
ind1 = sub2ind(size(eyeimage),double(yp),double(xp));

% Write circles overlayed
imagewithcircles(ind2) = 255;
imagewithcircles(ind1) = 255;
%w = cd;
%cd(DIAGPATH);
%imwrite(imagewithcircles,[eyeimage_filename,'-segmented.jpg'],'jpg');
%cd(w);

% perform normalisation
[polar_array] = normaliseiris(eyeimage, circleiris(2),...
    circleiris(1), circleiris(3), circlepupil(2), circlepupil(1), circlepupil(3),eyeimage_filename, radial_res, angular_res);


% WRITE NORMALISED PATTERN, AND NOISE PATTERN
%w = cd;
%cd(DIAGPATH);
%imwrite(polar_array,[eyeimage_filename,'-polar.jpg'],'jpg');
%cd(w);

% perform feature encoding
%[templates] = encodewavelet(polar_array, level); 

polar_array_sub{1} = polar_array(1:imgSize(1)/2, 1:imgSize(2)/4);
polar_array_sub{2} = polar_array( (imgSize(1)/4) : (imgSize(1)/4) + (imgSize(1)/2) , 1:imgSize(2)/4); %overlapping
polar_array_sub{3} = polar_array(imgSize(1)/2+1:imgSize(1), 1:imgSize(2)/4);

polar_array_sub{4} = polar_array(1:imgSize(1)/2, (imgSize(2)/4)+1:imgSize(2)/2);
polar_array_sub{5} = polar_array((imgSize(1)/4) : (imgSize(1)/4) + (imgSize(1)/2), (imgSize(2)/4)+1:imgSize(2)/2);
polar_array_sub{6} = polar_array(imgSize(1)/2+1:imgSize(1), (imgSize(2)/4)+1:imgSize(2)/2);

polar_array_sub{7} = polar_array(1:imgSize(1)/2, (imgSize(2)/2)+1:(imgSize(2)/2)+(imgSize(2)/4));
polar_array_sub{8} = polar_array((imgSize(1)/4) : (imgSize(1)/4) + (imgSize(1)/2), (imgSize(2)/2)+1:(imgSize(2)/2)+(imgSize(2)/4));
polar_array_sub{9} = polar_array(imgSize(1)/2+1:imgSize(1), (imgSize(2)/2)+1:(imgSize(2)/2)+(imgSize(2)/4));

polar_array_sub{10} = polar_array(1:imgSize(1)/2, (imgSize(2)/2)+(imgSize(2)/4)+1:imgSize(2));
polar_array_sub{11} = polar_array((imgSize(1)/4) : (imgSize(1)/4) + (imgSize(1)/2), (imgSize(2)/2)+(imgSize(2)/4)+1:imgSize(2));
polar_array_sub{12} = polar_array(imgSize(1)/2+1:imgSize(1), (imgSize(2)/2)+(imgSize(2)/4)+1:imgSize(2));

label = classID;


end
