 clear
 clc
 load DB
 load PUWaveDB

%% Busca melhores parmetros da rede complexa do VCG3D

limsInf_redes = [1 0.001 0.1]'; 
limsSup_redes = [10 0.2 1]';

numInd_redes = 100;
numGer_redes = 50;


tic1 = tic;
[gbVar_Redes,gbFit_Redes,gbFit_vector_Redes]=psoRedes(limsInf_redes,limsSup_redes,numInd_redes,numGer_redes,DB,PUWaveDB);
disp('###################################################')
disp('Fim da execuo do PSO para evoluir Redes Complexas')
toc(tic1)
gbFit_vector_Redes

%% Busca melhores pesos para SVM

limsInf_svm = [1 10 5]';
limsSup_svm = [5 200 100]';

 numInd_svm = 100;
 numGer_svm = 100;


n=gbVar_Redes(1)
t0=gbVar_Redes(2)
tq=gbVar_Redes(3)

tic1 = tic;
[gbVar_SVM,gbFit_SVM,gbFit_vector_SVM]=psoSvm(limsInf_svm,limsSup_svm,numInd_svm,numGer_svm,n,t0,tq,DB,PUWaveDB);
disp('###################################################')
disp('Fim da execuo do PSO para evoluir SVM')
toc(tic1)

%% Seleciona melhores features

gbFit_vector_SVM

w1=gbVar_SVM(1)
w2=gbVar_SVM(2)
w3=gbVar_SVM(3)
gamma=0;
C=0;

%%

num_ind = 300;       %Nmero de indviduos da populao
max_iter = 100;     %Nmero mximo de geraes

tic1 = tic;
[gbVar_featSel,gbFit_featSel,gbFit_vector_featSel]=BpsoFeatSelection(num_ind,max_iter,n,t0,tq,w1,w2,w3,gamma,C,DB,PUWaveDB);
disp('###################################################')
disp('Fim da execuo do BPSO para Feature Selection')
toc(tic1)

gbVar_featSel
gbFit_featSel

gbFit_vector_featSel

avaliaFinal(gbVar_featSel,n,t0,tq,w1,w2,w3,gamma,C,DB,PUWaveDB);

exit
