clear all
close all

% o arquivo MITBIH.mat � um array de uma estrututa, de tamanho 44, composta por:
%   - Record : n�mero do registro
%   - ecgDII : toda curva da deriva��o II do registro
%   - ecgDV1 : toda curva da deriva��o V do registro
%   - anns : anota��o dos eventos relacionados com as curvas dos registros
%   - annsPUWave : anota��es extras conseguidas com o ecgPUWave (ondas P, Q, R, S e T)

% anns � uma estrutura, com os campos :
%  timeInSeconds (number): the time of the annotation in seconds
%  sampleNumber (uint): the time of the annotation in samples
%  typeMnemonic (string): the mnemonic for the type of the annotation
%  subtype (uint8): the annotation's subtyp field
%  chan (uint8): the annotation's chan field
%  num (uint8): the annotation's num field
%  auxInfo (string): a string of auxiliary information for the annotation
 
% Ver c�digo das anota�?es em:
% http://physionet.org/physiotools/wpg/wpg_32.htm#SEC112

load 'MITBIH.mat'
DB =[MITDB{:}]; clear MITDB;
load 'PUWaveDB.mat';


% percorre a lista de registros para o processo de filtragem
%% ** PR�-PROCESSAMENTO **
chazal = 0;
comomFilter=0;
wavelet = 0;
filterName = 'nenhumFilt';
for i=1:size(DB,2)
    if chazal == 1
        filterName = 'FiltChazal';
        disp('filtra sinal com filtros do de Chazal');
        [filteredDII,filteredDV1] = applyChazalFilters(DB(1,i).ecgDII, DB(1,i).ecgDV1);
        DB(1,i).ecgDII = filteredDII; clear filteredDII;
        DB(1,i).ecgDV1 = filteredDV1; clear filteredDV1;
    elseif comomFilter == 1
        disp('filtra sinal filt comum...');
        [filteredDII,filteredDV1] = applyFilters(DB(1,i).ecgDII, DB(1,i).ecgDV1);
        DB(1,i).ecgDII = filteredDII; clear filteredDII;
        DB(1,i).ecgDV1 = filteredDV1; clear filteredDV1;
        filterName = 'FiltComum';
    elseif wavelet == 1
        % ATENCAO : precisa de muita mem�ria para usar wavelet aqui!
        disp('filtra sinal com wavelet...');
        [filteredDII,filteredDV1] = applyWavelet(DB(1,i).ecgDII, DB(1,i).ecgDV1);
        DB(1,i).ecgDII = filteredDII; clear filteredDII;
        DB(1,i).ecgDV1 = filteredDV1; clear filteredDV1;
        filterName = 'FiltWavelet';
    else
        % nao aplica filtro
    end    
end

%% ** EXTRA��O DE CARACTER�STICAS ***
% para extrair caracter�sticas, crie um m�todo 
% baseado no VCGFeatureExtraction.m. O m�todo deve receber os dados
% pr�-processados DB(1,:) e devolver um vetor de caracter�sticas FV no
% formato: [X1 X2 X3 .. Xn Ci], onde Xn � uma caracte'istica na dimens�o n
% e Ci infoma��o sobre a classe da inst�ncia (valor inteiro)

% Par�metros para redes complexas
% faz um grid search com os par�metros : n, t0 e tq
%n=2;
%t0=0.05;
%tq=0.3;
for n=2:2:8
    for t0=0.005:0.05:0.105
        for tq=0.3:0.3:0.9

            methodName = ['VCG_' num2str(n) '_' num2str(t0) '_' num2str(tq) '_' filterName]

            % percorre a lista de registros para o processo de extra��o de
            % CARACTER�STICAS
            FV=[]; % vetor de features de todo a base

            disp('Extrai caracter�sticas com VCG...');
            tic
            
            % para teste mais r�pido (apenas lopo ds1) ligue esta chave
            DS1 = [2;5;6;7;9;11;12;13;15;16;18;20;22;24;25;26;27;28;33;35;38;40];
            LOPO_DS1 = 0; % com esta chave desligada, executa tamb�m treino DS1 e teste DS2 (**AVALIACAO OFICIAL**)
            
            for i=1:size(DB,2)
                  DB(1,i).record
                  
                  if LOPO_DS1 == 1
                      % extrai apenas para DS1
                      if find(DS1==i) > 0
                          tic
                          FV(i).featureVector = VCGFeatureExtraction(DB(1,i).ecgDII, DB(1,i).ecgDV1, DB(1,i).anns, DB(1,i).annsPUWave, n, t0, tq, PUWaveDB(i).beat);   
                          toc
                      else
                           FV(i).featureVector = [];   
                      end
                  else
                      tic
                      FV(i).featureVector = VCGFeatureExtraction(DB(1,i).ecgDII, DB(1,i).ecgDV1, DB(1,i).anns, DB(1,i).annsPUWave, n, t0, tq, PUWaveDB(i).beat);   
                      toc
                  end
            end
            disp('tempo total pra extracao : ');
            toc

            %% APLICA CLASSIFICADORES
            % para usar outros classificadores, veja a integra��o dos classificadores SVM e LD
            % no c�digo de classify_lopo_ds1.m ou classify_ds1_ds2.m
            %
            % O classificador � escolhido no 4 par�metro das fun��es e deve
            % ser passado como um array de caracteres.
            %
            disp('Aplica classificador SVM e avalia ...');
            tic
            %roda o classificador
            featSel = []; % nao seleciona caracteristica. Usa todas.
            classifier = 'SVM';
            C = 0; % zero para usar valores default
            gamma = 0; % zero para usar valores default
            classify_lopo_ds1(FV, methodName, featSel, classifier, C, gamma);
            classify_ds1_ds2(FV, methodName, featSel, classifier, C, gamma);
            toc

            disp('Aplica classificador LD e avalia ...');
            tic
            %roda o classificador
            featSel = []; % nao seleciona caracteristica. Usa todas.
            classifier = 'LD';
            classify_lopo_ds1(FV, methodName, featSel, classifier, C, gamma);
            classify_ds1_ds2(FV, methodName, featSel, classifier, C, gamma);
            toc

        end
    end
end


