% Real PSO
%
% minimizes the objective function designated in ff
% Before beginning, set all the parameters in parts I, II, and III
% Haupt & Haupt
% 2003
function [gbVar,gbFit,gbFit_vector]=psoSvm(limsInf,limsSup,numInd,numGer,n,t0,tq,DB,PUWaveDB)



opt.lb = limsInf;         %-> limite inferior dos parametros
opt.ub = limsSup;         %-> limite superior dos parametros


%_______________________________________________________
% III. PSO parameters

opt.popsize = numInd;                 %-> nmero de indivduos da populao
opt.maxGer = numGer;                  %-> nmero de geraes
opt.numVar = size(opt.ub,1);      % nmero de variveis
opt.w      = 0.9;                 % fator inicial da inrcia
opt.c1     = 2.05;                % acelerao na direo do pbest
opt.c2     = 2.05;                % acelerao na direo do gbest
opt.phi    = opt.c1+opt.c2;
opt.K      = 2/abs((2-opt.phi-sqrt(opt.phi*opt.phi-4*opt.phi)));

emax = 30;           % nmero mximo de estabilizacao de funcao

% that survive


%_______________________________________________________
% initialized
popVar = bsxfun(@plus,bsxfun(@times,rand(opt.numVar,opt.popsize),(opt.ub - opt.lb)),opt.lb);
popVar(:,1)=[6; 100; 15]; %Valores usados no artculo
%_______________________________________________________
% calculates population
%O indviduo 1  avaliado fora do parfor para no extrair caractersticas
%multiplas vezes
popFit(1) = avaliaSvm(popVar(:,1),n,t0,tq,DB,PUWaveDB); %%% funcao objetivo
fprintf('Individuo %f %f %f - Fitness %f \n',popVar(:,1),popFit(1));
parfor k=2:size(popVar,2)
    popFit(k) = avaliaSvm(popVar(:,k),n,t0,tq,DB,PUWaveDB); %%% funcao objetivo
    fprintf('Individuo %f %f %f - Fitness %f \n',popVar(:,k),popFit(k));
end
%--- pbest inicial igual a PP
pbVar             = popVar;
pbFit             = popFit;

%--- gbest inicial (min)
[gbFit, b] = max(popFit);
gbVar = popVar(:,b);

%--- velocidade inicial
VV = zeros(opt.numVar,opt.popsize);

% Iterate through generations
%epsilon=1e-3;
epsilon = 1e-8; % gladston, alterei par e-8
stopcrit = 0;
opt.numGer = 1;
opt_val = 1;

UU = -1;
nenh = 0; % contador de estabilizao para a funo objetivo
Uenh = [5 4 3 2 1];
fdw = sort(rand(1,opt.maxGer+1));
gbFit_vector=[gbFit]; % cria vetor com os gbests


cc1 = zeros(opt.numVar,opt.popsize);
cc2 = zeros(opt.numVar,opt.popsize);
while stopcrit == 0
    %opt.numGer=opt.numGer+1;
    
    %--- calcular velocidades ...
    for i=1:opt.popsize
        %atualiza as velocidades
        for j=1:opt.numVar
            cc1(j,:)=rand(opt.popsize,1)*opt.c1;
            cc2(j,:)=rand(opt.popsize,1)*opt.c2;
        end
        %Multipliquei por 0.3
        VV(:,i)= 0.3*opt.K*(opt.w*VV(:,i)+ cc1(:,i).*(pbVar(:,i)-popVar(:,i))+ cc2(:,i).*(gbVar-popVar(:,i)));%
        %atualiza a populao
        popVar(:,i)=popVar(:,i)+VV(:,i);
        %popVar = sort(popVar,1);
        %--- verificar e altera velocidade das particulas fora dos limites
        %for i=1:opt.popsize
         if dominio(popVar(:,i),opt)==1%fora dos limites
            if abs(popVar(:,i)-opt.lb) < abs(popVar(:,i)-opt.ub)
                popVar(:,i)=opt.lb;
            else
                popVar(:,i)=opt.ub;
            end
            %Dividi por 30
            VV(:,i)=-VV(:,i)/30;
        end
    end
    
    %%
    %mutacao ---- no precisa, depois vemos se podemos usar
    %popVar = mutation(opt.numGer,popVar,opt);
    %popVar = mutation2(popVar,opt);
    
    %--------------------------------------------------------------------
    %    Critrio de Parada
    opt.numGer = opt.numGer + 1;
    %[vm, im] = min(Fpop);
    if gbFit > UU
        UU=gbFit;
        Uenh(1:4) = Uenh(2:5);
        Uenh(5) = UU;
        nenh = 0;
    else
        nenh = nenh + 1;
    end
    if (abs(gbFit - opt_val) <= epsilon) || (opt.numGer > opt.maxGer || (nenh >= emax))
        stopcrit = 1;
    end
    
    
    if ~stopcrit
        
        %-evaluation popVar
        
        parfor k=1:size(popVar,2)
            popFit(k) = avaliaSvm(popVar(:,k),n,t0,tq,DB,PUWaveDB); %%% funcao objetivo
            fprintf('Individuo %f %f %f - Fitness %f \n',popVar(:,k),popFit(k));
        end
        
        %update pbest
        for i=1:opt.popsize
            %r=dominance_relation(popFit(:,i),pbFit(:,i));
            if  popFit(i)> pbFit(i)
                pbVar(:,i)  = popVar(:,i);
                pbFit(i)  = popFit(i);
            end
            
        end
        
        %update gbest
        [gb, b] = max(popFit);
        if  gb > gbFit
            gbFit = gb;
            gbVar = popVar(:,b);
            gbFit_vector=[gbFit_vector gbFit];
        end
               
        % fator de inercia
        opt.w=-0.5*fdw(1,opt.numGer)+0.9;
        
    end
    save('estadoPsoSvm', '-regexp', '^(?!(DB|PUWaveDB)$).')
end
end

function result=dominio(x,opt)

%Funcao para tratar pontos fora do dominio de busca
%x \in \R^n
%inter=[ xmin xmax ] para todas as x_i;
%retorna 0 se x \in inter
%retorna 1 caso contrrio
vx=[];% vetor com as condicoes de cada x_i
x=real(x);
n=opt.numVar;
xmin=opt.lb;
xmax=opt.ub;

for i=1:n
    
    %if (x(i)~=xmax(i)) || (x(i)~=xmin(i))
    if (xmin(i)<=x(i)) && (x(i)<=xmax(i))
        vx(i)=0;
    else
        vx(i)=1;
    end
    %else
    %    vx(i)=0;%neste caso x(i) é um dos extremos do box!
    %end
end

if any(vx)==0
    % x \in box
    result=0;
else
    % x \not in box
    result=1;
end
end


