function Hd = lowpass500FIR35
%LOWPASS500FIR35 Returns a discrete-time filter object.

%
% M-File generated by MATLAB(R) 7.7 and the Signal Processing Toolbox 6.10.
%
% Generated on: 06-Dec-2011 19:28:52
%

% Equiripple Lowpass filter designed using the FIRPM function.

% All frequency values are in Hz.
Fs = 500;  % Sampling Frequency

N     = 12;  % Order
Fpass = 35;  % Passband Frequency
Fstop = 40;  % Stopband Frequency
Wpass = 1;   % Passband Weight
Wstop = 1;   % Stopband Weight
dens  = 20;  % Density Factor

% Calculate the coefficients using the FIRPM function.
b  = firpm(N, [0 Fpass Fstop Fs/2]/(Fs/2), [1 1 0 0], [Wpass Wstop], ...
           {dens});
Hd = dfilt.dffir(b);

% [EOF]
