% Autores : Eduardo Luz
% Funo : Caregar as caractersticas extadas pelo "featureExtraction.m"
% e coloca-las em 2 parties conforme norma da AAMI.


function [p1d p1t p2d p2t] = loadDataAAMI(FV, SMOTE_FLAG, trainset, testset)

%dataset1 = {'101';'106';'108';'109';'112';'114';'115';'116';'118';'119';'122';'124';'201';'203';'205';'207';'208';'209';'215';'220';'223';'230'};
%dataset2 = {'100';'103';'105';'111';'113';'117';'121';'123';'200';'202';'210';'212';'213';'214';'219';'221';'222';'228';'231';'232';'233';'234'};

if nargin == 2
    % por padro usa DS1 e DS2 proposto por de Chazal (2014)
    dataset1 = [2;5;6;7;9;11;12;13;15;16;18;20;22;24;25;26;27;28;33;35;38;40];
    dataset2 = [1;3;4;8;10;14;17;19;21;23;29;30;31;32;34;36;37;39;41;42;43;44];
    
else
    dataset1 = trainset;
    dataset2 = testset;
end

%----------------- inicializacao das variaveis
dados1  = [];
rotulo1 = [];
dados2  = [];
rotulo2 = [];
%-------------------------------

%carrega dos arquivos e separa apenas os batimentos desejados
for i=1:size(dataset1,1)
    [data target] = loadarq(FV(dataset1(i)).featureVector);
    dados1 = [dados1;data]; clear data;
    rotulo1 = [rotulo1;target];    clear target;
end

for i=1:size(dataset2,1)
    [data target] = loadarq(FV(dataset2(i)).featureVector);
    dados2 = [dados2;data]; clear data;
    rotulo2 = [rotulo2;target];    clear target;
end

%normaliza: X - med / std
%[dados1 dados2] = normaliza(dados1, dados2);

if SMOTE_FLAG == 1
    SMOTE_K = 3; % para o knn
    [newData newTarget] = SMOTE(dados1, rotulo1, 2, 400, SMOTE_K);
    [newData newTarget] = SMOTE(newData, newTarget, 3, 200, SMOTE_K);
    [newData newTarget] = SMOTE(newData, newTarget, 4, 400, SMOTE_K);
    
    p1d = newData;
    p1t = newTarget;
else
    p1d = dados1;
    p1t = rotulo1;
end

p2d = dados2;
p2t = rotulo2;

end

%-------------------- Funo de separao dos tipos
% os rtulos esto em ascii code
% Seguindo o padro AAMI heartbeat classes, Normal (N), supraventricular
% ectopic beat (SVEB), Ventricular ectopic beat(VEB), fusion beat(F) e
% unknown beat (Q)
%
function [data target]=loadarq(amostra)
tam = size(amostra,2);

pos = find(amostra(:,tam)==78); % N -> N
N = amostra(pos,1:tam-1);
sz = size(N,1);
tN = repmat([1 0 0 0 0],sz,1);

pos = find(amostra(:,tam)==76); % L -> N
L = amostra(pos,1:tam-1);
sz = size(L,1);
tL = repmat([1 0 0 0 0],sz,1);

pos = find(amostra(:,tam)==82);  % R -> N
R  = amostra(pos,1:tam-1);
sz = size(R,1);
tR = repmat([1 0 0 0 0],sz,1);

pos = find(amostra(:,tam)==65); % A -> SVEB
A  = amostra(pos,1:tam-1);
sz = size(A,1);
tA = repmat([0 1 0 0 0],sz,1);

pos = find(amostra(:,tam)==86);  % V -> VEB
V  = amostra(pos,1:tam-1);
sz = size(V,1);
tV = repmat([0 0 1 0 0],sz,1);

pos = find(amostra(:,tam)==47);  % paced (/) -> Q
P  = amostra(pos,1:tam-1);
sz = size(P,1);
tP = repmat([0 0 0 0 1],sz,1);

pos = find(amostra(:,tam)==97);  % a -> SVEB
a  = amostra(pos,1:tam-1);
sz = size(a,1);
ta = repmat([0 1 0 0 0],sz,1);

pos = find(amostra(:,tam)==70);  % F -> F
F = amostra(pos,1:tam-1);
sz = size(F,1);
tF = repmat([0 0 0 1 0 ],sz,1);

pos = find(amostra(:,tam)==106);  % j -> N
j  = amostra(pos,1:tam-1);
sz = size(j,1);
tj = repmat([1 0 0 0 0],sz,1);

pos = find(amostra(:,tam)==102);  % f -> Q
f = amostra(pos,1:tam-1);
sz = size(f,1);
tf = repmat([0 0 0 0 1],sz,1);

pos = find(amostra(:,tam)==69);  % E -> VEB
E  = amostra(pos,1:tam-1);
sz = size(E,1);
tE = repmat([0 0 1 0 0],sz,1);

pos = find(amostra(:,tam)==74);  % J -> SVEB
J  = amostra(pos,1:tam-1);
sz = size(J,1);
tJ = repmat([0 1 0 0 0],sz,1);

pos = find(amostra(:,tam)==101);  % e -> N
e  = amostra(pos,1:tam-1);
sz = size(e,1);
te = repmat([1 0 0 0 0],sz,1);

pos = find(amostra(:,tam)==83);  % S -> SVEB
S  = amostra(pos,1:tam-1);
sz = size(S,1);
tS = repmat([0 1 0 0 0],sz,1);

pos = find(amostra(:,tam)==81);  % Q -> Q
Q  = amostra(pos,1:tam-1);
sz = size(Q,1);
tQ = repmat([0 0 0 0 1],sz,1);

data = [N;L;R;A;V;P;a;F;S;j;f;E;J;e;Q];
target = [tN;tL;tR;tA;tV;tP;ta;tF;tS;tj;tf;tE;tJ;te;tQ];
end

