function [f_signals]=hp_medSR(signals,SR);
%usage function [f_signals]=hp(signals,SR);
%Filter signals with median high pass filter.
%For baseline wnder correction
%SR is sample rate
%signals must be COLUMN vectors

%Philip de Chazal 23-9-98

format long e;

if nargin==0
   error('No signals to filter!!');
end

K=round(0.2*SR)+1;
K1=round(0.6*SR)+1;
K2=1000000; %Signal Section size in samples

%old version that runs into memeory problems with large signals
%for i=1:size(signals,2)
%   temp = sortfilt(signals(:,i),K,0); %Remove QRS with 200ms filter
%   temp = sortfilt(temp,K1,0);  %Remove T waves with 600ms median filter
%   f_signals(:,i) = signals(:,i)-temp;                %Remove the baseline wander
%end;

%Divide signals into sections and process the sections separately.
%The sections overlap slightly to allow for filter transients.

f_signals=signals*0;
[LenSig,NumSig]=size(signals);
for i=1:NumSig
   
   for j=1:K2:LenSig
      %Sections are overlapped by 2*K1+1 points. 
      %This probably a bit conservative i.e I think could overlap by K1+K points.
      l=j-K1;            
      u=j+K2-1+K1;
      if l<1 & u>LenSig
         %Only 1 section
         sig1= sortfilt(signals(:,i),K,0); %Remove QRS with 200ms filter
         sig1 = sortfilt(sig1,K1,0);  %Remove T waves with 600ms median filter
         f_signals(:,i) = signals(:,i)-sig1;    %Remove the baseline wander
      elseif l<=1   
         %First section
         temp= sortfilt(signals(1:u,i),K,0); %Remove QRS with 200ms filter
         temp = sortfilt(temp,K1,0);  %Remove T waves with 600ms median filter
         f_signals(1:u-K1,i)=signals(1:u-K1,i)-temp(1:u-K1);%Remove the baseline wander. Ignore last K1 points of filtered signal
      elseif u>=LenSig
         %Last section
         temp= sortfilt(signals(l:LenSig,i),K,0); %Remove QRS with 200ms filter
         temp = sortfilt(temp,K1,0);  %Remove T waves with 600ms median filter
         f_signals(l+K1:LenSig,i)=signals(l+K1:LenSig,i)-temp(K1+1:end);%Remove the baseline wander. Ignore first K1 points of filtered signal
      else
         %A middle section
         temp= sortfilt(signals(l:u,i),K,0); %Remove QRS with 200ms filter
         temp = sortfilt(temp,K1,0);  %Remove T waves with 600ms median filter
         f_signals(l+K1:u-K1,i)=signals(l+K1:u-K1,i)-temp(K1+1:end-K1); %Remove the baseline wander. Ignore first and last K1 points of filtered signal
         
      end
   end
end
