% Autor : Eduardo Luz
% fun�?o : extrair caracter�sticas do sinal de ECG com VCG
%
% see also : http://physionet.org/physiotools/wpg/wpg_btoc.htm

% FEATUREEXTRACTION  Extrai caracter�sticas do sinal de ECG e grava em
% mem�ria
%
% featureExtraction(recordedSignal)
%
% recordedSignal : Sinal de ECG para an�lise
%
%
function featureVector = VCGFeatureExtraction(ecgDII, ecgDV1, anns, annsPUWave, n, t0, tq, beat)

 
    % redes complexas
   % n=2;
   % t0=0.05;
   % tq=0.300;
   
%percorre as anota�?es
numAnnotation = length(beat); % numero de anotacoes totais
featureVector = [];

kk=1;
for i=2:numAnnotation-1,   
    
    flag_no_pWave = false;
    flag_no_tWave = false;

    % -- Caracter�sticas extra�das do ritmo
    featureRR1 = (beat(i).nPeak - beat(i-1).nPeak);
    featureRR2 = (beat(i+1).nPeak - beat(i).nPeak);
    
    % --- Caracter�sticas extra�das da morfologia
    % Para 360Hz, o tempo entre as amostras � de 2.8ms.
    
    % --- Start point da onda P
    if(~isempty(beat(i).pOnset))
        pStartPoint = beat(i).pOnset;
    else
        flag_no_pWave = true;
    end
    
    % --- Start point da onda T
    if(~isempty(beat(i).tOnset))
        tStartPoint = beat(i).tOnset;
    else
        flag_no_tWave = true;
    end
    
    % --- Start point do complexo QRS
    qrsStartPoint = beat(i).nOnset; % SeparaFP garante que haja complexos QRS em cada batimento
    
    % --- Start point do batimento inteiro
    if(~flag_no_pWave)
        beatStartPoint = beat(i).pOnset;
    else
        if(beat(i).nPeak- 100 <= 0)
            beatStartPoint = 1;
        else
            beatStartPoint = beat(i).nPeak-100;
        end
    end
    
    
    % --- End point da onda P
    if(~flag_no_pWave)
        pEndPoint = beat(i).pOffset;
    end
    
    % --- End point da onda T
    if(~flag_no_tWave)
        tEndPoint = beat(i).tOffset;
    end
    
    % --- End point do complexo QRS
    qrsEndPoint = beat(i).nOffset; % SeparaFP garante que haja complexos QRS em cada batimento
    
    % --- End point do batimento inteiro
    if(~flag_no_tWave)
        beatEndPoint = beat(i).tOffset;
    else
        if(beat(i).nPeak+ 200 > size(ecgDII))
            beatEndPoint = size(ecgDII);
        else
            beatEndPoint = beat(i).nPeak + 200;
        end
    end
    
    beatWaveDII = ecgDII(beatStartPoint : beatEndPoint) ;     
    beatWaveDV1 = ecgDV1(beatStartPoint : beatEndPoint) ;     
    if(~flag_no_tWave)
        tWaveDII = ecgDII(tStartPoint : tEndPoint) ;     
        tWaveDV1 = ecgDV1(tStartPoint : tEndPoint) ; 
    end
    if(~flag_no_pWave)
        pWaveDII = ecgDII(pStartPoint : pEndPoint) ;     
        pWaveDV1 = ecgDV1(pStartPoint : pEndPoint) ; 
    end
    qrsWaveDII = ecgDII(qrsStartPoint : qrsEndPoint) ;     
    qrsWaveDV1 = ecgDV1(qrsStartPoint : qrsEndPoint) ; 
    % se o sinal for menor, completa com zero
   % if( (size(beatWaveDII,1) < 301) && (size(beatWaveDV1,1) < 301) )
   %     beatWaveDII = [beatWaveDII;zeros(301-size(beatWaveDII,1),1)];
   %     beatWaveDV1 = [beatWaveDV1;zeros(301-size(beatWaveDV1,1),1)];
   % end
    
    debugPlot = 0;
    if(anns(i).typeMnemonic == 'N' && numAnnotation >300 && debugPlot == 1)
        figH = figure(1);
        plot(beatWaveDII,beatWaveDV1,'k'); % plota de preto
        figure(2);
        plot(beatWaveDII, 'k'); % plota de preto
        hold on;
        plot(anns(i).sampleNumber - startPoint, max(beatWaveDII) , 'o')
    %    axis off
    %    saveas(figH, 'file.bmp', 'bmp')
    %    %hold off
    end
    
    vcgBeat = [beatWaveDII beatWaveDV1];
    if(~flag_no_pWave)
        vcgPWave = [pWaveDII pWaveDV1];
    end
    if(~flag_no_tWave)
        vcgTWave= [tWaveDII tWaveDV1];
    end
    vcgQRSWave= [qrsWaveDII qrsWaveDV1]; 
    %tinc=(tq - t0)/(n-1);
    
    x = 0:n-1;
    t=t0+x*(tq-t0)/(n-1);

    dvBeat = degreevector(vcgBeat,t);
    %matrix(i,:) = vaux;
    pvBeat = probvector(vcgBeat,t);
    
    dvQrsWave = degreevector(vcgQRSWave,t);
    pvQrsWave = probvector(vcgQRSWave,t);
    
    if(~flag_no_tWave)
        dvTWave = degreevector(vcgTWave,t);
        pvTWave = probvector(vcgTWave,t);
    else
        dvTWave = ones(1,length(dvBeat));
        pvTWave = ones(1,length(pvBeat));
    end
    
    if(~flag_no_pWave)
        dvPWave = degreevector(vcgPWave,t);
        pvPWave = probvector(vcgPWave,t);
    else
        dvPWave = ones(1,length(dvBeat));
        pvPWave = ones(1,length(pvBeat));
    end
    
    
        
    
    %% USA ecgPUWAVE para outroas informa��es relevantes
      %% Extrai features da morfologia
    %http://www.physionet.org/physiobank/annotations.shtml
    %Non-beat annotations    
    %CodeDescription:
    % (		Waveform onset
    % )		Waveform end
    % p		Peak of P-wave
    % t		Peak of T-wave
    % u		Peak of U-wave
    % PQ    junction

    indexN=0;
    indexT=0;
    indexP=0;
    
    %for p=1:numAnnotationPU,
    %    if((annsPUWave(p).sampleNumber >= anns(i).sampleNumber-10) && annsPUWave(p).sampleNumber <= anns(i).sampleNumber+10 &&(annsPUWave(p).typeMnemonic == 'N' || annsPUWave(p).typeMnemonic == '.' || annsPUWave(p).typeMnemonic == 'a' || annsPUWave(p).typeMnemonic == 'A'))
    %        indexN=p;
    %        break;
    %    end        
    %end    
    
    if beat(i).nPeak-100 > 0
        ind = find([annsPUWave(:).sampleNumber]>= anns(i).sampleNumber-100);
        j=1;
    end
    
    
    % acah index N
    while ~isempty(ind) && j<length(ind) && annsPUWave(ind(j)).typeMnemonic ~= 'N' && annsPUWave(ind(j)).sampleNumber < anns(i).sampleNumber+200
        j = j+1;
    end
    
    if(~isempty(ind) && annsPUWave(ind(j)).typeMnemonic == 'N')
        indexN=ind(j);
        
    else
        indexN=0;
        
    end
    
    if indexN>0
        % acha index T
        j=1;
        while ~isempty(ind) && j<length(ind) && (annsPUWave(ind(j)).typeMnemonic ~= 't') && annsPUWave(ind(j)).sampleNumber < anns(i).sampleNumber+200
            j = j+1;
        end

        if(~isempty(ind) && annsPUWave(ind(j)).typeMnemonic == 't')
            indexT=ind(j);
        else
            indexT=0;
        end

        % acha index P
        j=1;
        while ~isempty(ind) && j<length(ind) && annsPUWave(ind(j)).typeMnemonic ~= 'p' && annsPUWave(ind(j)).sampleNumber < anns(i).sampleNumber+200
            j = j+1;
        end

        if(~isempty(ind) && (annsPUWave(ind(j)).typeMnemonic == 'p'))
            indexP=ind(j);
        else
            indexP=0;
        end
    end
    
    
      % Caracter�sticas do batimento
     if(indexN>0)  
            QRSDuration = annsPUWave(indexN+1).sampleNumber - annsPUWave(indexN-1).sampleNumber;

            if indexT <= 0
                TwaveDuration=-1;
            else
                if( annsPUWave(indexT+1).typeMnemonic == ')')
                    TwaveDuration = annsPUWave(indexT+1).sampleNumber - annsPUWave(indexT-1).sampleNumber;
                else
                    TwaveDuration = annsPUWave(indexT+2).sampleNumber - annsPUWave(indexT-1).sampleNumber;
                end
            end

            pWave = [];

            if(indexP>0)
                PWaveFlag = 1;
                PWaveDuration = annsPUWave(indexP+1).sampleNumber - annsPUWave(indexP-1).sampleNumber;

                pWave = ecgDII(annsPUWave(indexP-1).sampleNumber : annsPUWave(indexP+1).sampleNumber);
                pWave_area = trapz(pWave.^2);

                PWaveAmplitudeDII = ecgDII(annsPUWave(indexP).sampleNumber);
                PWaveAmplitudeDV1 = ecgDV1(annsPUWave(indexP).sampleNumber);

                if indexT>0
                    PTwaveWidth = annsPUWave(indexT).sampleNumber-annsPUWave(indexP).sampleNumber;
                else
                    PTwaveWidth=-1;
                end

                PRSegment = anns(i).sampleNumber - annsPUWave(indexP).sampleNumber;
            else
                pWave_area=0;
                PWaveFlag = -1;
                PWaveDuration = 0;
                PWaveAmplitudeDII = 0;
                PWaveAmplitudeDV1 = 0;
                PTwaveWidth=0;
                PRSegment = 0;
            end  
        
     else
         pWave_area=0;
        QRSDuration = 0;
        TwaveDuration = 0;
        PWaveFlag = -1;  
        PWaveDuration = 0;
        PWaveAmplitudeDII = 0;
        PWaveAmplitudeDV1 = 0;
        PTwaveWidth=0;
        PRSegment = 0;
     end
      
  
    % Escreve caracter�sticas do batimentos em arquivo
%     fprintf(arq, '%f ' ,QRSDuration);
     %fprintf(arq, '%f ' ,TwaveDuration);
     %fprintf(arq, '%f ' ,PWaveFlag);
     %fprintf(arq, '%f ' ,PWaveDuration);
 %    fprintf(arq, '%f ' ,PTwaveWidth);
     %fprintf(arq, '%f ' ,PWaveAmplitudeDII);
     %fprintf(arq, '%f ' ,PWaveAmplitudeDV1);
  %   fprintf(arq, '%f ' ,pWave_area);
     
     %% Escreve no vetor de features
    %featureVector(kk,:) = [featureRR1 featureRR2 10000*dv 10000*pv QRSDuration PTwaveWidth PWaveFlag PRSegment int32(anns(i).typeMnemonic)];
	featureVector(kk,:) = [featureRR1 featureRR2 10000*dvBeat 10000*pvBeat 10000*dvPWave 10000*pvPWave 10000*dvTWave 10000*pvTWave 10000*dvQrsWave 10000*pvQrsWave int32(anns(i).typeMnemonic)];
    kk = kk+1;
end

end