% Autor : Eduardo Luz, Modificado por: Gabriel Garcia
% funo : extrair caractersticas do sinal de ECG com VCG
%
% see also : http://physionet.org/physiotools/wpg/wpg_btoc.htm

% FEATUREEXTRACTION  Extrai caractersticas do sinal de ECG e grava em memria
%
% featureExtraction(recordedSignal)
%
% recordedSignal : Sinal de ECG para anlise
%
%

%Chamada: MultipleFeatureExtraction_VCG3D(DB(1,i).ecgDII, DB(1,i).ecgDV1, DB(1,i).anns, DB(1,i).annsPUWave, n, t0, tq, PUWaveDB(i).beat)
function featureVector = VCG3DFeatureExtraction_PSO(ecgDII, ecgDV1, anns, annsPUWave, n, t0, tq, beat)

% ----------------- Extrao das caractersticas

%percorre as anotaes

annSize = size(beat);
numAnnotation = annSize(2); % numero de anotacoes dos eventos relacionados com as curvas dos registross

%% Pr-calcula mdias
%Todo o registro  dividido em 6 intervalos de 5 minutos.
%     % 5 minutos -> 300 segundos
%     % o intervalo entre as amostras tem 2.777ms,
% O intervalo em segundos  5 * 60 = 300

kk=1;

% 10 batimenos no nicio e fim de cada registro so descartados, para o
% clculo da mdia local de RR
for i=10:numAnnotation-10,
  
    %% --- VCG 3D
    
    % -- Caracter�sticas extra�das do ritmo
    featureRR1 = (beat(i).nPeak - beat(i-1).nPeak);
    featureRR2 = (beat(i+1).nPeak - beat(i).nPeak);
    
    % --- Caracter�sticas extra�das da morfologia
    % Para 360Hz, o tempo entre as amostras � de 2.8ms.
    
    % --- Start point do batimento inteiro
    
    if(beat(i).nPeak- 100 <= 0)
        beatStartPoint = 1;
    else
        beatStartPoint = beat(i).nPeak-100;
    end
    
    % --- End point do batimento inteiro
    
    if(beat(i).nPeak+ 200 > size(ecgDII))
        beatEndPoint = size(ecgDII);
    else
        beatEndPoint = beat(i).nPeak + 200;
    end
    beatWaveDII = ecgDII(beatStartPoint : beatEndPoint) ;
    beatWaveDV1 = ecgDV1(beatStartPoint : beatEndPoint) ;
    
    %% so extrai se o batimento tiver o tamanho 301
    
    if size(beatWaveDII,1) == 301 && (size(beatWaveDII,1) == size(beatWaveDV1,1))
        
        tempo = 1:1:size(beatWaveDII,1);
        vcgBeat = [beatWaveDII beatWaveDV1 tempo'];
        x = 0:n-1;
        t=t0+x*(tq-t0)/(n-1);
        
        %% extrai as features do grafo completo considerando o tempo (3d)
        dvBeat = degreevector3D(vcgBeat,t);
        pvBeat = probvector3D(vcgBeat,t);
        
        %% cria vetor
        %% Escreve no vetor de features
        featureVector(kk,:) = [10000*featureRR1 10000*featureRR2 10000*dvBeat 10000*pvBeat int32(beat(i).nLabel)];
        kk = kk+1;
    end
    
    
end


