% Autor : Eduardo Luz, Modificado por: Gabriel Garcia
% funo : extrair caractersticas do sinal de ECG com VCG
%
% see also : http://physionet.org/physiotools/wpg/wpg_btoc.htm

% FEATUREEXTRACTION  Extrai caractersticas do sinal de ECG e grava em memria
%
% featureExtraction(recordedSignal)
%
% recordedSignal : Sinal de ECG para anlise
%
%

%Chamada: MultipleFeatureExtraction_VCG3D(DB(1,i).ecgDII, DB(1,i).ecgDV1, DB(1,i).anns, DB(1,i).annsPUWave, n, t0, tq, PUWaveDB(i).beat)
function featureVector = MultipleFeatureExtraction_VCG3D(ecgDII, ecgDV1, anns, annsPUWave, n, t0, tq, beat)

% ----------------- Extrao das caractersticas

%percorre as anotaes
annSize = size(beat);
numAnnotation = annSize(2); % numero de anotacoes dos eventos relacionados com as curvas dos registros
annPUSize = size(annsPUWave);
numAnnotationPU = annPUSize(2); % numero de anotacoes extras conseguidas com o ecgPUWave (ondas P, Q, R, S e T)


%% Pr-calcula mdias
%Todo o registro  dividido em 6 intervalos de 5 minutos.
%     % 5 minutos -> 300 segundos
%     % o intervalo entre as amostras tem 2.777ms,
% O intervalo em segundos  5 * 60 = 300
freqSample = 360;
SAMPLE_TIME = 1/freqSample; % tempo em segundos entre as amostas
INTERVAL = 300;

%%

debugp1=0;
debugp0=0;
debugN1=0;
debugN0=0;

kk=1;

% 10 batimenos no nicio e fim de cada registro so descartados, para o
% clculo da mdia local de RR
for i=10:numAnnotation-10,
    % --- Caractersticas extradas da morfologia
    % Para 360Hz, o tempo entre as amostras  de 2.8ms.
    % os autores utilizaram uma janela de 64 amostras, onde o pico R  o centro
    
    if(anns(i).sampleNumber - 99 <= 0)
        startPoint = 1;
    else
        startPoint = anns(i).sampleNumber - 99;
    end
    
    if(anns(i).sampleNumber + 200 > size(ecgDII,1))
        endPoint = size(ecgDII);
    else
        endPoint = anns(i).sampleNumber + 200;
    end
    
    beatWaveDII = ecgDII(startPoint : endPoint) ;
    %beatWaveDV1 = ecgDV1(startPoint : endPoint) ;
    
    %% extrai caraceristicas com autocorrelacao (Yu e Chen 2007)
    % os autores utilizaram HAAR como mother wavelet
    wname = 'haar';
    % approximation = Approximation coefficients vector CA
    % detail = Detail coefficients vector
    [aproximation1_DII, details1_DII] = dwt(beatWaveDII ,wname);
    [aproximation2_DII, details2_DII] = dwt(aproximation1_DII ,wname);
    
    % Variancia da funcao de auto-correlacao
    lag = 1; %  assumindo L=1
    
    % 1 - Variancia do QRS
    varQRS = var(beatWaveDII);
    
    % 2 - Variancia dos coeficientes em cada sub-banda da WT
    varD1 = var(details1_DII,lag);
    varD2 = var(details2_DII,lag);
    varA2 = var(aproximation2_DII,lag);
    
    % 4 - Razo entre minimo e maximo
    if max(details1_DII)<0.00000001
        minmaxD1 = 0;
    else
        minmaxD1 = min(details1_DII)/max(details1_DII);
    end
    
    if max(details2_DII)<0.00000001
        minmaxD2 = 0;
    else
        minmaxD2 = min(details2_DII)/max(details2_DII);
    end
    
    
    if max(aproximation2_DII)< 0.00000001
        minmaxA2 = 0;
    else
        minmaxA2 = min(aproximation2_DII)/max(aproximation2_DII);
    end
    
    %% -- Caracterstica  (INTERVALO RR)
    % --- Caractersticas 12 e 13
    % localRR = mdias dos 10 intervalos em torno do QRS
    for r=1:10
        localRR(r) = ((anns(i+5-r).sampleNumber - anns(i+4-r).sampleNumber)*SAMPLE_TIME);
    end
    
    avgLocalRR = mean(localRR);
    
    % intervalos previos RR e posterior RR RELATIVOS
    relPrevRR = (((anns(i).sampleNumber - anns(i-1).sampleNumber)*SAMPLE_TIME)/avgLocalRR);
    relPostRR = (((anns(i+1).sampleNumber - anns(i).sampleNumber)*SAMPLE_TIME)/avgLocalRR);
    
    % -- Caracter�sticas extradas do ritmo
    %featureRR1 = (beat( i).nPeak - beat(i-1).nPeak);
    %featureRR2 = (beat(i+1).nPeak - beat(i).nPeak);
    
    %% ---- largura de SEGMENTOS
    %http://www.physionet.org/physiobank/annotations.shtml
    %Non-beat annotations
    %CodeDescription:
    % (		Waveform onset
    % )		Waveform end
    % p		Peak of P-wave
    % t		Peak of T-wave
    % u		Peak of U-wave
    % PQ    junction
    
    indexN=0;
    indexT=0;
    indexP=0;
    
    %for p=1:numAnnotationPU,
    %    if((annsPUWave(p).sampleNumber >= anns(i).sampleNumber-10) && annsPUWave(p).sampleNumber <= anns(i).sampleNumber+10 &&(annsPUWave(p).typeMnemonic == 'N' || annsPUWave(p).typeMnemonic == '.' || annsPUWave(p).typeMnemonic == 'a' || annsPUWave(p).typeMnemonic == 'A'))
    %        indexN=p;
    %        break;
    %    end
    %end
    
    % 60 amostras ~= 150ms
    % 90 amostras ~= 250ms
    ind = find([annsPUWave(:).sampleNumber]>= anns(i).sampleNumber-60);
    j=1;
    
    % acah index N
    while ~isempty(ind) && j<length(ind) && annsPUWave(ind(j)).typeMnemonic ~= 'N' && annsPUWave(ind(j)).sampleNumber < anns(i).sampleNumber+90
        j = j+1;
    end
    
    if(~isempty(ind) && annsPUWave(ind(j)).typeMnemonic == 'N')
        indexN=ind(j);
        
    else
        indexN=0;
        
    end
    
    if indexN>0
        % acha index T
        j=1;
        while ~isempty(ind) && j<length(ind) && (annsPUWave(ind(j)).typeMnemonic ~= 't') && annsPUWave(ind(j)).sampleNumber < anns(i).sampleNumber+90
            j = j+1;
        end
        
        if(~isempty(ind) && annsPUWave(ind(j)).typeMnemonic == 't')
            indexT=ind(j);
        else
            indexT=0;
        end
        
        % acha index P
        j=1;
        while ~isempty(ind) && j<length(ind) && annsPUWave(ind(j)).typeMnemonic ~= 'p' && annsPUWave(ind(j)).sampleNumber < anns(i).sampleNumber+90
            j = j+1;
        end
        
        if(~isempty(ind) && (annsPUWave(ind(j)).typeMnemonic == 'p'))
            indexP=ind(j);
        else
            indexP=0;
        end
    end
    
    
    % Caractersticas do batimento
    if(indexN>0)
        QRSDuration = annsPUWave(indexN+1).sampleNumber - annsPUWave(indexN-1).sampleNumber;
        
        if indexT <= 0
            TwaveDuration=-1;
        else
            if( annsPUWave(indexT+1).typeMnemonic == ')')
                TwaveDuration = annsPUWave(indexT+1).sampleNumber - annsPUWave(indexT-1).sampleNumber;
            else
                TwaveDuration = annsPUWave(indexT+2).sampleNumber - annsPUWave(indexT-1).sampleNumber;
            end
        end
        
        pWave = [];
        
        if(indexP>0)
            PWaveFlag = 1;
            PWaveDuration = annsPUWave(indexP+1).sampleNumber - annsPUWave(indexP-1).sampleNumber;
            
            pWave = ecgDII(annsPUWave(indexP-1).sampleNumber : annsPUWave(indexP+1).sampleNumber);
            pWave_area = trapz(pWave.^2);
            
            PWaveAmplitudeDII = ecgDII(annsPUWave(indexP).sampleNumber);
            PWaveAmplitudeDV1 = ecgDV1(annsPUWave(indexP).sampleNumber);
            debugp1 = debugp1+1;
            
            if indexT>0
                PTwaveWidth = annsPUWave(indexT).sampleNumber-annsPUWave(indexP).sampleNumber;
            else
                PTwaveWidth=-1;
            end
        else
            pWave_area=0;
            PWaveFlag = -1;
            PWaveDuration = -1;
            PWaveAmplitudeDII = -1;
            PWaveAmplitudeDV1 = -1;
            PTwaveWidth=-1;
            debugp0 = debugp0+1;
        end
        
    else
        pWave_area=0;
        QRSDuration = -1;
        TwaveDuration = -1;
        PWaveFlag = -1;
        PWaveDuration = -1;
        PWaveAmplitudeDII = -1;
        PWaveAmplitudeDV1 = -1;
        PTwaveWidth=-1;
    end
    
    %% CHAZAL-------------------------------------------------------------------------------
    % Extrai features da morfologia
    %http://www.physionet.org/physiobank/annotations.shtml
    %Non-beat annotations
    %CodeDescription:
    % (		Waveform onset
    % )		Waveform end
    % p		Peak of P-wave
    % t		Peak of T-wave
    % u		Peak of U-wave
    % PQ    junction
    
    if i==54
        a=0;
    end
    % a) Segmented ECG Morphology Features (paper pg. 1199)
    indexN=0;
    indexT=0;
    indexP=0;
    ind = find([annsPUWave(:).sampleNumber]>= anns(i).sampleNumber-60);
    
    j=1;
    
    % acah index N
    while ~isempty(ind) && j<length(ind) && annsPUWave(ind(j)).typeMnemonic ~= 'N' && annsPUWave(ind(j)).sampleNumber < anns(i).sampleNumber+90
        j = j+1;
    end
    
    if(~isempty(ind) && annsPUWave(ind(j)).typeMnemonic == 'N')
        indexN=ind(j);
        debugN1 = debugN1+1;
    else
        indexN=0;
        debugN0 = debugN0+1;
    end
    
    if indexN>0
        % acha index T
        j=1;
        while ~isempty(ind) && j<length(ind) && (annsPUWave(ind(j)).typeMnemonic ~= 't' || annsPUWave(ind(j)).typeMnemonic ~= 'T') && annsPUWave(ind(j)).sampleNumber < anns(i).sampleNumber+90
            j = j+1;
        end
        
        if(~isempty(ind) && annsPUWave(ind(j)).typeMnemonic == 't')
            indexT=ind(j);
        else
            indexT=0;
        end
        
        % acha index P
        j=1;
        while ~isempty(ind) && j<length(ind) && annsPUWave(ind(j)).typeMnemonic ~= 'p' && annsPUWave(ind(j)).sampleNumber < anns(i).sampleNumber+90
            j = j+1;
        end
        
        if(~isempty(ind) && (annsPUWave(ind(j)).typeMnemonic == 'p' || annsPUWave(ind(j)).typeMnemonic == 'P'))
            indexP=ind(j);
        else
            indexP=0;
        end
    end
    
    if(indexN>0)
        indexToStart=indexN-1;% incio do QRS
        startPoint = annsPUWave(indexToStart).sampleNumber;
        midPoint = annsPUWave(indexN+1).sampleNumber;   % fim do QRS
        
        if midPoint > size(ecgDII,1)
            midPoint = size(ecgDII,1)-2;
        end
        if(indexT>0)
            if( annsPUWave(indexT+1).typeMnemonic == ')')
                indexToEnd = indexT+1;  % fim da onda T
            else
                indexToEnd = indexT+2;  % fim da onda T
            end
            
            endPoint = annsPUWave(indexToEnd).sampleNumber;
        else
            endPoint = annsPUWave(indexToStart).sampleNumber + 214;  % Se no houver onda T, considera 600ms pra aps o incio
        end
        
        if endPoint > size(ecgDII,1)
            endPoint = size(ecgDII,1);
        end
        
    else
        % considera os 600ms : 100ms ants da onda R e 500ms depois
        if(anns(i).sampleNumber - 36 <= 0)
            startPoint = 1;
        else
            startPoint = anns(i).sampleNumber - 36;
        end
        midPoint = startPoint + 71;   % fim do QRS (200ms aps incio)
        if(anns(i).sampleNumber + 214 > size(ecgDII,1))
            endPoint = size(ecgDII);
        else
            endPoint = startPoint + 214; % 600ms
        end
    end
    
    % -- Caractersticas Morfolgicas 1A
    firstWnd = ecgDII(startPoint:midPoint);
    xi=1:size(firstWnd,1)/10:size(firstWnd,1);
    yi = interp1(firstWnd,xi);
    
    plotDebug=0;
    if(plotDebug)
        figure
        plot(firstWnd);
        hold on
        plot(xi,yi,'o');
    end
    
    secWnd = ecgDII(midPoint:endPoint);
    xii=1:size(secWnd,1)/9:size(secWnd,1);
    if(size(secWnd,1)~=0)
        yii = interp1(secWnd,xii);
    else
        yii = [0 0 0 0 0 0 0 0 0];
    end
    morphFeatures1A = [yi yii];
    
    % -- Caractersticas Morfolgicas 2A - Normaliza sinal com zscore
    firstWnd = ecgDII(startPoint:midPoint);
    firstWnd=zscore(firstWnd);
    xi=1:size(firstWnd,1)/10:size(firstWnd,1);
    yi = interp1(firstWnd,xi);
    secWnd = ecgDII(midPoint:endPoint);
    secWnd=zscore(secWnd);
    xii=1:size(secWnd,1)/9:size(secWnd,1);
    %xii(end+1)=size(secWnd,1);
    if(size(secWnd,1)~=0)
        yii = interp1(secWnd,xii);
    else
        yii = [0 0 0 0 0 0 0 0 0];
    end
    morphFeatures2A = [yi yii];
    
    % -- Caractersticas Morfolgicas 1B
    firstWnd = ecgDV1(startPoint:midPoint);
    xi=1:size(firstWnd,1)/10:size(firstWnd,1);
    yi = interp1(firstWnd,xi);
    secWnd = ecgDV1(midPoint:endPoint);
    xii=1:size(secWnd,1)/9:size(secWnd,1);
    %xii(end+1)=size(secWnd,1);
    if(size(secWnd,1)~=0)
        yii = interp1(secWnd,xii);
    else
        yii = [0 0 0 0 0 0 0 0 0];
    end
    morphFeatures1B = [yi yii];
    
    % -- Caractersticas Morfolgicas 2B - Normaliza sinal com zscore
    firstWnd = ecgDV1(startPoint:midPoint);
    firstWnd=zscore(firstWnd);
    xi=1:size(firstWnd,1)/10:size(firstWnd,1);
    yi = interp1(firstWnd,xi);
    secWnd = ecgDV1(midPoint:endPoint);
    secWnd=zscore(secWnd);
    xii=1:size(secWnd,1)/9:size(secWnd,1);
    if(size(secWnd,1)~=0)
        yii = interp1(secWnd,xii);
    else
        yii = [0 0 0 0 0 0 0 0 0];
    end
    morphFeatures2B = [yi yii];
    
    % Caractersticas do batimento
    if(indexN>1)
        QRSDuration = annsPUWave(indexN+1).sampleNumber - annsPUWave(indexN-1).sampleNumber;
        if( annsPUWave(indexT+1).typeMnemonic == ')')
            TwaveDuration = annsPUWave(indexT+1).sampleNumber - annsPUWave(indexT-1).sampleNumber;
        else
            if indexT-1 <= 0
                if indexT == 0
                    TwaveDuration = annsPUWave(indexT+2).sampleNumber - annsPUWave(1).sampleNumber;
                else
                    TwaveDuration = annsPUWave(indexT+2).sampleNumber - annsPUWave(indexT).sampleNumber;
                end
            else
                TwaveDuration = annsPUWave(indexT+2).sampleNumber - annsPUWave(indexT-1).sampleNumber;
                
            end
        end
        if(indexP>0)
            PWaveFlag = 1;
            debugp1 = debugp1+1;
        else
            PWaveFlag = -1;
            debugp0 = debugp0+1;
        end
    else
        QRSDuration = -1;
        TwaveDuration = -1;
        PWaveFlag = -1;
    end
    
    % b) Fixed-interval ECG Morphology Features (paper pg. 1200)
    
    % 50ms ants da onda R
    if(indexN>1)
        if(annsPUWave(indexN).sampleNumber - 18 <= 0)
            startPoint1 = 1;
        else
            startPoint1 = annsPUWave(indexN).sampleNumber - 18;
        end
        endPoint1 = annsPUWave(indexN).sampleNumber + 36;   % fim do QRS (100ms aps onda R)
        
        startPoint2 = annsPUWave(indexN).sampleNumber + 54; % 150ms aps onda R
        
        if(annsPUWave(indexN).sampleNumber + 180 > size(ecgDII,1))
            endPoint2 = size(ecgDII);
        else
            endPoint2 = annsPUWave(indexN).sampleNumber + 180; % 500ms aps onda R
        end
    else
        if(anns(i).sampleNumber - 18 <= 0)
            startPoint1 = 1;
        else
            startPoint1 = anns(i).sampleNumber - 18;
        end
        endPoint1 = anns(i).sampleNumber + 36;   % fim do QRS (100ms aps onda R)
        
        startPoint2 = anns(i).sampleNumber + 54; % 150ms aps onda R
        
        if(anns(i).sampleNumber + 180 > size(ecgDII,1))
            endPoint2 = size(ecgDII);
        else
            endPoint2 = anns(i).sampleNumber + 180; % 500ms aps onda R
        end
    end
    
    % -- Caractersticas Morfolgicas 3A
    firstWnd = ecgDII(startPoint1:endPoint1);
    xi=1:size(firstWnd,1)/10:size(firstWnd,1);
    %yi = interp1(firstWnd,xi);
    yi = downsample(firstWnd',6);
    secWnd = ecgDII(startPoint2:endPoint2);
    xii=1:size(secWnd,1)/7:size(secWnd,1);
    xii(end+1)=size(secWnd,1);
    %yii = interp1(secWnd,xii);
    yii = downsample(secWnd',18);
    morphFeatures3A = [yi yii];
    
    % -- Caractersticas Morfolgicas 4A
    firstWnd = ecgDII(startPoint1:endPoint1);
    firstWnd=zscore(firstWnd);
    xi=1:size(firstWnd,1)/10:size(firstWnd,1);
    yi = interp1(firstWnd,xi);
    secWnd = ecgDII(startPoint2:endPoint2);
    secWnd=zscore(secWnd);
    xii=1:size(secWnd,1)/7:size(secWnd,1);
    xii(end+1)=size(secWnd,1);
    yii = interp1(secWnd,xii);
    
    morphFeatures4A = [yi yii];
    
    % -- Caractersticas Morfolgicas 3B
    firstWnd = ecgDV1(startPoint1:endPoint1);
    xi=1:size(firstWnd,1)/10:size(firstWnd,1);
    yi = interp1(firstWnd,xi);
    secWnd = ecgDV1(startPoint2:endPoint2);
    xii=1:size(secWnd,1)/7:size(secWnd,1);
    xii(end+1)=size(secWnd,1);
    yii = interp1(secWnd,xii);
    
    morphFeatures3B = [yi yii];
    
    % -- Caractersticas Morfolgicas 4B
    firstWnd = ecgDV1(startPoint1:endPoint1);
    firstWnd=zscore(firstWnd);
    xi=1:size(firstWnd,1)/10:size(firstWnd,1);
    yi = interp1(firstWnd,xi);
    
    if(plotDebug)
        figure
        plot(firstWnd);
        hold on
        plot(xi,yi,'o');
    end
    
    secWnd = ecgDV1(startPoint2:endPoint2);
    secWnd=zscore(secWnd);
    xii=1:size(secWnd,1)/7:size(secWnd,1);
    xii(end+1)=size(secWnd,1);
    yii = interp1(secWnd,xii);
    morphFeatures4B = [yi yii];
    
    %% --- VCG 3D
    
    
    flag_no_pWave = false;
    flag_no_tWave = false;
    
    % -- Caracter�sticas extra�das do ritmo
    featureRR1 = (beat(i).nPeak - beat(i-1).nPeak);
    featureRR2 = (beat(i+1).nPeak - beat(i).nPeak);
    
    % --- Caracter�sticas extra�das da morfologia
    % Para 360Hz, o tempo entre as amostras � de 2.8ms.
    
    % --- Start point da onda P
    if(~isempty(beat(i).pOnset))
        pStartPoint = beat(i).pOnset;
    else
        flag_no_pWave = true;
    end
    
    % --- Start point da onda T
    if(~isempty(beat(i).tOnset))
        tStartPoint = beat(i).tOnset;
    else
        flag_no_tWave = true;
    end
    
    % --- Start point do complexo QRS
    qrsStartPoint = beat(i).nOnset; % SeparaFP garante que haja complexos QRS em cada batimento
    
    % --- Start point do batimento inteiro
    if(beat(i).nPeak- 100 <= 0)
        beatStartPoint = 1;
    else
        beatStartPoint = beat(i).nPeak-100;
    end
    
    
    % --- End point da onda P
    if(~flag_no_pWave)
        pEndPoint = beat(i).pOffset;
    end
    
    % --- End point da onda T
    if(~flag_no_tWave)
        tEndPoint = beat(i).tOffset;
    end
    
    % --- End point do complexo QRS
    qrsEndPoint = beat(i).nOffset; % SeparaFP garante que haja complexos QRS em cada batimento
    
    % --- End point do batimento inteiro
    if(beat(i).nPeak+ 200 > size(ecgDII))
        beatEndPoint = size(ecgDII);
    else
        beatEndPoint = beat(i).nPeak + 200;
    end
    
    
    beatWaveDII = ecgDII(beatStartPoint : beatEndPoint) ;
    beatWaveDV1 = ecgDV1(beatStartPoint : beatEndPoint) ;
    
    %% so extrai se o batimento tiver o tamanho 301
    
    if size(beatWaveDII,1) == 301 && (size(beatWaveDII,1) == size(beatWaveDV1,1))
        
        tempo = 1:1:size(beatWaveDII,1);
        vcgBeat = [beatWaveDII beatWaveDV1 tempo'];
        x = 0:n-1;
        t=t0+x*(tq-t0)/(n-1);
        
        %% extrai as features do grafo completo considerando o tempo (3d)
        dvBeat = degreevector3D(vcgBeat,t);
        pvBeat = probvector3D(vcgBeat,t);
        
        if(~flag_no_tWave)
        else
            TwaveDuration = 0;
        end
        
        if(~flag_no_pWave)
            PWaveFlag = 1;
        else
            PWaveFlag = 0;
        end
        
        
        %% Cria vetor
        %Escreve no vetor de features
       if ( size(morphFeatures1A,2) == 19 && size(morphFeatures2A,2) == 19 && size(morphFeatures3A,2) == 18 && size(morphFeatures4A,2) == 18 && size(morphFeatures1B,2) == 19 && size(morphFeatures2B,2) == 19 && size(morphFeatures3B,2) == 18 && size(morphFeatures4B,2) == 18 && QRSDuration ~= 0 )
        feature = [dvBeat*10000 pvBeat*10000 10000*featureRR1 10000*featureRR2 10000*morphFeatures1A 10000*morphFeatures1B 10000*morphFeatures2A 10000*morphFeatures2B 10000*morphFeatures3A 10000*morphFeatures3B 10000*morphFeatures4A 10000*morphFeatures4B 10000*varD1 10000*varD2 10000*varA2 10000*varQRS 10000*minmaxD1 10000*minmaxD2 10000*minmaxA2 10000*avgLocalRR 10000*relPrevRR 10000*relPostRR 10000*PWaveFlag 10000*pWave_area 10000*PWaveDuration 10000*PWaveAmplitudeDII 10000*PWaveAmplitudeDV1 10000*PTwaveWidth 10000*QRSDuration 10000*TwaveDuration int32(anns(i).typeMnemonic)];
        featureVector(kk,:) = feature;
        kk = kk+1;
       end
        
    end
    
end


